/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.base.Verify;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.PathArgumentList;
import org.opendaylight.yangtools.yang.data.api.StackedYangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class StackedReversePathArguments
extends PathArgumentList {
    private final StackedYangInstanceIdentifier identifier;
    private int size;
    private volatile boolean haveSize;

    StackedReversePathArguments(StackedYangInstanceIdentifier identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    private static int calculateSize(YangInstanceIdentifier parent) {
        YangInstanceIdentifier current = parent;
        int i = 1;
        Collection<YangInstanceIdentifier.PathArgument> args;
        while ((args = current.tryReversePathArguments()) == null) {
            Verify.verify((boolean)(current instanceof StackedYangInstanceIdentifier));
            current = current.getParent();
            ++i;
        }
        return i + args.size();
    }

    @Override
    public int size() {
        int ret = this.size;
        if (!this.haveSize) {
            this.size = ret = StackedReversePathArguments.calculateSize(this.identifier.getParent());
            this.haveSize = true;
        }
        return ret;
    }

    @Override
    public boolean contains(Object o) {
        YangInstanceIdentifier.PathArgument srch = (YangInstanceIdentifier.PathArgument)Objects.requireNonNull(o);
        return Iterators.contains(this.iterator(), (Object)srch);
    }

    @Override
    public YangInstanceIdentifier.PathArgument get(int index) {
        return (YangInstanceIdentifier.PathArgument)Iterators.get(this.iterator(), (int)index);
    }

    @Override
    public int indexOf(Object o) {
        YangInstanceIdentifier.PathArgument srch = (YangInstanceIdentifier.PathArgument)Objects.requireNonNull(o);
        return super.indexOf(srch);
    }

    @Override
    public int lastIndexOf(Object o) {
        YangInstanceIdentifier.PathArgument srch = (YangInstanceIdentifier.PathArgument)Objects.requireNonNull(o);
        int ret = -1;
        UnmodifiableIterator<YangInstanceIdentifier.PathArgument> it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (srch.equals(it.next())) {
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    @Override
    @Nonnull
    public UnmodifiableIterator<YangInstanceIdentifier.PathArgument> iterator() {
        return new IteratorImpl(this.identifier);
    }

    private static final class IteratorImpl
    extends UnmodifiableIterator<YangInstanceIdentifier.PathArgument> {
        private StackedYangInstanceIdentifier identifier;
        private Iterator<YangInstanceIdentifier.PathArgument> tail;

        IteratorImpl(StackedYangInstanceIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier);
        }

        public boolean hasNext() {
            return this.tail == null || this.tail.hasNext();
        }

        public YangInstanceIdentifier.PathArgument next() {
            if (this.tail != null) {
                return this.tail.next();
            }
            YangInstanceIdentifier.PathArgument ret = this.identifier.getLastPathArgument();
            YangInstanceIdentifier next = this.identifier.getParent();
            Collection<YangInstanceIdentifier.PathArgument> args = next.tryReversePathArguments();
            if (args != null) {
                this.tail = args.iterator();
                this.identifier = null;
            } else {
                Verify.verify((boolean)(next instanceof StackedYangInstanceIdentifier));
                this.identifier = (StackedYangInstanceIdentifier)next;
            }
            return ret;
        }
    }
}

