/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
abstract class Equivalence<T>
implements Serializable {
    private static final long serialVersionUID = 1L;

    Equivalence() {
    }

    static Equivalence<Object> equals() {
        return Equals.INSTANCE;
    }

    static Equivalence<Object> identity() {
        return Identity.INSTANCE;
    }

    final int hash(T obj) {
        int hash = obj.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        return hash;
    }

    abstract boolean equivalent(T var1, T var2);

    abstract Object readResolve();

    private static final class Identity
    extends Equivalence<Object> {
        private static final long serialVersionUID = 1L;
        static final Identity INSTANCE = new Identity();

        private Identity() {
        }

        @Override
        boolean equivalent(Object first, Object second) {
            return first == second;
        }

        @Override
        Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class Equals
    extends Equivalence<Object> {
        private static final long serialVersionUID = 1L;
        static final Equals INSTANCE = new Equals();

        private Equals() {
        }

        @Override
        boolean equivalent(Object first, Object second) {
            return first.equals(second);
        }

        @Override
        Object readResolve() {
            return INSTANCE;
        }
    }
}

