/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.opendaylight.jsonrpc.bus.api.BusSessionFactory;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.PeerContext;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcMessageError;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcRequestMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcSerializer;
import org.opendaylight.jsonrpc.bus.messagelib.AbstractSession;
import org.opendaylight.jsonrpc.bus.messagelib.PeerContextHolder;
import org.opendaylight.jsonrpc.bus.messagelib.RequestMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.ResponderSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponderSessionImpl
extends AbstractSession
implements MessageListener,
ResponderSession {
    private static final Logger LOG = LoggerFactory.getLogger(ResponderSessionImpl.class);
    private final RequestMessageHandler handler;

    public ResponderSessionImpl(Consumer<AutoCloseable> closeCallback, BusSessionFactory factory, RequestMessageHandler handler, String uri) {
        super(closeCallback, uri);
        this.setAutocloseable((AutoCloseable)factory.responder(uri, (MessageListener)this));
        this.handler = Objects.requireNonNull(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(PeerContext peerContext, String message) {
        LOG.info("Request : {}", (Object)message);
        List incomming = JsonRpcSerializer.fromJson((String)message);
        try {
            PeerContextHolder.set(peerContext);
            for (JsonRpcBaseMessage msg : incomming) {
                if (msg.getType() != JsonRpcBaseMessage.JsonRpcMessageType.REQUEST) {
                    this.reply(peerContext, JsonRpcSerializer.toJson((JsonRpcBaseMessage)JsonRpcMessageError.builder().code(-32600).message("Unexpected message type : " + msg.getType()).build()));
                    return;
                }
                JsonRpcReplyMessage.Builder replyBuilder = (JsonRpcReplyMessage.Builder)JsonRpcReplyMessage.builder().id(msg.getId());
                this.handler.handleRequest((JsonRpcRequestMessage)msg, replyBuilder);
                this.reply(peerContext, JsonRpcSerializer.toJson((JsonRpcBaseMessage)replyBuilder.build()));
            }
        }
        finally {
            PeerContextHolder.remove();
        }
    }

    private void reply(PeerContext peer, String message) {
        LOG.info("Response : {}", (Object)message);
        peer.send(message);
    }
}

