/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import com.google.common.collect.Queues;
import com.google.common.primitives.Ints;
import com.google.gson.JsonObject;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opendaylight.jsonrpc.bus.api.BusSessionFactory;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.PeerContext;
import org.opendaylight.jsonrpc.bus.api.RecoverableTransportException;
import org.opendaylight.jsonrpc.bus.api.Requester;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcRequestMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcSerializer;
import org.opendaylight.jsonrpc.bus.messagelib.AbstractSession;
import org.opendaylight.jsonrpc.bus.messagelib.MessageLibraryException;
import org.opendaylight.jsonrpc.bus.messagelib.MessageLibraryMismatchException;
import org.opendaylight.jsonrpc.bus.messagelib.MessageLibraryTimeoutException;
import org.opendaylight.jsonrpc.bus.messagelib.PeerContextHolder;
import org.opendaylight.jsonrpc.bus.messagelib.ReplyMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.RequesterSession;
import org.opendaylight.jsonrpc.bus.messagelib.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequesterSessionImpl
extends AbstractSession
implements MessageListener,
RequesterSession {
    private static final Logger LOG = LoggerFactory.getLogger(RequesterSessionImpl.class);
    private final Requester requester;
    private final ReplyMessageHandler handler;
    private final BlockingQueue<String> responseQueue = Queues.newLinkedBlockingDeque();
    private final int retryCount;
    private final long retryDelay;

    public RequesterSessionImpl(Consumer<AutoCloseable> closeCallback, BusSessionFactory factory, String uri, ReplyMessageHandler handler) {
        super(closeCallback, uri);
        this.requester = factory.requester(uri, (MessageListener)this);
        this.handler = Objects.requireNonNull(handler);
        this.retryCount = Ints.saturatedCast((long)Util.queryParamValue(uri, "proxyRetryCount", 5L));
        this.retryDelay = Util.queryParamValue(uri, "proxyRetryDelay", 100L);
        this.setAutocloseable((AutoCloseable)this.requester);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(PeerContext peerContext, String message) {
        LOG.debug("Response from {} : {}", (Object)peerContext.channel(), (Object)message);
        List messages = JsonRpcSerializer.fromJson((String)message);
        try {
            PeerContextHolder.set(peerContext);
            for (JsonRpcBaseMessage msg : messages) {
                if (msg.getType() == JsonRpcBaseMessage.JsonRpcMessageType.REPLY) {
                    this.handler.handleReply((JsonRpcReplyMessage)msg);
                    continue;
                }
                throw new MessageLibraryMismatchException(String.format("Requester received %s message", msg.getType().name()));
            }
        }
        finally {
            PeerContextHolder.remove();
        }
    }

    private synchronized void send(String message) {
        if (!this.responseQueue.isEmpty()) {
            throw new RecoverableTransportException("There is unfinished request on this channel, try again later");
        }
        LOG.debug("Sending request : {}", (Object)message);
        this.requester.send(message).addListener((GenericFutureListener)new GenericFutureListener<Future<String>>(){

            public void operationComplete(Future<String> future) throws Exception {
                if (future.isSuccess()) {
                    RequesterSessionImpl.this.responseQueue.add(future.get());
                } else {
                    LOG.warn("Send failed", future.cause());
                }
            }
        });
    }

    @Override
    public String read() {
        try {
            String resp = this.responseQueue.poll(this.timeout, TimeUnit.MILLISECONDS);
            if (resp == null) {
                throw new MessageLibraryTimeoutException(String.format("Message was not received within %d milliseconds", this.timeout));
            }
            return resp;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private JsonRpcReplyMessage readReply(String msg) {
        List replies = JsonRpcSerializer.fromJson((String)msg);
        if (replies.size() == 1) {
            if (((JsonRpcBaseMessage)replies.get(0)).getType() != JsonRpcBaseMessage.JsonRpcMessageType.REPLY) {
                throw new MessageLibraryMismatchException("Unexpected message : " + replies.get(0));
            }
            return (JsonRpcReplyMessage)replies.get(0);
        }
        throw new MessageLibraryException("Unexpected number of replies (1 required) : " + replies.size());
    }

    @Override
    public JsonRpcReplyMessage sendRequestAndReadReply(String name, Object object) {
        return this.sendRequestAndReadReply(name, object, null);
    }

    @Override
    public JsonRpcReplyMessage sendRequestAndReadReply(String name, Object object, JsonObject metadata) {
        this.sendRequest(name, object, metadata);
        return this.readReply(this.read());
    }

    @Override
    public void sendRequest(String method, Object params, JsonObject metadata) {
        this.sendMessage(((JsonRpcRequestMessage.Builder)((JsonRpcRequestMessage.Builder)((JsonRpcRequestMessage.Builder)((JsonRpcRequestMessage.Builder)JsonRpcRequestMessage.builder().idFromIntValue(this.nextId())).method(method)).paramsFromObject(params)).metadata(metadata)).build());
    }

    @Override
    public void sendMessage(JsonRpcBaseMessage msg) {
        this.send(JsonRpcSerializer.toJson((JsonRpcBaseMessage)msg));
    }

    @Override
    public void await() {
        this.requester.awaitConnection();
    }

    @Override
    public int retryCount() {
        return this.retryCount;
    }

    @Override
    public long retryDelay() {
        return this.retryDelay;
    }

    @Override
    public boolean isConnectionReady() {
        return this.requester.isReady();
    }
}

