/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import org.opendaylight.jsonrpc.bus.api.BusSessionFactory;
import org.opendaylight.jsonrpc.bus.api.Publisher;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcNotificationMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcSerializer;
import org.opendaylight.jsonrpc.bus.messagelib.AbstractSession;
import org.opendaylight.jsonrpc.bus.messagelib.PublisherSession;

public class PublisherSessionImpl
extends AbstractSession
implements PublisherSession {
    private Publisher publisher;

    public PublisherSessionImpl(Consumer<AutoCloseable> closeCallback, BusSessionFactory factory, String uri) {
        super(closeCallback, uri);
        this.publisher = factory.publisher(uri);
        this.setAutocloseable((AutoCloseable)this.publisher);
    }

    @Override
    public void publish(String method, JsonElement params) {
        this.publish(method, params, null);
    }

    @Override
    public void publish(String method, JsonElement params, JsonObject metadata) {
        JsonRpcNotificationMessage msg = (JsonRpcNotificationMessage)((JsonRpcNotificationMessage.Builder)((JsonRpcNotificationMessage.Builder)((JsonRpcNotificationMessage.Builder)JsonRpcNotificationMessage.builder().params(params)).method(method)).metadata(metadata)).build();
        this.publisher.publish(JsonRpcSerializer.toJson((JsonRpcBaseMessage)msg));
    }

    @Override
    public void publish(String method, Object params) {
        JsonRpcNotificationMessage msg = (JsonRpcNotificationMessage)((JsonRpcNotificationMessage.Builder)((JsonRpcNotificationMessage.Builder)JsonRpcNotificationMessage.builder().paramsFromObject(params)).method(method)).build();
        this.publisher.publish(JsonRpcSerializer.toJson((JsonRpcBaseMessage)msg));
    }
}

