/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.gson.JsonElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.opendaylight.jsonrpc.bus.api.RecoverableTransportException;
import org.opendaylight.jsonrpc.bus.api.RpcMethod;
import org.opendaylight.jsonrpc.bus.api.UnrecoverableTransportException;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcErrorObject;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcException;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessage;
import org.opendaylight.jsonrpc.bus.messagelib.BaseSession;
import org.opendaylight.jsonrpc.bus.messagelib.MessageLibrary;
import org.opendaylight.jsonrpc.bus.messagelib.NoopReplyMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.ProxyService;
import org.opendaylight.jsonrpc.bus.messagelib.ProxyServiceGenericException;
import org.opendaylight.jsonrpc.bus.messagelib.PublisherSession;
import org.opendaylight.jsonrpc.bus.messagelib.RequesterSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServiceImpl
implements ProxyService {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyServiceImpl.class);
    private static final String TO_STRING_METHOD_NAME = "toString";
    private static final String CLOSE_METHOD_NAME = "close";
    private final ConcurrentMap<Object, BaseSession> proxyMap = new MapMaker().weakKeys().makeMap();
    private final MessageLibrary messaging;

    public ProxyServiceImpl(MessageLibrary messaging) {
        this.messaging = Objects.requireNonNull(messaging);
    }

    @Override
    public <T extends AutoCloseable> T createRequesterProxy(String uri, Class<T> cls) {
        return this.createRequesterProxy(uri, cls, true);
    }

    @Override
    public <T extends AutoCloseable> T createRequesterProxy(String uri, Class<T> cls, boolean skipCache) {
        RequesterSession session = this.messaging.requester(uri, NoopReplyMessageHandler.INSTANCE, skipCache);
        T obj = this.getProxySafe(cls);
        this.proxyMap.put(obj, session);
        return obj;
    }

    @Override
    public <T extends AutoCloseable> T createPublisherProxy(String uri, Class<T> cls) {
        return this.createPublisherProxy(uri, cls, true);
    }

    @Override
    public <T extends AutoCloseable> T createPublisherProxy(String uri, Class<T> cls, boolean skipCache) {
        PublisherSession session = this.messaging.publisher(uri, skipCache);
        T obj = this.getProxySafe(cls);
        this.proxyMap.put(obj, session);
        return obj;
    }

    private void deleteProxy(Object obj) {
        BaseSession session = (BaseSession)this.proxyMap.remove(obj);
        if (session != null) {
            session.close();
        }
    }

    @VisibleForTesting
    static String getMethodName(Method method) {
        if (method.isAnnotationPresent(RpcMethod.class)) {
            return method.getAnnotation(RpcMethod.class).value();
        }
        return method.getName();
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] params) {
        String methodName = ProxyServiceImpl.getMethodName(method);
        BaseSession session = (BaseSession)this.proxyMap.get(obj);
        if (TO_STRING_METHOD_NAME.equals(methodName) && method.getParameterTypes().length == 0) {
            LOG.debug("Proxy for session {}", this.proxyMap.get(obj));
            return null;
        }
        if (CLOSE_METHOD_NAME.equals(methodName) && method.getParameterTypes().length == 0) {
            LOG.debug("Cleaning up proxy instance {}", this.proxyMap.get(obj));
            this.deleteProxy(obj);
            return null;
        }
        if (session instanceof PublisherSession) {
            if (!method.getReturnType().equals(Void.TYPE)) {
                throw new ProxyServiceGenericException("Method expects return value for publisher.");
            }
            ((PublisherSession)session).publish(methodName, params);
            return null;
        }
        if (session instanceof RequesterSession) {
            int configuredRetryCount = ((RequesterSession)session).retryCount();
            long configuredRetryDelay = ((RequesterSession)session).retryDelay();
            int retry = configuredRetryCount;
            while (true) {
                try {
                    JsonRpcReplyMessage reply = ((RequesterSession)session).sendRequestAndReadReply(methodName, params);
                    return this.getReturnFromReplyMessage(method, reply);
                }
                catch (RecoverableTransportException e) {
                    if (retry-- > 0) {
                        LOG.debug("Request to {} failed, will retry ({}/{})", new Object[]{session, configuredRetryCount - retry, configuredRetryCount, e});
                        Uninterruptibles.sleepUninterruptibly((long)configuredRetryDelay, (TimeUnit)TimeUnit.MILLISECONDS);
                        continue;
                    }
                    throw new UnrecoverableTransportException("Request failed after " + configuredRetryCount + " tries", (Throwable)e);
                }
                break;
            }
        }
        throw new ProxyServiceGenericException("Logic error");
    }

    private Object getReturnFromReplyMessage(Method method, JsonRpcReplyMessage replyMsg) {
        if (replyMsg.isError()) {
            JsonRpcErrorObject error = replyMsg.getError();
            throw new ProxyServiceGenericException(error.getMessage(), error.getCode());
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            return null;
        }
        if (method.getReturnType().equals(JsonElement.class)) {
            return replyMsg.getResult();
        }
        try {
            return replyMsg.getResultAsObject(method.getGenericReturnType());
        }
        catch (JsonRpcException e) {
            throw new ProxyServiceGenericException(e);
        }
    }

    @Override
    public Optional<BaseSession> getProxySession(Object proxy) {
        return Optional.ofNullable(this.proxyMap.get(proxy));
    }

    private <T extends AutoCloseable> T getProxySafe(Class<T> cls) {
        return (T)((AutoCloseable)Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, (InvocationHandler)this));
    }
}

