/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import java.lang.reflect.Method;
import java.security.AccessController;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseRequestMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcException;
import org.opendaylight.jsonrpc.bus.messagelib.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCandidate {
    private static final Logger LOG = LoggerFactory.getLogger(MethodCandidate.class);
    private final Method method;
    private final Object handler;
    private Object result;
    private Exception preInvokeFailure;
    private Exception postInvokeFailure;

    public MethodCandidate(Object handler, Method method) {
        this.method = method;
        this.handler = handler;
    }

    private Object[] getArgumentsForMethod(JsonRpcBaseRequestMessage message) throws JsonRpcException {
        Object[] args = new Object[Util.getParametersCount(message)];
        Class<?>[] argsTypes = this.method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            args[i] = message.getParamsAtIndexAsObject(i, argsTypes[i]);
        }
        return args;
    }

    public void invoke(JsonRpcBaseRequestMessage message) {
        Object[] args;
        try {
            args = this.getArgumentsForMethod(message);
        }
        catch (Exception e) {
            LOG.debug("Unable to extract arguments for method", (Throwable)e);
            this.preInvokeFailure = e;
            return;
        }
        try {
            AccessController.doPrivileged(() -> {
                this.method.setAccessible(true);
                return null;
            });
            this.result = this.method.invoke(this.handler, args);
        }
        catch (Exception e) {
            this.postInvokeFailure = e;
            LOG.debug("Invocation of method candidate '{}' failed", (Object)message.getMethod(), (Object)e);
        }
    }

    public boolean isSuccess() {
        return this.preInvokeFailure == null && this.postInvokeFailure == null;
    }

    public Object result() {
        return this.result;
    }

    public Exception getPostInvokeFailure() {
        return this.postInvokeFailure;
    }

    public Exception getPreInvokeFailure() {
        return this.preInvokeFailure;
    }

    public Exception getFailure() {
        if (this.postInvokeFailure != null) {
            return this.postInvokeFailure;
        }
        if (this.preInvokeFailure != null) {
            return this.preInvokeFailure;
        }
        return null;
    }

    public String toString() {
        return "MethodCandidate [method=" + this.method + "]";
    }
}

