/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.opendaylight.jsonrpc.bus.api.BusSessionFactory;
import org.opendaylight.jsonrpc.bus.api.BusSessionFactoryProvider;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.messagelib.AbstractSession;
import org.opendaylight.jsonrpc.bus.messagelib.NotificationMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.PublisherSession;
import org.opendaylight.jsonrpc.bus.messagelib.PublisherSessionImpl;
import org.opendaylight.jsonrpc.bus.messagelib.ReplyMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.RequestMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.RequesterSession;
import org.opendaylight.jsonrpc.bus.messagelib.RequesterSessionImpl;
import org.opendaylight.jsonrpc.bus.messagelib.ResponderSession;
import org.opendaylight.jsonrpc.bus.messagelib.ResponderSessionImpl;
import org.opendaylight.jsonrpc.bus.messagelib.SessionKey;
import org.opendaylight.jsonrpc.bus.messagelib.SubscriberSession;
import org.opendaylight.jsonrpc.bus.messagelib.SubscriberSessionImpl;
import org.opendaylight.jsonrpc.bus.messagelib.TcclBusSessionFactoryProvider;

public class MessageLibrary
implements AutoCloseable,
Consumer<AutoCloseable> {
    private final BusSessionFactory factory;
    private final Collection<AbstractSession> sessions = ConcurrentHashMap.newKeySet();
    private final LoadingCache<SessionKey, AbstractSession> sessionCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<SessionKey, AbstractSession>(){

        public AbstractSession load(SessionKey key) throws Exception {
            return MessageLibrary.this.createSession(key);
        }
    });

    public MessageLibrary(String busType) {
        this(TcclBusSessionFactoryProvider.getInstance(), busType);
    }

    public MessageLibrary(BusSessionFactoryProvider bsfp, String busType) {
        BusSessionFactory desiredFactory = null;
        Iterator it = bsfp.getBusSessionFactories();
        while (it.hasNext()) {
            BusSessionFactory f = (BusSessionFactory)it.next();
            if (!busType.equalsIgnoreCase(f.name())) continue;
            desiredFactory = f;
            break;
        }
        if (desiredFactory == null) {
            throw new IllegalArgumentException(String.format("Bus Type not supported : %s", busType));
        }
        this.factory = desiredFactory;
    }

    public AbstractSession createSession(SessionKey key) {
        AbstractSession session;
        switch (key.type()) {
            case REQ: {
                session = new RequesterSessionImpl(this, this.factory, key.uri(), (ReplyMessageHandler)key.handler());
                break;
            }
            case REP: {
                session = new ResponderSessionImpl(this, this.factory, (RequestMessageHandler)key.handler(), key.uri());
                break;
            }
            case PUB: {
                session = new PublisherSessionImpl(this, this.factory, key.uri());
                break;
            }
            case SUB: {
                session = new SubscriberSessionImpl(this, this.factory, (NotificationMessageHandler)key.handler(), "", key.uri());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported session : " + key.type());
            }
        }
        this.sessions.add(session);
        return session;
    }

    @Override
    public void close() {
        this.sessions.forEach(AbstractSession::close);
        this.factory.close();
    }

    public SubscriberSession subscriber(String uri, NotificationMessageHandler handler, boolean skipCache) {
        SessionKey key = new SessionKey(SessionType.SUB, uri, handler);
        SubscriberSessionImpl session = (SubscriberSessionImpl)(skipCache ? this.createSession(key) : (AbstractSession)this.sessionCache.getUnchecked((Object)key));
        session.addReference();
        return session;
    }

    public PublisherSession publisher(String uri, boolean skipCache) {
        SessionKey key = new SessionKey(SessionType.PUB, uri, SessionKey.NOOP_HANDLER);
        PublisherSessionImpl session = (PublisherSessionImpl)(skipCache ? this.createSession(key) : (AbstractSession)this.sessionCache.getUnchecked((Object)key));
        session.addReference();
        return session;
    }

    public RequesterSession requester(String uri, ReplyMessageHandler handler, boolean skipCache) {
        SessionKey key = new SessionKey(SessionType.REQ, uri, handler);
        RequesterSessionImpl session = (RequesterSessionImpl)(skipCache ? this.createSession(key) : (AbstractSession)this.sessionCache.getUnchecked((Object)key));
        session.addReference();
        return session;
    }

    public ResponderSession responder(String uri, RequestMessageHandler handler, boolean skipCache) {
        SessionKey key = new SessionKey(SessionType.REP, uri, handler);
        ResponderSessionImpl session = (ResponderSessionImpl)(skipCache ? this.createSession(key) : (AbstractSession)this.sessionCache.getUnchecked((Object)key));
        session.addReference();
        return session;
    }

    @Override
    public void accept(AutoCloseable closeable) {
        this.sessionCache.asMap().values().removeIf(c -> c == closeable);
        this.sessions.remove(closeable);
    }

    @VisibleForTesting
    int getSessionCount() {
        return this.sessions.size();
    }
}

