/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import java.net.URISyntaxException;
import org.opendaylight.jsonrpc.bus.messagelib.AbstractTransportFactory;
import org.opendaylight.jsonrpc.bus.messagelib.ReplyMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.RequesterSession;
import org.opendaylight.jsonrpc.bus.messagelib.ResponderSession;
import org.opendaylight.jsonrpc.bus.messagelib.SubscriberSession;
import org.opendaylight.jsonrpc.bus.messagelib.Util;

public final class EndpointBuilders {
    private EndpointBuilders() {
    }

    public static final class ResponderBuilder
    extends BaseEndpointBuilder<ResponderBuilder> {
        private ResponderBuilder(AbstractTransportFactory factory) {
            super(factory);
        }

        public <T extends AutoCloseable> ResponderSession create(String uri, T handler) throws URISyntaxException {
            return this.factory.createResponder(uri, handler, !this.useCache);
        }
    }

    public static final class SubscriberBuilder
    extends BaseEndpointBuilder<SubscriberBuilder> {
        private SubscriberBuilder(AbstractTransportFactory factory) {
            super(factory);
        }

        public <T extends AutoCloseable> SubscriberSession create(String uri, T handler) throws URISyntaxException {
            return this.factory.createSubscriber(uri, handler, !this.useCache);
        }
    }

    public static final class PublisherBuilder
    extends BaseEndpointBuilder<PublisherBuilder> {
        private PublisherBuilder(AbstractTransportFactory factory) {
            super(factory);
        }

        public <T extends AutoCloseable> T createProxy(Class<T> api, String uri) throws URISyntaxException {
            return this.factory.createPublisherProxy(api, uri, !this.useCache);
        }
    }

    public static final class RequesterBuilder
    extends BaseEndpointBuilder<RequesterBuilder> {
        private int proxyRetryCount = 5;
        private long proxyRetryDelay = 100L;
        private long requestTimeout = 30000L;

        private RequesterBuilder(AbstractTransportFactory factory) {
            super(factory);
        }

        public RequesterBuilder withRequestTimeout(long requestTimeoutMilliseconds) {
            this.requestTimeout = requestTimeoutMilliseconds;
            return this;
        }

        public RequesterBuilder withProxyConfig(int retryCount, long delayMiliseconds) {
            this.proxyRetryCount = retryCount;
            this.proxyRetryDelay = delayMiliseconds;
            return this;
        }

        public <T extends AutoCloseable> T createProxy(Class<T> api, String uri) throws URISyntaxException {
            String modified = uri;
            modified = Util.injectQueryParam(modified, "proxyRetryCount", String.valueOf(this.proxyRetryCount));
            modified = Util.injectQueryParam(modified, "proxyRetryDelay", String.valueOf(this.proxyRetryDelay));
            modified = Util.injectQueryParam(modified, "timeout", String.valueOf(this.requestTimeout));
            return this.factory.createRequesterProxy(api, modified, !this.useCache);
        }

        public RequesterSession create(String uri, ReplyMessageHandler handler) throws URISyntaxException {
            return this.factory.createRequester(uri, handler, !this.useCache);
        }
    }

    public static abstract class BaseEndpointBuilder<T extends BaseEndpointBuilder<?>> {
        protected final AbstractTransportFactory factory;
        protected boolean useCache = false;

        BaseEndpointBuilder(AbstractTransportFactory factory) {
            this.factory = factory;
        }

        public T useCache() {
            this.useCache = true;
            return (T)this;
        }
    }

    public static class EndpointBuilder {
        private AbstractTransportFactory factory;

        EndpointBuilder(AbstractTransportFactory factory) {
            this.factory = factory;
        }

        public RequesterBuilder requester() {
            return new RequesterBuilder(this.factory);
        }

        public ResponderBuilder responder() {
            return new ResponderBuilder(this.factory);
        }

        public PublisherBuilder publisher() {
            return new PublisherBuilder(this.factory);
        }

        public SubscriberBuilder subscriber() {
            return new SubscriberBuilder(this.factory);
        }
    }
}

