/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.derbyclient.impl;

import java.net.URI;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.derby.jdbc.ClientConnectionPoolDataSource;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derby.jdbc.ClientDriver;
import org.apache.derby.jdbc.ClientXADataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;

public class DerbyClientDatasourceFactory
implements DataSourceFactory {
    private static final String DERBY_PREFIX = "jdbc:derby:";

    public DataSource createDataSource(Properties props) throws SQLException {
        ClientDataSource ds = new ClientDataSource();
        this.setProperties(ds, props);
        return ds;
    }

    private void setProperties(ClientDataSource ds, Properties properties) throws SQLException {
        Properties props = (Properties)properties.clone();
        String databaseName = (String)props.remove("databaseName");
        if (databaseName != null) {
            ds.setDatabaseName(databaseName);
        }
        String createDatabase = (String)props.remove("createDatabase");
        ds.setCreateDatabase(createDatabase);
        String password = (String)props.remove("password");
        ds.setPassword(password);
        String user = (String)props.remove("user");
        ds.setUser(user);
        String host = (String)props.remove("serverName");
        ds.setServerName(host == null ? "localhost" : host);
        String portNumber = (String)props.remove("portNumber");
        ds.setPortNumber(portNumber != null ? Integer.parseInt(portNumber) : 1527);
        String url = (String)props.remove("url");
        this.applyUrl(ds, url);
        if (!props.isEmpty()) {
            BeanConfig.configure((Object)ds, props);
        }
    }

    private void applyUrl(ClientDataSource ds, String url) {
        String options;
        String[] parts;
        String database;
        if (url == null) {
            return;
        }
        if (!url.startsWith(DERBY_PREFIX)) {
            throw new IllegalArgumentException("The supplied URL is no derby url: " + url);
        }
        URI uri = URI.create(url.substring(5));
        ds.setServerName(uri.getHost());
        ds.setPortNumber(uri.getPort());
        String suburl = uri.getPath();
        if (suburl.startsWith("/")) {
            suburl = suburl.substring(1);
        }
        if ((database = (parts = suburl.split(";"))[0]) != null) {
            ds.setDatabaseName(database);
        }
        if ((options = parts[1]).length() > 0) {
            ds.setConnectionAttributes(options);
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        ClientConnectionPoolDataSource ds = new ClientConnectionPoolDataSource();
        this.setProperties((ClientDataSource)ds, props);
        return ds;
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        ClientXADataSource ds = new ClientXADataSource();
        this.setProperties((ClientDataSource)ds, props);
        return ds;
    }

    public Driver createDriver(Properties props) throws SQLException {
        ClientDriver driver = new ClientDriver();
        return driver;
    }
}

