/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import com.google.common.base.Function;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class WeakComponentClusterer<V, E>
implements Function<Graph<V, E>, Set<Set<V>>> {
    public Set<Set<V>> apply(Graph<V, E> graph) {
        HashSet<Set<V>> clusterSet = new HashSet<Set<V>>();
        HashSet unvisitedVertices = new HashSet(graph.getVertices());
        while (!unvisitedVertices.isEmpty()) {
            HashSet cluster = new HashSet();
            Object root = unvisitedVertices.iterator().next();
            unvisitedVertices.remove(root);
            cluster.add(root);
            LinkedList queue = new LinkedList();
            queue.add(root);
            while (!queue.isEmpty()) {
                Object currentVertex = queue.remove();
                Collection neighbors = graph.getNeighbors(currentVertex);
                for (Object neighbor : neighbors) {
                    if (!unvisitedVertices.contains(neighbor)) continue;
                    queue.add(neighbor);
                    unvisitedVertices.remove(neighbor);
                    cluster.add(neighbor);
                }
            }
            clusterSet.add(cluster);
        }
        return clusterSet;
    }
}

