/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.component2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.felix.scr.impl.metadata.PropertyMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.ops4j.pax.cdi.api.Attribute;
import org.ops4j.pax.cdi.api.BundleScoped;
import org.ops4j.pax.cdi.api.Component;
import org.ops4j.pax.cdi.api.Config;
import org.ops4j.pax.cdi.api.Contract;
import org.ops4j.pax.cdi.api.Contracts;
import org.ops4j.pax.cdi.api.Dynamic;
import org.ops4j.pax.cdi.api.Greedy;
import org.ops4j.pax.cdi.api.Immediate;
import org.ops4j.pax.cdi.api.Optional;
import org.ops4j.pax.cdi.api.Properties;
import org.ops4j.pax.cdi.api.Property;
import org.ops4j.pax.cdi.api.PrototypeScoped;
import org.ops4j.pax.cdi.api.Service;
import org.ops4j.pax.cdi.extension.impl.component2.AbstractDescriptor;
import org.ops4j.pax.cdi.extension.impl.component2.ComponentRegistry;
import org.ops4j.pax.cdi.extension.impl.context.BundleScopeContext;
import org.ops4j.pax.cdi.extension.impl.context.PrototypeScopeContext;
import org.ops4j.pax.cdi.extension.impl.support.Configurable;
import org.ops4j.pax.cdi.extension.impl.support.Filters;
import org.ops4j.pax.cdi.extension.impl.support.IterableInstance;
import org.ops4j.pax.cdi.extension.impl.support.SimpleBean;
import org.ops4j.pax.cdi.extension.impl.support.Types;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;

public class ComponentDescriptor
extends AbstractDescriptor {
    private final Bean<Object> bean;
    private final Map<InjectionPoint, Supplier<Object>> instanceSuppliers = new HashMap<InjectionPoint, Supplier<Object>>();
    private final ThreadLocal<ComponentContext> context = new ThreadLocal();
    private final List<Bean<?>> producers = new ArrayList();

    public ComponentDescriptor(Bean<Object> bean, ComponentRegistry registry) {
        super(registry);
        this.bean = bean;
        boolean immediate = false;
        boolean hasService = false;
        HashSet<String> names = new HashSet<String>();
        for (Object annotation : bean.getQualifiers()) {
            Object value;
            Property[] prop;
            int n;
            if (annotation instanceof Immediate) {
                immediate = true;
                continue;
            }
            if (annotation instanceof Service) {
                hasService = true;
                continue;
            }
            if (annotation instanceof Contract) {
                names.add(((Contract)annotation).value().getName());
                continue;
            }
            if (annotation instanceof Contracts) {
                Contract[] contractArray = ((Contracts)annotation).value();
                int n2 = contractArray.length;
                for (n = 0; n < n2; ++n) {
                    Contract ctr = contractArray[n];
                    names.add(ctr.value().getName());
                }
                continue;
            }
            if (annotation instanceof Property) {
                prop = (Property[])annotation;
                PropertyMetadata propMeta = new PropertyMetadata();
                propMeta.setName(prop.name());
                propMeta.setValue(prop.value());
                propMeta.setType(prop.type());
                this.addProperty(propMeta);
                continue;
            }
            if (annotation instanceof Properties) {
                prop = ((Properties)annotation).value();
                int propMeta = prop.length;
                for (n = 0; n < propMeta; ++n) {
                    Property prop2 = prop[n];
                    PropertyMetadata propMeta2 = new PropertyMetadata();
                    propMeta2.setName(prop2.name());
                    propMeta2.setValue(prop2.value());
                    propMeta2.setType(prop2.type());
                    this.addProperty(propMeta2);
                }
                continue;
            }
            Class<? extends Annotation> annClass = annotation.annotationType();
            Attribute attr = annClass.getAnnotation(Attribute.class);
            if (attr == null) continue;
            String name = attr.value();
            try {
                Method[] methods = annClass.getDeclaredMethods();
                if (methods == null || methods.length != 1) {
                    throw new IllegalArgumentException("Bad attribute " + annClass);
                }
                value = methods[0].invoke(annotation, new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            this.getProperties().put(name, value);
        }
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        if (hasService) {
            if (names.isEmpty()) {
                for (Class<?> cl : bean.getBeanClass().getInterfaces()) {
                    names.add(cl.getName());
                }
            }
            if (names.isEmpty()) {
                names.add(bean.getBeanClass().getName());
            }
            for (String name : names) {
                serviceMetadata.addProvide(name);
            }
        } else {
            this.addAllClasses(serviceMetadata, bean.getBeanClass());
            this.getProperties().put("org.ops4j.pax.cdi.private", true);
        }
        if (bean.getScope() == PrototypeScoped.class || bean.getScope() == Dependent.class) {
            serviceMetadata.setScope("prototype");
        } else if (bean.getScope() == BundleScoped.class) {
            serviceMetadata.setScope("bundle");
        } else {
            serviceMetadata.setScope("singleton");
        }
        String name = bean.getName();
        if (name == null) {
            name = bean.getBeanClass().getName();
        }
        this.setName(name);
        this.setImmediate(immediate);
        this.setImplementationClassName(Object.class.getName());
        this.setConfigurationPolicy("ignore");
        this.getProperties().put(ComponentDescriptor.class.getName(), this);
        this.getProperties().put(ComponentRegistry.class.getName(), registry);
        this.setService(serviceMetadata);
    }

    public Bean<Object> getBean() {
        return this.bean;
    }

    private void addAllClasses(ServiceMetadata serviceMetadata, Class<?> beanClass) {
        serviceMetadata.addProvide(beanClass.getName());
        for (Class<?> itf : beanClass.getInterfaces()) {
            this.addAllClasses(serviceMetadata, itf);
        }
        if (beanClass.getSuperclass() != null) {
            this.addAllClasses(serviceMetadata, beanClass.getSuperclass());
        }
    }

    public void addInjectionPoint(InjectionPoint injectionPoint) {
        Class clazz;
        boolean multiple;
        Service ref = (Service)injectionPoint.getAnnotated().getAnnotation(Service.class);
        Component cmp = (Component)injectionPoint.getAnnotated().getAnnotation(Component.class);
        Config cfg = (Config)injectionPoint.getAnnotated().getAnnotation(Config.class);
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType) {
            Type raw = ((ParameterizedType)type).getRawType();
            if (raw == Instance.class) {
                multiple = true;
                clazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            } else {
                multiple = false;
                clazz = (Class)((ParameterizedType)type).getRawType();
            }
        } else {
            if (type == Instance.class) {
                throw new IllegalArgumentException();
            }
            multiple = false;
            clazz = (Class)type;
        }
        if (cfg != null) {
            if (ref != null) {
                throw new IllegalArgumentException("Only one of @Service or @Config can be set on injection point: " + injectionPoint);
            }
            if (multiple) {
                throw new IllegalArgumentException("Illegal use of Instance<?> on configuration: " + clazz.getName() + ": " + injectionPoint);
            }
            if (!clazz.isAnnotation()) {
                throw new IllegalArgumentException("Configuration class should be an annotation: " + clazz.getName() + ": " + injectionPoint);
            }
            Config config = (Config)injectionPoint.getAnnotated().getAnnotation(Config.class);
            String pid = config.pid().isEmpty() ? clazz.getName() : config.pid();
            boolean optional = injectionPoint.getAnnotated().isAnnotationPresent(Optional.class);
            this.setConfigurationPolicy(optional ? "optional" : "require");
            this.setConfigurationPid(new String[]{pid});
            Supplier<Object> supplier = () -> this.createConfig(clazz);
            this.producers.add(new SimpleBean<Object>(clazz, Dependent.class, injectionPoint, supplier));
        } else {
            List<String> subFilters = Filters.getSubFilters(injectionPoint.getAnnotated().getAnnotations());
            if (ref == null) {
                subFilters.add("(org.ops4j.pax.cdi.private=true)");
            }
            String filter = Filters.and(subFilters);
            boolean optional = injectionPoint.getAnnotated().isAnnotationPresent(Optional.class);
            boolean greedy = injectionPoint.getAnnotated().isAnnotationPresent(Greedy.class);
            boolean dynamic = injectionPoint.getAnnotated().isAnnotationPresent(Dynamic.class);
            ReferenceMetadata reference = new ReferenceMetadata();
            reference.setName(injectionPoint.toString());
            reference.setInterface(clazz.getName());
            reference.setTarget(filter);
            reference.setCardinality(optional ? (multiple ? "0..n" : "0..1") : (multiple ? "1..n" : "1..1"));
            reference.setPolicy(dynamic ? "dynamic" : "static");
            reference.setPolicyOption(greedy ? "greedy" : "reluctant");
            this.addDependency(reference);
            Supplier<Object> supplier = () -> this.getService(injectionPoint, multiple, dynamic);
            this.producers.add(new SimpleBean<Object>(clazz, Dependent.class, injectionPoint, supplier));
            this.instanceSuppliers.put(injectionPoint, supplier);
        }
    }

    @Override
    public ComponentContext getComponentContext() {
        return this.context.get();
    }

    protected Object createConfig(Class<?> clazz) {
        ComponentContext cc = this.context.get();
        if (cc == null) {
            throw new IllegalStateException("Can not obtain @Component instance");
        }
        Map cfg = (Map)((Object)cc.getProperties());
        return Configurable.create(clazz, cfg != null ? cfg : new Hashtable());
    }

    protected Object getService(final InjectionPoint injectionPoint, boolean isInstance, boolean dynamic) {
        final ComponentContext cc = this.context.get();
        if (cc == null) {
            throw new IllegalStateException("Can not obtain @Component instance: " + injectionPoint);
        }
        if (dynamic && isInstance) {
            Iterable iterable = () -> new Iterator<Object>(){
                final Object[] services;
                int idx;
                {
                    this.services = cc.locateServices(injectionPoint.toString());
                }

                @Override
                public boolean hasNext() {
                    return this.services != null && this.idx < this.services.length;
                }

                @Override
                public Object next() {
                    return this.services[this.idx++];
                }
            };
            return new IterableInstance(iterable);
        }
        if (isInstance) {
            final Object[] services = cc.locateServices(injectionPoint.toString());
            Iterable iterable = () -> new Iterator<Object>(){
                int idx;

                @Override
                public boolean hasNext() {
                    return services != null && this.idx < services.length;
                }

                @Override
                public Object next() {
                    return services[this.idx++];
                }
            };
            return new IterableInstance(iterable);
        }
        if (dynamic) {
            Class clazz = Types.getRawType(injectionPoint.getType());
            ClassLoader cl = ((BundleWiring)this.registry.getBundleContext().getBundle().adapt(BundleWiring.class)).getClassLoader();
            return Proxy.newProxyInstance(cl, new Class[]{clazz}, (p, method, args) -> {
                Object t = cc.locateService(injectionPoint.toString());
                return t != null ? method.invoke(t, args) : null;
            });
        }
        return cc.locateService(injectionPoint.toString());
    }

    @Override
    public List<Bean<?>> getProducers() {
        return this.producers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object activate(ComponentContext cc) {
        this.context.set(cc);
        try {
            Object object;
            BeanManager beanManager = this.registry.getBeanManager();
            Context context = beanManager.getContext(this.bean.getScope());
            if (context instanceof BundleScopeContext) {
                ((BundleScopeContext)context).setClientBundle(cc.getUsingBundle());
            }
            try {
                object = context.get(this.bean, beanManager.createCreationalContext(this.bean));
            }
            catch (Throwable throwable) {
                if (context instanceof BundleScopeContext) {
                    ((BundleScopeContext)context).setClientBundle(null);
                }
                throw throwable;
            }
            if (context instanceof BundleScopeContext) {
                ((BundleScopeContext)context).setClientBundle(null);
            }
            return object;
        }
        finally {
            this.context.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate(ComponentContext cc) {
        this.context.set(cc);
        try {
            BeanManager beanManager = this.registry.getBeanManager();
            AlterableContext context = (AlterableContext)beanManager.getContext(this.bean.getScope());
            if (context instanceof PrototypeScopeContext) {
                ((PrototypeScopeContext)context).setService(cc.getComponentInstance().getInstance());
            } else if (context instanceof BundleScopeContext) {
                ((BundleScopeContext)context).setClientBundle(cc.getUsingBundle());
            }
            try {
                context.destroy(this.bean);
            }
            finally {
                if (context instanceof PrototypeScopeContext) {
                    ((PrototypeScopeContext)context).setService(null);
                } else if (context instanceof BundleScopeContext) {
                    ((BundleScopeContext)context).setClientBundle(null);
                }
            }
        }
        finally {
            this.context.set(null);
        }
    }

    public void inject(Object instance, InjectionPoint injectionPoint) {
        Supplier<Object> supplier = this.instanceSuppliers.get(injectionPoint);
        if (supplier != null) {
            Field field = ((AnnotatedField)injectionPoint.getAnnotated()).getJavaMember();
            field.setAccessible(true);
            try {
                field.set(instance, supplier.get());
            }
            catch (IllegalAccessException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    public String toString() {
        return "Component[bean=" + this.bean + ']';
    }
}

