/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import org.ops4j.pax.cdi.api.BundleScoped;
import org.ops4j.pax.cdi.api.Component;
import org.ops4j.pax.cdi.api.Config;
import org.ops4j.pax.cdi.api.Global;
import org.ops4j.pax.cdi.api.PrototypeScoped;
import org.ops4j.pax.cdi.api.Service;
import org.ops4j.pax.cdi.api.SingletonScoped;
import org.ops4j.pax.cdi.api.event.ServiceCdiEvent;
import org.ops4j.pax.cdi.extension.impl.BundleContextProducer;
import org.ops4j.pax.cdi.extension.impl.BundleEventBridge;
import org.ops4j.pax.cdi.extension.impl.ServiceEventBridge;
import org.ops4j.pax.cdi.extension.impl.component2.BundleContextHolder;
import org.ops4j.pax.cdi.extension.impl.component2.ComponentDescriptor;
import org.ops4j.pax.cdi.extension.impl.component2.ComponentRegistry;
import org.ops4j.pax.cdi.extension.impl.component2.GlobalDescriptor;
import org.ops4j.pax.cdi.extension.impl.context.BundleScopeContext;
import org.ops4j.pax.cdi.extension.impl.context.PrototypeScopeContext;
import org.ops4j.pax.cdi.extension.impl.context.SingletonScopeContext;
import org.ops4j.pax.cdi.extension.impl.osgi.Registry;
import org.ops4j.pax.cdi.extension.impl.support.DelegatingBeanAttributes;
import org.ops4j.pax.cdi.extension.impl.support.DelegatingInjectionPoint;
import org.ops4j.pax.cdi.extension.impl.support.DelegatingInjectionTarget;
import org.ops4j.pax.cdi.extension.impl.support.Filters;
import org.ops4j.pax.cdi.extension.impl.support.Types;
import org.ops4j.pax.cdi.extension.impl.util.ServiceAddedLiteral;
import org.ops4j.pax.cdi.extension.impl.util.ServiceRemovedLiteral;

@ApplicationScoped
public class OsgiExtension2
implements Extension {
    private ComponentRegistry componentRegistry;
    private GlobalDescriptor global;
    private final Set<String> observedFilters = new HashSet<String>();
    private final Set<Annotation> observedQualifiers = new HashSet<Annotation>();

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public <T> Bean<T> globalDependency(Class<T> clazz, Set<Annotation> qualifiers) {
        return this.global.addGlobalInjectionPoint(clazz, qualifiers);
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager manager) {
        this.componentRegistry = new ComponentRegistry(manager, BundleContextHolder.getBundleContext());
        this.global = new GlobalDescriptor(this.componentRegistry);
        event.addAnnotatedType(manager.createAnnotatedType(BundleEventBridge.class));
        event.addAnnotatedType(manager.createAnnotatedType(ServiceEventBridge.class));
        event.addAnnotatedType(manager.createAnnotatedType(BundleContextProducer.class));
        event.addScope(SingletonScoped.class, false, false);
    }

    public <T> void processBeanAttributes(@Observes ProcessBeanAttributes<T> event) {
        BeanAttributes attr;
        Class scope;
        if ((event.getAnnotated().isAnnotationPresent(Component.class) || event.getAnnotated().isAnnotationPresent(Global.class)) && (scope = (attr = event.getBeanAttributes()).getScope()) != SingletonScoped.class && scope != BundleScoped.class && scope != PrototypeScoped.class) {
            if (scope == Singleton.class) {
                event.setBeanAttributes((BeanAttributes)new DelegatingBeanAttributes<T>(attr){

                    @Override
                    public Class<? extends Annotation> getScope() {
                        return SingletonScoped.class;
                    }
                });
            } else if (scope == Dependent.class) {
                if (event.getAnnotated().isAnnotationPresent(Global.class)) {
                    event.setBeanAttributes((BeanAttributes)new DelegatingBeanAttributes<T>(attr){

                        @Override
                        public Class<? extends Annotation> getScope() {
                            return PrototypeScoped.class;
                        }
                    });
                } else {
                    event.setBeanAttributes((BeanAttributes)new DelegatingBeanAttributes<T>(attr){

                        @Override
                        public Class<? extends Annotation> getScope() {
                            return SingletonScoped.class;
                        }
                    });
                }
            } else {
                event.addDefinitionError((Throwable)new IllegalArgumentException("Unsupported scope " + scope.getSimpleName() + ": " + event.getAnnotated()));
            }
        }
    }

    public <T> void processBean(@Observes ProcessBean<T> event) {
        Bean bean = event.getBean();
        ComponentDescriptor descriptor = null;
        if (event.getAnnotated().isAnnotationPresent(Component.class) || event.getAnnotated().isAnnotationPresent(Service.class)) {
            if (!event.getAnnotated().isAnnotationPresent(Component.class) && !event.getAnnotated().isAnnotationPresent(Global.class)) {
                event.addDefinitionError((Throwable)new IllegalArgumentException("Beans annotated with @Service should be annotated with @Component or @Global: " + event.getAnnotated()));
            }
            descriptor = this.componentRegistry.addComponent((Bean<Object>)bean);
        }
        for (InjectionPoint ip : event.getBean().getInjectionPoints()) {
            if (!ip.getAnnotated().isAnnotationPresent(Service.class) && !ip.getAnnotated().isAnnotationPresent(Component.class) && !ip.getAnnotated().isAnnotationPresent(Config.class)) continue;
            if (ip.getAnnotated().isAnnotationPresent(Global.class) || event.getAnnotated().isAnnotationPresent(Global.class)) {
                try {
                    this.global.addGlobalInjectionPoint(ip);
                }
                catch (IllegalArgumentException e) {
                    event.addDefinitionError((Throwable)e);
                }
                continue;
            }
            if (!event.getAnnotated().isAnnotationPresent(Component.class)) {
                event.addDefinitionError((Throwable)new IllegalArgumentException("Beans with @Service, @Component or @Config injection points should be annotated with @Component: " + event.getAnnotated()));
                continue;
            }
            try {
                descriptor.addInjectionPoint(ip);
            }
            catch (IllegalArgumentException e) {
                event.addDefinitionError((Throwable)e);
            }
        }
    }

    public <T, X> void processInjectionPoint(@Observes ProcessInjectionPoint<T, X> event) {
        if (event.getInjectionPoint().getAnnotated().isAnnotationPresent(Service.class) || event.getInjectionPoint().getAnnotated().isAnnotationPresent(Component.class)) {
            final String id = UUID.randomUUID().toString();
            event.setInjectionPoint((InjectionPoint)new DelegatingInjectionPoint(event.getInjectionPoint()){

                @Override
                public Set<Annotation> getQualifiers() {
                    HashSet<Annotation> annotations = new HashSet<Annotation>(this.delegate.getQualifiers());
                    annotations.add((Annotation)new AnnotationLiteral<Service>(){});
                    annotations.add(new UniqueIdentifierLitteral(id));
                    return annotations;
                }
            });
        }
    }

    public <T> void processInjectionTarget(@Observes ProcessInjectionTarget<T> event) {
        for (InjectionPoint ip : event.getInjectionTarget().getInjectionPoints()) {
            Annotated annotated = ip.getAnnotated();
            if (!annotated.isAnnotationPresent(Service.class) && !annotated.isAnnotationPresent(Component.class) && !annotated.isAnnotationPresent(Config.class)) continue;
            event.setInjectionTarget((InjectionTarget)new DelegatingInjectionTarget<T>(event.getInjectionTarget()){

                @Override
                public void inject(T instance, CreationalContext<T> ctx) {
                    super.inject(instance, ctx);
                    for (InjectionPoint injectionPoint : this.getInjectionPoints()) {
                        ComponentDescriptor descriptor = OsgiExtension2.this.componentRegistry.getDescriptor(injectionPoint.getBean());
                        if (descriptor == null) continue;
                        descriptor.inject(instance, injectionPoint);
                    }
                }
            });
            return;
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        this.componentRegistry.preStart(event, this.global);
        BeanManager beanManager = this.componentRegistry.getBeanManager();
        SingletonScopeContext serviceContext = new SingletonScopeContext(beanManager);
        event.addContext((Context)serviceContext);
        BundleScopeContext bundleScopeContext = new BundleScopeContext(beanManager);
        event.addContext((Context)bundleScopeContext);
        PrototypeScopeContext prototypeScopeContext = new PrototypeScopeContext(beanManager);
        event.addContext((Context)prototypeScopeContext);
    }

    public void applicationScopeInitialized(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        this.componentRegistry.start();
        Registry.getInstance().register(this.componentRegistry);
    }

    public void applicationScopeDestroyed(@Observes @Destroyed(value=ApplicationScoped.class) Object destroy) {
        Registry.getInstance().unregister(this.componentRegistry);
        this.componentRegistry.stop();
    }

    public Set<String> getObservedFilters() {
        return this.observedFilters;
    }

    public Set<Annotation> getObservedQualifiers() {
        return this.observedQualifiers;
    }

    public <T, X> void processObserverMethod(@Observes ProcessObserverMethod<T, X> event) {
        Set qualifiers = event.getObserverMethod().getObservedQualifiers();
        if (qualifiers.contains((Object)new ServiceAddedLiteral()) || qualifiers.contains((Object)new ServiceRemovedLiteral())) {
            List<String> filters = Filters.getSubFilters(qualifiers);
            Type observed = event.getObserverMethod().getObservedType();
            Class service = Types.getRawType(observed);
            if (service == ServiceCdiEvent.class) {
                service = Types.getRawType(((ParameterizedType)observed).getActualTypeArguments()[0]);
            }
            if (service != Object.class) {
                String subfilter = "(objectClass=" + service.getName() + ")";
                filters.add(0, subfilter);
            }
            String filter = Filters.and(filters);
            this.observedFilters.add(filter);
            this.observedQualifiers.addAll(qualifiers);
        }
    }

    static class UniqueIdentifierLitteral
    extends AnnotationLiteral<UniqueIdentifier>
    implements UniqueIdentifier {
        private final String id;

        public UniqueIdentifierLitteral(String id) {
            this.id = id;
        }

        @Override
        public String id() {
            return this.id;
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    public static @interface UniqueIdentifier {
        public String id();
    }
}

