/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.messages;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetconfHelloMessageAdditionalHeader {
    private static final String SC = ";";
    private final String userName;
    private final String hostAddress;
    private final String port;
    private final String transport;
    private final String sessionIdentifier;
    private static final Pattern PATTERN = Pattern.compile("\\[(?<username>[^;]+);(?<address>.+)[:/](?<port>[0-9]+);(?<transport>[a-z]+)[^\\]]+\\]");
    private static final Pattern CUSTOM_HEADER_PATTERN = Pattern.compile("\\[(?<username>[^;]+);(?<address>.+)[:/](?<port>[0-9]+);(?<transport>[a-z]+);(?<sessionIdentifier>[a-z]+)[^\\]]+\\]");

    public NetconfHelloMessageAdditionalHeader(String userName, String hostAddress, String port, String transport, String sessionIdentifier) {
        this.userName = userName;
        this.hostAddress = hostAddress;
        this.port = port;
        this.transport = transport;
        this.sessionIdentifier = sessionIdentifier;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getAddress() {
        return this.hostAddress;
    }

    public String getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    public String getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    public String toFormattedString() {
        Preconditions.checkNotNull((Object)this.userName);
        Preconditions.checkNotNull((Object)this.hostAddress);
        Preconditions.checkNotNull((Object)this.port);
        Preconditions.checkNotNull((Object)this.transport);
        Preconditions.checkNotNull((Object)this.sessionIdentifier);
        return "[" + this.userName + SC + this.hostAddress + ":" + this.port + SC + this.transport + SC + this.sessionIdentifier + SC + "]" + System.lineSeparator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NetconfHelloMessageAdditionalHeader{");
        sb.append("userName='").append(this.userName).append('\'');
        sb.append(", hostAddress='").append(this.hostAddress).append('\'');
        sb.append(", port='").append(this.port).append('\'');
        sb.append(", transport='").append(this.transport).append('\'');
        sb.append(", sessionIdentifier='").append(this.sessionIdentifier).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static NetconfHelloMessageAdditionalHeader fromString(String additionalHeader) {
        String additionalHeaderTrimmed = additionalHeader.trim();
        Matcher matcher = PATTERN.matcher(additionalHeaderTrimmed);
        Matcher matcher2 = CUSTOM_HEADER_PATTERN.matcher(additionalHeaderTrimmed);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Additional header in wrong format %s, expected %s", (Object)additionalHeaderTrimmed, (Object)PATTERN);
        String username = matcher.group("username");
        String address = matcher.group("address");
        Preconditions.checkArgument((boolean)InetAddresses.isInetAddress((String)address));
        String port = matcher.group("port");
        String transport = matcher.group("transport");
        String sessionIdentifier = "client";
        if (matcher2.matches()) {
            sessionIdentifier = matcher2.group("sessionIdentifier");
        }
        return new NetconfHelloMessageAdditionalHeader(username, address, port, transport, sessionIdentifier);
    }
}

