/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.messages;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NetconfHelloMessage
extends NetconfMessage {
    public static final String HELLO_TAG = "hello";
    private final NetconfHelloMessageAdditionalHeader additionalHeader;

    public NetconfHelloMessage(Document doc, NetconfHelloMessageAdditionalHeader additionalHeader) {
        super(doc);
        NetconfHelloMessage.checkHelloMessage(doc);
        this.additionalHeader = additionalHeader;
    }

    public NetconfHelloMessage(Document doc) {
        this(doc, null);
    }

    public Optional<NetconfHelloMessageAdditionalHeader> getAdditionalHeader() {
        return Optional.ofNullable(this.additionalHeader);
    }

    private static void checkHelloMessage(Document doc) {
        if (!NetconfHelloMessage.isHelloMessage(doc)) {
            throw new IllegalArgumentException(String.format("Hello message invalid format, should contain %s tag from namespace %s, but is: %s", HELLO_TAG, "urn:ietf:params:xml:ns:netconf:base:1.0", XmlUtil.toString(doc)));
        }
    }

    public static NetconfHelloMessage createClientHello(Iterable<String> capabilities, Optional<NetconfHelloMessageAdditionalHeader> additionalHeaderOptional) {
        return new NetconfHelloMessage(NetconfHelloMessage.createHelloMessageDoc(capabilities), additionalHeaderOptional.orElse(null));
    }

    private static Document createHelloMessageDoc(Iterable<String> capabilities) {
        Document doc = UntrustedXML.newDocumentBuilder().newDocument();
        Element helloElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", HELLO_TAG);
        Element capabilitiesElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "capabilities");
        for (String capability : Sets.newHashSet(capabilities)) {
            Element capElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "capability");
            capElement.setTextContent(capability);
            capabilitiesElement.appendChild(capElement);
        }
        helloElement.appendChild(capabilitiesElement);
        doc.appendChild(helloElement);
        return doc;
    }

    public static NetconfHelloMessage createServerHello(Set<String> capabilities, long sessionId) {
        Document doc = NetconfHelloMessage.createHelloMessageDoc(capabilities);
        Element sessionIdElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "session-id");
        sessionIdElement.setTextContent(Long.toString(sessionId));
        doc.getDocumentElement().appendChild(sessionIdElement);
        return new NetconfHelloMessage(doc);
    }

    public static boolean isHelloMessage(NetconfMessage msg) {
        return NetconfHelloMessage.isHelloMessage(msg.getDocument());
    }

    private static boolean isHelloMessage(Document document) {
        XmlElement element = XmlElement.fromDomElement(document.getDocumentElement());
        if (!HELLO_TAG.equals(element.getName())) {
            return false;
        }
        Optional<String> optNamespace = element.getNamespaceOptionally();
        return !optNamespace.isPresent() || "urn:ietf:params:xml:ns:netconf:base:1.0".equals(optNamespace.get());
    }
}

