/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.capability;

import com.google.common.base.Optional;
import org.opendaylight.netconf.api.capability.BasicCapability;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.Module;

public final class YangModuleCapability
extends BasicCapability {
    private final String content;
    private final String revision;
    private final String moduleName;
    private final String moduleNamespace;

    public YangModuleCapability(Module module, String moduleContent) {
        super(YangModuleCapability.toCapabilityURI(module));
        this.content = moduleContent;
        this.moduleName = module.getName();
        this.moduleNamespace = module.getNamespace().toString();
        this.revision = module.getRevision().map(Revision::toString).orElse(null);
    }

    @Override
    public Optional<String> getCapabilitySchema() {
        return Optional.of((Object)this.content);
    }

    private static String toCapabilityURI(Module module) {
        StringBuilder sb = new StringBuilder();
        sb.append(module.getNamespace()).append("?module=").append(module.getName());
        java.util.Optional rev = module.getRevision();
        if (rev.isPresent()) {
            sb.append("&revision=").append(rev.get());
        }
        return sb.toString();
    }

    @Override
    public Optional<String> getModuleName() {
        return Optional.of((Object)this.moduleName);
    }

    @Override
    public Optional<String> getModuleNamespace() {
        return Optional.of((Object)this.moduleNamespace);
    }

    @Override
    public Optional<String> getRevision() {
        return Optional.fromNullable((Object)this.revision);
    }
}

