/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.oracle.impl;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;

public class OracleDataSourceFactory
implements DataSourceFactory {
    private static final String ORACLE_DATASOURCE_CLASS = "oracle.jdbc.pool.OracleDataSource";
    private static final String ORACLE_CONNECTIONPOOL_DATASOURCE_CLASS = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
    private static final String ORACLE_XA_DATASOURCE_CLASS = "oracle.jdbc.xa.client.OracleXADataSource";
    private static final String ORACLE_DRIVER_CLASS = "oracle.jdbc.OracleDriver";
    private final Class<?> oracleDataSourceClass;
    private final Class<?> oracleConnectionPoolDataSourceClass;
    private final Class<?> oracleXaDataSourceClass;
    private final Class<?> oracleDriverClass;

    public OracleDataSourceFactory() throws ClassNotFoundException {
        ClassLoader classLoader = OracleDataSourceFactory.class.getClassLoader();
        this.oracleDataSourceClass = classLoader.loadClass(ORACLE_DATASOURCE_CLASS);
        this.oracleConnectionPoolDataSourceClass = classLoader.loadClass(ORACLE_CONNECTIONPOOL_DATASOURCE_CLASS);
        this.oracleXaDataSourceClass = classLoader.loadClass(ORACLE_XA_DATASOURCE_CLASS);
        this.oracleDriverClass = classLoader.loadClass(ORACLE_DRIVER_CLASS);
    }

    public DataSource createDataSource(Properties props) throws SQLException {
        try {
            DataSource ds = (DataSource)DataSource.class.cast(this.oracleDataSourceClass.newInstance());
            this.setProperties(ds, this.oracleDataSourceClass, props);
            return ds;
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    private void setProperties(CommonDataSource ds, Class<?> clazz, Properties properties) throws Exception {
        String databaseName;
        Properties props = (Properties)properties.clone();
        String url = (String)props.remove("url");
        if (url != null) {
            clazz.getMethod("setURL", String.class).invoke((Object)ds, url);
        }
        if ((databaseName = (String)props.remove("databaseName")) == null && url == null) {
            throw new SQLException("missing required property databaseName");
        }
        clazz.getMethod("setDatabaseName", String.class).invoke((Object)ds, databaseName);
        String serverName = (String)props.remove("serverName");
        clazz.getMethod("setServerName", String.class).invoke((Object)ds, serverName);
        String portNumber = (String)props.remove("portNumber");
        if (portNumber != null) {
            int portNum = Integer.parseInt(portNumber);
            try {
                clazz.getMethod("setPortNumber", Integer.class).invoke((Object)ds, portNum);
            }
            catch (NoSuchMethodException e) {
                clazz.getMethod("setPortNumber", Integer.TYPE).invoke((Object)ds, portNum);
            }
        }
        String user = (String)props.remove("user");
        clazz.getMethod("setUser", String.class).invoke((Object)ds, user);
        String password = (String)props.remove("password");
        clazz.getMethod("setPassword", String.class).invoke((Object)ds, password);
        if (!props.isEmpty()) {
            BeanConfig.configure((Object)ds, props);
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        try {
            ConnectionPoolDataSource ds = (ConnectionPoolDataSource)ConnectionPoolDataSource.class.cast(this.oracleConnectionPoolDataSourceClass.newInstance());
            this.setProperties(ds, this.oracleConnectionPoolDataSourceClass, props);
            return ds;
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        try {
            XADataSource ds = (XADataSource)XADataSource.class.cast(this.oracleXaDataSourceClass.newInstance());
            this.setProperties(ds, this.oracleXaDataSourceClass, props);
            return ds;
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public Driver createDriver(Properties props) throws SQLException {
        try {
            return (Driver)Driver.class.cast(this.oracleDriverClass.newInstance());
        }
        catch (InstantiationException ex) {
            throw new SQLException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new SQLException(ex);
        }
    }
}

