/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.compat;

import com.google.common.base.Optional;
import com.google.common.collect.ForwardingObject;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.function.Function;
import org.opendaylight.controller.md.sal.common.api.MappingCheckedFuture;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.core.compat.ReadFailedExceptionAdapter;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class DOMStoreReadTransactionAdapter<T extends DOMStoreReadTransaction>
extends ForwardingObject
implements org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction {
    private final T delegate;

    public DOMStoreReadTransactionAdapter(T delegate) {
        this.delegate = (DOMStoreReadTransaction)Objects.requireNonNull(delegate);
    }

    protected T delegate() {
        return this.delegate;
    }

    public Object getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public void close() {
        this.delegate.close();
    }

    public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(YangInstanceIdentifier path) {
        return MappingCheckedFuture.create((ListenableFuture)this.delegate.read(path).transform(Optional::fromJavaUtil, MoreExecutors.directExecutor()), (Function)((Object)ReadFailedExceptionAdapter.INSTANCE));
    }

    public CheckedFuture<Boolean, ReadFailedException> exists(YangInstanceIdentifier path) {
        return MappingCheckedFuture.create((ListenableFuture)this.delegate.exists(path), (Function)((Object)ReadFailedExceptionAdapter.INSTANCE));
    }
}

