/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.compat;

import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.md.sal.dom.api.DOMService;
import org.opendaylight.controller.sal.core.compat.LegacyDOMActionServiceAdapter;
import org.opendaylight.controller.sal.core.compat.LegacyDOMDataBrokerAdapter;
import org.opendaylight.controller.sal.core.compat.LegacyDOMNotificationServiceAdapter;
import org.opendaylight.controller.sal.core.compat.LegacyDOMRpcServiceAdapter;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

@Deprecated
public class DOMMountPointAdapter
extends ForwardingObject
implements org.opendaylight.controller.md.sal.dom.api.DOMMountPoint {
    private static final Map<Class<? extends DOMService>, CompatFactory<?, ?>> KNOWN_SERVICES = ImmutableMap.of(org.opendaylight.controller.md.sal.dom.api.DOMActionService.class, (Object)new CompatFactory<DOMActionService, org.opendaylight.controller.md.sal.dom.api.DOMActionService>(DOMActionService.class){

        @Override
        org.opendaylight.controller.md.sal.dom.api.DOMActionService createService(DOMActionService delegate) {
            return new LegacyDOMActionServiceAdapter(delegate);
        }
    }, DOMDataBroker.class, (Object)new CompatFactory<org.opendaylight.mdsal.dom.api.DOMDataBroker, DOMDataBroker>(org.opendaylight.mdsal.dom.api.DOMDataBroker.class){

        @Override
        DOMDataBroker createService(org.opendaylight.mdsal.dom.api.DOMDataBroker delegate) {
            return new LegacyDOMDataBrokerAdapter(delegate);
        }
    }, DOMNotificationService.class, (Object)new CompatFactory<org.opendaylight.mdsal.dom.api.DOMNotificationService, DOMNotificationService>(org.opendaylight.mdsal.dom.api.DOMNotificationService.class){

        @Override
        DOMNotificationService createService(org.opendaylight.mdsal.dom.api.DOMNotificationService delegate) {
            return new LegacyDOMNotificationServiceAdapter(delegate);
        }
    }, DOMRpcService.class, (Object)new CompatFactory<org.opendaylight.mdsal.dom.api.DOMRpcService, DOMRpcService>(org.opendaylight.mdsal.dom.api.DOMRpcService.class){

        @Override
        DOMRpcService createService(org.opendaylight.mdsal.dom.api.DOMRpcService delegate) {
            return new LegacyDOMRpcServiceAdapter(delegate);
        }
    });
    private final DOMMountPoint delegate;

    public DOMMountPointAdapter(DOMMountPoint delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public YangInstanceIdentifier getIdentifier() {
        return (YangInstanceIdentifier)this.delegate().getIdentifier();
    }

    public <T extends DOMService> com.google.common.base.Optional<T> getService(Class<T> cls) {
        Optional found = this.delegate.getService(cls);
        if (found.isPresent()) {
            return com.google.common.base.Optional.of(found.get());
        }
        CompatFactory<?, ?> compat = KNOWN_SERVICES.get(cls);
        return com.google.common.base.Optional.fromNullable(cls.cast(compat == null ? null : compat.createService(this.delegate)));
    }

    public SchemaContext getSchemaContext() {
        return this.delegate().getSchemaContext();
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof org.opendaylight.controller.md.sal.dom.api.DOMMountPoint)) {
            return false;
        }
        org.opendaylight.controller.md.sal.dom.api.DOMMountPoint other = (org.opendaylight.controller.md.sal.dom.api.DOMMountPoint)obj;
        return this.getIdentifier().equals(other.getIdentifier());
    }

    protected DOMMountPoint delegate() {
        return this.delegate;
    }

    private static abstract class CompatFactory<M extends org.opendaylight.mdsal.dom.api.DOMService, C extends DOMService> {
        private final Class<M> mdsalClass;

        CompatFactory(Class<M> mdsalClass) {
            this.mdsalClass = Objects.requireNonNull(mdsalClass);
        }

        final @Nullable C createService(DOMMountPoint mountPoint) {
            return (C)((DOMService)mountPoint.getService(this.mdsalClass).map(this::createService).orElse(null));
        }

        abstract C createService(M var1);
    }
}

