/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.compat;

import com.google.common.collect.ForwardingObject;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.sal.core.compat.TransactionUtils;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class DOMDataTreeWriteTransactionAdapter
extends ForwardingObject
implements DOMDataTreeWriteTransaction {
    private final DOMDataWriteTransaction delegate;

    public DOMDataTreeWriteTransactionAdapter(DOMDataWriteTransaction delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public Object getIdentifier() {
        return this.delegate().getIdentifier();
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        TransactionUtils.put(this.delegate(), store, path, data);
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        TransactionUtils.merge(this.delegate(), store, path, data);
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        TransactionUtils.delete(this.delegate(), store, path);
    }

    public FluentFuture<? extends CommitInfo> commit() {
        return this.delegate().commit();
    }

    public boolean cancel() {
        return this.delegate().cancel();
    }

    protected DOMDataWriteTransaction delegate() {
        return this.delegate;
    }
}

