/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.compat;

import com.google.common.collect.ForwardingObject;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.sal.core.compat.TransactionUtils;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class DOMDataTreeReadWriteTransactionAdapter
extends ForwardingObject
implements DOMDataTreeReadWriteTransaction {
    private final DOMDataReadWriteTransaction delegate;

    public DOMDataTreeReadWriteTransactionAdapter(DOMDataReadWriteTransaction delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public Object getIdentifier() {
        return this.delegate().getIdentifier();
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return TransactionUtils.read((DOMDataReadTransaction)this.delegate(), store, path);
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return TransactionUtils.exists((DOMDataReadTransaction)this.delegate(), store, path);
    }

    public void close() {
        this.cancel();
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        TransactionUtils.put((DOMDataWriteTransaction)this.delegate(), store, path, data);
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        TransactionUtils.merge((DOMDataWriteTransaction)this.delegate(), store, path, data);
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        TransactionUtils.delete((DOMDataWriteTransaction)this.delegate(), store, path);
    }

    public FluentFuture<? extends CommitInfo> commit() {
        return this.delegate().commit();
    }

    public boolean cancel() {
        return this.delegate().cancel();
    }

    protected DOMDataReadWriteTransaction delegate() {
        return this.delegate;
    }
}

