/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.compat;

import com.google.common.collect.ForwardingObject;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadTransaction;
import org.opendaylight.controller.sal.core.compat.TransactionUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class DOMDataTreeReadTransactionAdapter
extends ForwardingObject
implements DOMDataTreeReadTransaction {
    private final DOMDataReadOnlyTransaction delegate;

    public DOMDataTreeReadTransactionAdapter(DOMDataReadOnlyTransaction delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public Object getIdentifier() {
        return this.delegate().getIdentifier();
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return TransactionUtils.read((DOMDataReadTransaction)this.delegate(), store, path);
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return TransactionUtils.exists((DOMDataReadTransaction)this.delegate(), store, path);
    }

    public void close() {
        this.delegate().close();
    }

    protected DOMDataReadOnlyTransaction delegate() {
        return this.delegate;
    }
}

