/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.compat;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.mdsal.dom.api.DOMRpcException;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.util.concurrent.ExceptionMapper;

public abstract class AbstractDOMRpcResultFutureAdapter<T extends DOMRpcResult, F extends DOMRpcResult, D extends ListenableFuture<F>, E extends DOMRpcException>
extends AbstractFuture<T> {
    private final D delegate;
    private final ExceptionMapper<E> exMapper;
    private volatile Optional<T> result;

    AbstractDOMRpcResultFutureAdapter(D delegate, ExceptionMapper<E> exMapper) {
        this.delegate = delegate;
        this.exMapper = exMapper;
    }

    protected abstract T transform(F var1);

    public D delegate() {
        return this.delegate;
    }

    public void addListener(Runnable listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        if (this.result != null) {
            return (T)((DOMRpcResult)this.result.orElse(null));
        }
        try {
            return this.transformIfNecessary((DOMRpcResult)this.delegate.get());
        }
        catch (ExecutionException e) {
            throw new ExecutionException(e.getMessage(), this.exMapper.apply((Exception)e));
        }
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.result != null) {
            return (T)((DOMRpcResult)this.result.orElse(null));
        }
        try {
            return this.transformIfNecessary((DOMRpcResult)this.delegate.get(timeout, unit));
        }
        catch (ExecutionException e) {
            throw new ExecutionException(e.getMessage(), this.exMapper.apply((Exception)e));
        }
    }

    private synchronized T transformIfNecessary(F delegateResult) {
        if (this.result == null) {
            this.result = delegateResult == null ? Optional.empty() : Optional.of(this.transform(delegateResult));
        }
        return (T)((DOMRpcResult)this.result.orElse(null));
    }
}

