/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.install;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.AriesApplicationManager;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBAInstaller
implements ArtifactInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(EBAInstaller.class);
    private Map<File, AriesApplicationContext> appContexts = new HashMap<File, AriesApplicationContext>();
    private AriesApplicationManager applicationManager;

    public AriesApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    public void setApplicationManager(AriesApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public boolean canHandle(File fileToHandlerLocation) {
        return fileToHandlerLocation.getName().toLowerCase().endsWith(".eba");
    }

    public void install(File applicationLocation) throws Exception {
        AriesApplication app = this.applicationManager.createApplication(FileSystem.getFSRoot((File)applicationLocation));
        String appSymName = app.getApplicationMetadata().getApplicationSymbolicName();
        Version appVersion = app.getApplicationMetadata().getApplicationVersion();
        LOGGER.debug("created app from {} : {} {} with contents {}", new Object[]{applicationLocation.getName(), appSymName, appVersion, app.getApplicationMetadata().getApplicationContents()});
        AriesApplicationContext context = this.applicationManager.install(app);
        LOGGER.debug("installed app {} {} state: {}", new Object[]{appSymName, appVersion, context.getApplicationState()});
        context.start();
        LOGGER.debug("started app {} {} state: {}", new Object[]{appSymName, appVersion, context.getApplicationState()});
        this.appContexts.put(applicationLocation, context);
    }

    public void uninstall(File applicationLocation) throws Exception {
        AriesApplicationContext context = this.appContexts.get(applicationLocation);
        String appSymName = context.getApplication().getApplicationMetadata().getApplicationSymbolicName();
        Version appVersion = context.getApplication().getApplicationMetadata().getApplicationVersion();
        LOGGER.debug("uninstalling {} {} ", new Object[]{appSymName, appVersion});
        if (context != null) {
            context.stop();
            this.applicationManager.uninstall(context);
        }
        this.appContexts.remove(applicationLocation);
        LOGGER.debug("uninstalled {} {} state: {}", new Object[]{appSymName, appVersion, context.getApplicationState()});
    }

    public void update(File arg0) throws Exception {
        throw new UnsupportedOperationException("Updating .eba file is not supported");
    }
}

