/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileBuilder;
import org.apache.karaf.profile.impl.ProfileImpl;
import org.apache.karaf.profile.impl.Utils;

public final class ProfileBuilderImpl
implements ProfileBuilder {
    private String profileId;
    private Map<String, FileContent> fileMapping = new HashMap<String, FileContent>();
    private boolean isOverlay;

    @Override
    public ProfileBuilder from(Profile profile) {
        this.profileId = profile.getId();
        this.setFileConfigurations(profile.getFileConfigurations());
        return this;
    }

    @Override
    public ProfileBuilder identity(String profileId) {
        this.profileId = profileId;
        return this;
    }

    @Override
    public List<String> getParents() {
        Map<String, Object> config = this.getConfigurationInternal("profile");
        String pspec = (String)config.get("attribute.parents");
        String[] parentIds = pspec != null ? pspec.split(" ") : new String[]{};
        return Arrays.asList(parentIds);
    }

    @Override
    public ProfileBuilder addParent(String parentId) {
        return this.addParentsInternal(Collections.singletonList(parentId), false);
    }

    @Override
    public ProfileBuilder addParents(List<String> parentIds) {
        return this.addParentsInternal(parentIds, false);
    }

    @Override
    public ProfileBuilder setParents(List<String> parentIds) {
        return this.addParentsInternal(parentIds, true);
    }

    private ProfileBuilder addParentsInternal(List<String> parentIds, boolean clear) {
        LinkedHashSet<String> currentIds = new LinkedHashSet<String>(this.getParents());
        if (clear) {
            currentIds.clear();
        }
        if (parentIds != null) {
            currentIds.addAll(parentIds);
        }
        this.updateParentsAttribute(currentIds);
        return this;
    }

    @Override
    public ProfileBuilder removeParent(String profileId) {
        LinkedHashSet<String> currentIds = new LinkedHashSet<String>(this.getParents());
        currentIds.remove(profileId);
        this.updateParentsAttribute(currentIds);
        return this;
    }

    private void updateParentsAttribute(Collection<String> parentIds) {
        Map<String, Object> config = this.getConfigurationInternal("profile");
        config.remove("attribute.parents");
        if (parentIds.size() > 0) {
            config.put("attribute.parents", this.parentsAttributeValue(parentIds));
        }
        this.addConfiguration("profile", config);
    }

    private String parentsAttributeValue(Collection<String> parentIds) {
        return parentIds.isEmpty() ? "" : String.join((CharSequence)" ", parentIds);
    }

    @Override
    public Set<String> getFileConfigurationKeys() {
        return this.fileMapping.keySet();
    }

    @Override
    public byte[] getFileConfiguration(String key) {
        return this.fileMapping.get(key) == null ? null : this.fileMapping.get((Object)key).bytes;
    }

    @Override
    public ProfileBuilder setFileConfigurations(Map<String, byte[]> configurations) {
        this.fileMapping = new HashMap<String, FileContent>();
        configurations.forEach((name, bytes) -> this.fileMapping.put((String)name, new FileContent((byte[])bytes, false)));
        return this;
    }

    @Override
    public ProfileBuilder addFileConfiguration(String fileName, byte[] data) {
        this.fileMapping.put(fileName, new FileContent(data, false));
        return this;
    }

    @Override
    public ProfileBuilder deleteFileConfiguration(String fileName) {
        this.fileMapping.remove(fileName);
        return this;
    }

    @Override
    public ProfileBuilder setConfigurations(Map<String, Map<String, Object>> configs) {
        for (String string : this.getConfigurationKeys()) {
            this.deleteConfiguration(string);
        }
        for (Map.Entry entry : configs.entrySet()) {
            this.addConfiguration((String)entry.getKey(), new HashMap<String, Object>((Map)entry.getValue()));
        }
        return this;
    }

    @Override
    public ProfileBuilder addConfiguration(String pid, Map<String, Object> config) {
        this.fileMapping.put(pid + ".cfg", new FileContent(Utils.toBytes(config), true));
        return this;
    }

    @Override
    public ProfileBuilder addConfiguration(String pid, String key, Object value) {
        Map<String, Object> config = this.getConfigurationInternal(pid);
        config.put(key, value);
        return this.addConfiguration(pid, config);
    }

    @Override
    public Set<String> getConfigurationKeys() {
        HashSet<String> result = new HashSet<String>();
        for (String fileKey : this.fileMapping.keySet()) {
            if (!fileKey.endsWith(".cfg")) continue;
            String configKey = fileKey.substring(0, fileKey.indexOf(".cfg"));
            result.add(configKey);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Map<String, Object> getConfiguration(String pid) {
        return this.getConfigurationInternal(pid);
    }

    private Map<String, Object> getConfigurationInternal(String pid) {
        FileContent content = this.fileMapping.get(pid + ".cfg");
        return Utils.toProperties(content == null ? null : content.bytes);
    }

    @Override
    public ProfileBuilder deleteConfiguration(String pid) {
        this.fileMapping.remove(pid + ".cfg");
        return this;
    }

    @Override
    public ProfileBuilder setBundles(List<String> values) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.BUNDLES, values);
        return this;
    }

    @Override
    public ProfileBuilder addBundle(String value) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.BUNDLES, value);
        return this;
    }

    @Override
    public ProfileBuilder setFeatures(List<String> values) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.FEATURES, values);
        return this;
    }

    @Override
    public ProfileBuilder addFeature(String value) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.FEATURES, value);
        return this;
    }

    @Override
    public ProfileBuilder setRepositories(List<String> values) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.REPOSITORIES, values);
        return this;
    }

    @Override
    public ProfileBuilder addRepository(String value) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.REPOSITORIES, value);
        return this;
    }

    @Override
    public ProfileBuilder setBlacklistedBundles(List<String> values) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.BLACKLISTED_BUNDLES, values);
        return null;
    }

    @Override
    public ProfileBuilder addBlacklistedBundle(String value) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.BLACKLISTED_BUNDLES, value);
        return null;
    }

    @Override
    public ProfileBuilder setBlacklistedFeatures(List<String> values) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.BLACKLISTED_FEATURES, values);
        return null;
    }

    @Override
    public ProfileBuilder addBlacklistedFeature(String value) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.BLACKLISTED_FEATURES, value);
        return null;
    }

    @Override
    public ProfileBuilder setBlacklistedRepositories(List<String> values) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.BLACKLISTED_REPOSITORIES, values);
        return null;
    }

    @Override
    public ProfileBuilder addBlacklistedRepository(String value) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.BLACKLISTED_REPOSITORIES, value);
        return null;
    }

    @Override
    public ProfileBuilder setOverrides(List<String> values) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.OVERRIDES, values);
        return this;
    }

    @Override
    public ProfileBuilder setOptionals(List<String> values) {
        this.addProfileConfiguration(ProfileImpl.ConfigListType.OPTIONALS, values);
        return this;
    }

    @Override
    public ProfileBuilder setOverlay(boolean overlay) {
        this.isOverlay = overlay;
        this.addConfiguration("profile", "attribute.overlay", Boolean.toString(overlay));
        return this;
    }

    @Override
    public ProfileBuilder addAttribute(String key, String value) {
        this.addConfiguration("profile", "attribute." + key, value);
        return this;
    }

    @Override
    public ProfileBuilder setAttributes(Map<String, String> attributes) {
        Map<String, Object> config = this.getConfigurationInternal("profile");
        for (String string : new ArrayList<String>(config.keySet())) {
            if (!string.startsWith("attribute.")) continue;
            config.remove(string);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            config.put("attribute." + (String)entry.getKey(), entry.getValue());
        }
        this.addConfiguration("profile", config);
        return null;
    }

    private void addProfileConfiguration(ProfileImpl.ConfigListType type, List<String> values) {
        String prefix = (Object)((Object)type) + ".";
        Map<String, Object> config = this.getConfigurationInternal("profile");
        for (String key : new ArrayList<String>(config.keySet())) {
            if (!key.startsWith(prefix)) continue;
            config.remove(key);
        }
        for (String value : values) {
            config.put(prefix + value, value);
        }
        this.addConfiguration("profile", config);
    }

    private void addProfileConfiguration(ProfileImpl.ConfigListType type, String value) {
        String prefix = (Object)((Object)type) + ".";
        Map<String, Object> config = this.getConfigurationInternal("profile");
        config.put(prefix + value, value);
        this.addConfiguration("profile", config);
    }

    @Override
    public Profile getProfile() {
        LinkedHashMap<String, byte[]> files = new LinkedHashMap<String, byte[]>();
        this.fileMapping.forEach((k, v) -> files.put((String)k, this.reformat((String)k, (FileContent)v)));
        return new ProfileImpl(this.profileId, this.getParents(), files, this.isOverlay);
    }

    private byte[] reformat(String name, FileContent fileContent) {
        if (!(fileContent.generated && this.isOverlay && name.equals("profile.cfg"))) {
            return fileContent.bytes;
        }
        TypedProperties properties = Utils.toProperties(fileContent.bytes);
        TypedProperties result = Utils.toProperties((byte[])null);
        String parents = null;
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> repositories = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> features = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> bundles = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> blacklistedRepositories = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> blacklistedFeatures = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> blacklistedBundles = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> libraries = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> bootLibraries = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> endorsedLibraries = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> extLibraries = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> system = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> overrides = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> optionals = new LinkedHashMap<String, Object>();
        for (String key : properties.keySet()) {
            Object v = properties.get(key);
            if (key.equals("attribute.parents")) {
                parents = (String)v;
                continue;
            }
            if (key.startsWith("attribute.")) {
                attributes.put(key, v);
                continue;
            }
            if (key.startsWith("repository.")) {
                repositories.put(key, v);
                continue;
            }
            if (key.startsWith("feature.")) {
                features.put(key, v);
                continue;
            }
            if (key.startsWith("bundle.")) {
                bundles.put(key, v);
                continue;
            }
            if (key.startsWith("blacklisted.repository.")) {
                blacklistedRepositories.put(key, v);
                continue;
            }
            if (key.startsWith("blacklisted.feature.")) {
                blacklistedFeatures.put(key, v);
                continue;
            }
            if (key.startsWith("blacklisted.bundle.")) {
                blacklistedBundles.put(key, v);
                continue;
            }
            if (key.startsWith("library.")) {
                libraries.put(key, v);
                continue;
            }
            if (key.startsWith("boot.")) {
                bootLibraries.put(key, v);
                continue;
            }
            if (key.startsWith("endorsed.")) {
                endorsedLibraries.put(key, v);
                continue;
            }
            if (key.startsWith("ext.")) {
                extLibraries.put(key, v);
                continue;
            }
            if (key.startsWith("config.")) {
                config.put(key, v);
                continue;
            }
            if (key.startsWith("system.")) {
                system.put(key, v);
                continue;
            }
            if (key.startsWith("override.")) {
                overrides.put(key, v);
                continue;
            }
            if (!key.startsWith("optional.")) continue;
            optionals.put(key, v);
        }
        result.setHeader(Arrays.asList("#", "# Profile generated by Karaf Assembly Builder", "#"));
        if (parents != null) {
            result.put("attribute.parents", this.comment("Parent profiles"), (Object)parents);
        }
        this.addGroupOfProperties("Attributes", result, attributes);
        this.addGroupOfProperties("Feature XML repositories", result, repositories);
        this.addGroupOfProperties("Features", result, features);
        this.addGroupOfProperties("Bundles", result, bundles);
        this.addGroupOfProperties("Libraries", result, libraries);
        this.addGroupOfProperties("Boot libraries", result, bootLibraries);
        this.addGroupOfProperties("Endorsed libraries", result, endorsedLibraries);
        this.addGroupOfProperties("Extension libraries", result, extLibraries);
        this.addGroupOfProperties("Configuration properties for etc/config.properties", result, config);
        this.addGroupOfProperties("Configuration properties for etc/system.properties", result, system);
        this.addGroupOfProperties("Bundle overrides (deprecated)", result, overrides);
        this.addGroupOfProperties("Optional resources for resolution", result, optionals);
        this.addGroupOfProperties("Blacklisted repositories", result, blacklistedRepositories);
        this.addGroupOfProperties("Blacklisted features", result, blacklistedFeatures);
        this.addGroupOfProperties("Blacklisted bundles", result, blacklistedBundles);
        return Utils.toBytes(result);
    }

    private void addGroupOfProperties(String comment, TypedProperties properties, Map<String, Object> values) {
        boolean first = true;
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            if (first) {
                first = false;
                properties.put(entry.getKey(), this.comment(comment), entry.getValue());
                continue;
            }
            properties.put(entry.getKey(), entry.getValue());
        }
    }

    private List<String> comment(String comment) {
        return Arrays.asList("", "# " + comment);
    }

    static class FileContent {
        byte[] bytes;
        boolean generated;

        public FileContent(byte[] bytes, boolean generated) {
            this.bytes = bytes;
            this.generated = generated;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileContent that = (FileContent)o;
            return Arrays.equals(this.bytes, that.bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }
}

