/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.assembly;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.download.impl.AbstractDownloadTask;
import org.apache.karaf.features.internal.download.impl.MavenDownloadManager;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.assembly.CustomSimpleDownloadTask;
import org.ops4j.pax.url.mvn.MavenResolver;

public class CustomDownloadManager
extends MavenDownloadManager {
    private final Profile profile;
    private final Map<String, String> translatedUrls;

    public CustomDownloadManager(MavenResolver resolver, ScheduledExecutorService executor) {
        this(resolver, executor, null, null);
    }

    public CustomDownloadManager(MavenResolver resolver, ScheduledExecutorService executor, Profile profile) {
        this(resolver, executor, profile, null);
    }

    public CustomDownloadManager(MavenResolver resolver, ScheduledExecutorService executor, Profile profile, Map<String, String> translatedUrls) {
        super(resolver, executor, 0L, 1);
        this.profile = profile;
        this.translatedUrls = translatedUrls;
    }

    protected AbstractDownloadTask createCustomDownloadTask(String url) {
        return new CustomSimpleDownloadTask(this.executorService, this.profile, url);
    }

    public Downloader createDownloader() {
        return new CustomMavenDownloader();
    }

    class CustomMavenDownloader
    extends MavenDownloadManager.MavenDownloader {
        CustomMavenDownloader() {
            super((MavenDownloadManager)CustomDownloadManager.this);
        }

        protected AbstractDownloadTask createDownloadTask(String url) {
            if (CustomDownloadManager.this.translatedUrls != null && CustomDownloadManager.this.translatedUrls.containsKey(url)) {
                url = (String)CustomDownloadManager.this.translatedUrls.get(url);
            }
            return super.createDownloadTask(url);
        }
    }
}

