/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.impl.ProfileBuilderImpl;

public interface ProfileBuilder {
    public ProfileBuilder addAttribute(String var1, String var2);

    public ProfileBuilder setAttributes(Map<String, String> var1);

    public ProfileBuilder from(Profile var1);

    public ProfileBuilder identity(String var1);

    public List<String> getParents();

    public ProfileBuilder addParent(String var1);

    public ProfileBuilder addParents(List<String> var1);

    public ProfileBuilder setParents(List<String> var1);

    public ProfileBuilder removeParent(String var1);

    public Set<String> getConfigurationKeys();

    public Map<String, Object> getConfiguration(String var1);

    public ProfileBuilder addConfiguration(String var1, Map<String, Object> var2);

    public ProfileBuilder addConfiguration(String var1, String var2, Object var3);

    public ProfileBuilder setConfigurations(Map<String, Map<String, Object>> var1);

    public ProfileBuilder deleteConfiguration(String var1);

    public Set<String> getFileConfigurationKeys();

    public byte[] getFileConfiguration(String var1);

    public ProfileBuilder addFileConfiguration(String var1, byte[] var2);

    public ProfileBuilder setFileConfigurations(Map<String, byte[]> var1);

    public ProfileBuilder deleteFileConfiguration(String var1);

    public ProfileBuilder setBundles(List<String> var1);

    public ProfileBuilder addBundle(String var1);

    public ProfileBuilder setFeatures(List<String> var1);

    public ProfileBuilder addFeature(String var1);

    public ProfileBuilder setRepositories(List<String> var1);

    public ProfileBuilder addRepository(String var1);

    public ProfileBuilder setBlacklistedBundles(List<String> var1);

    public ProfileBuilder addBlacklistedBundle(String var1);

    public ProfileBuilder setBlacklistedFeatures(List<String> var1);

    public ProfileBuilder addBlacklistedFeature(String var1);

    public ProfileBuilder setBlacklistedRepositories(List<String> var1);

    public ProfileBuilder addBlacklistedRepository(String var1);

    public ProfileBuilder setOverrides(List<String> var1);

    public ProfileBuilder setOptionals(List<String> var1);

    public ProfileBuilder setOverlay(boolean var1);

    public Profile getProfile();

    public static final class Factory {
        public static ProfileBuilder create() {
            return new ProfileBuilderImpl();
        }

        public static ProfileBuilder create(String profileId) {
            return new ProfileBuilderImpl().identity(profileId);
        }

        public static ProfileBuilder createFrom(Profile profile) {
            return new ProfileBuilderImpl().from(profile);
        }

        private Factory() {
        }
    }
}

