/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEventKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class DataChangeEventBuilder
implements Builder<DataChangeEvent> {
    private DataChangeEvent.Operation _operation;
    private InstanceIdentifier<?> _path;
    private DataChangeEvent.Store _store;
    private DataChangeEventKey key;
    Map<Class<? extends Augmentation<DataChangeEvent>>, Augmentation<DataChangeEvent>> augmentation = Collections.emptyMap();

    public DataChangeEventBuilder() {
    }

    public DataChangeEventBuilder(DataChangeEvent base) {
        Map aug;
        this.key = base.key();
        this._path = base.getPath();
        this._operation = base.getOperation();
        this._store = base.getStore();
        if (base instanceof DataChangeEventImpl) {
            DataChangeEventImpl impl = (DataChangeEventImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DataChangeEvent>>, Augmentation<DataChangeEvent>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DataChangeEvent>>, Augmentation<DataChangeEvent>>(aug);
        }
    }

    public DataChangeEventKey key() {
        return this.key;
    }

    public DataChangeEvent.Operation getOperation() {
        return this._operation;
    }

    public InstanceIdentifier<?> getPath() {
        return this._path;
    }

    public DataChangeEvent.Store getStore() {
        return this._store;
    }

    public <E$$ extends Augmentation<DataChangeEvent>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public DataChangeEventBuilder withKey(DataChangeEventKey key) {
        this.key = key;
        return this;
    }

    public DataChangeEventBuilder setOperation(DataChangeEvent.Operation value) {
        this._operation = value;
        return this;
    }

    public DataChangeEventBuilder setPath(InstanceIdentifier<?> value) {
        this._path = value;
        return this;
    }

    public DataChangeEventBuilder setStore(DataChangeEvent.Store value) {
        this._store = value;
        return this;
    }

    public DataChangeEventBuilder addAugmentation(Class<? extends Augmentation<DataChangeEvent>> augmentationType, Augmentation<DataChangeEvent> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DataChangeEvent>>, Augmentation<DataChangeEvent>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DataChangeEventBuilder removeAugmentation(Class<? extends Augmentation<DataChangeEvent>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DataChangeEvent build() {
        return new DataChangeEventImpl(this);
    }

    private static final class DataChangeEventImpl
    implements DataChangeEvent {
        private final DataChangeEvent.Operation _operation;
        private final InstanceIdentifier<?> _path;
        private final DataChangeEvent.Store _store;
        private final DataChangeEventKey key;
        private Map<Class<? extends Augmentation<DataChangeEvent>>, Augmentation<DataChangeEvent>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        DataChangeEventImpl(DataChangeEventBuilder base) {
            this.key = base.key() != null ? base.key() : new DataChangeEventKey(base.getPath());
            this._path = this.key.getPath();
            this._operation = base.getOperation();
            this._store = base.getStore();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<DataChangeEvent> getImplementedInterface() {
            return DataChangeEvent.class;
        }

        @Override
        public DataChangeEventKey key() {
            return this.key;
        }

        @Override
        public DataChangeEvent.Operation getOperation() {
            return this._operation;
        }

        @Override
        public InstanceIdentifier<?> getPath() {
            return this._path;
        }

        @Override
        public DataChangeEvent.Store getStore() {
            return this._store;
        }

        public <E$$ extends Augmentation<DataChangeEvent>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._operation);
            result = 31 * result + Objects.hashCode(this._path);
            result = 31 * result + Objects.hashCode((Object)this._store);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DataChangeEvent.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DataChangeEvent other = (DataChangeEvent)obj;
            if (!Objects.equals((Object)this._operation, (Object)other.getOperation())) {
                return false;
            }
            if (!Objects.equals(this._path, other.getPath())) {
                return false;
            }
            if (!Objects.equals((Object)this._store, (Object)other.getStore())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DataChangeEventImpl otherImpl = (DataChangeEventImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DataChangeEvent>>, Augmentation<DataChangeEvent>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"DataChangeEvent");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_operation", (Object)((Object)this._operation));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_path", this._path);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_store", (Object)((Object)this._store));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

