/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.DataChangedNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.remote.rev140114.data.changed.notification.DataChangeEvent;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DataChangedNotificationBuilder
implements Builder<DataChangedNotification> {
    private List<DataChangeEvent> _dataChangeEvent;
    Map<Class<? extends Augmentation<DataChangedNotification>>, Augmentation<DataChangedNotification>> augmentation = Collections.emptyMap();

    public DataChangedNotificationBuilder() {
    }

    public DataChangedNotificationBuilder(DataChangedNotification base) {
        Map aug;
        this._dataChangeEvent = base.getDataChangeEvent();
        if (base instanceof DataChangedNotificationImpl) {
            DataChangedNotificationImpl impl = (DataChangedNotificationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DataChangedNotification>>, Augmentation<DataChangedNotification>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DataChangedNotification>>, Augmentation<DataChangedNotification>>(aug);
        }
    }

    public List<DataChangeEvent> getDataChangeEvent() {
        return this._dataChangeEvent;
    }

    public <E$$ extends Augmentation<DataChangedNotification>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public DataChangedNotificationBuilder setDataChangeEvent(List<DataChangeEvent> values) {
        this._dataChangeEvent = values;
        return this;
    }

    public DataChangedNotificationBuilder addAugmentation(Class<? extends Augmentation<DataChangedNotification>> augmentationType, Augmentation<DataChangedNotification> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DataChangedNotification>>, Augmentation<DataChangedNotification>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DataChangedNotificationBuilder removeAugmentation(Class<? extends Augmentation<DataChangedNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DataChangedNotification build() {
        return new DataChangedNotificationImpl(this);
    }

    private static final class DataChangedNotificationImpl
    implements DataChangedNotification {
        private final List<DataChangeEvent> _dataChangeEvent;
        private Map<Class<? extends Augmentation<DataChangedNotification>>, Augmentation<DataChangedNotification>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        DataChangedNotificationImpl(DataChangedNotificationBuilder base) {
            this._dataChangeEvent = base.getDataChangeEvent();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<DataChangedNotification> getImplementedInterface() {
            return DataChangedNotification.class;
        }

        @Override
        public List<DataChangeEvent> getDataChangeEvent() {
            return this._dataChangeEvent;
        }

        public <E$$ extends Augmentation<DataChangedNotification>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dataChangeEvent);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DataChangedNotification.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DataChangedNotification other = (DataChangedNotification)obj;
            if (!Objects.equals(this._dataChangeEvent, other.getDataChangeEvent())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DataChangedNotificationImpl otherImpl = (DataChangedNotificationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DataChangedNotification>>, Augmentation<DataChangedNotification>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"DataChangedNotification");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dataChangeEvent", this._dataChangeEvent);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

