/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.subscribe.to.notification.rev161028;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.subscribe.to.notification.rev161028.Notifi;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NotifiBuilder
implements Builder<Notifi> {
    private String _location;
    Map<Class<? extends Augmentation<Notifi>>, Augmentation<Notifi>> augmentation = Collections.emptyMap();

    public NotifiBuilder() {
    }

    public NotifiBuilder(Notifi base) {
        Map aug;
        this._location = base.getLocation();
        if (base instanceof NotifiImpl) {
            NotifiImpl impl = (NotifiImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Notifi>>, Augmentation<Notifi>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Notifi>>, Augmentation<Notifi>>(aug);
        }
    }

    public String getLocation() {
        return this._location;
    }

    public <E$$ extends Augmentation<Notifi>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NotifiBuilder setLocation(String value) {
        this._location = value;
        return this;
    }

    public NotifiBuilder addAugmentation(Class<? extends Augmentation<Notifi>> augmentationType, Augmentation<Notifi> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Notifi>>, Augmentation<Notifi>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NotifiBuilder removeAugmentation(Class<? extends Augmentation<Notifi>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Notifi build() {
        return new NotifiImpl(this);
    }

    private static final class NotifiImpl
    implements Notifi {
        private final String _location;
        private Map<Class<? extends Augmentation<Notifi>>, Augmentation<Notifi>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NotifiImpl(NotifiBuilder base) {
            this._location = base.getLocation();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Notifi> getImplementedInterface() {
            return Notifi.class;
        }

        @Override
        public String getLocation() {
            return this._location;
        }

        public <E$$ extends Augmentation<Notifi>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._location);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Notifi.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Notifi other = (Notifi)obj;
            if (!Objects.equals(this._location, other.getLocation())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NotifiImpl otherImpl = (NotifiImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Notifi>>, Augmentation<Notifi>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Notifi");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_location", (Object)this._location);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

