/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.fastzipfilereader;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import nonapi.io.github.classgraph.fastzipfilereader.ZipFileSlice;

class ZipFileSliceReader
implements AutoCloseable {
    private final ZipFileSlice zipFileSlice;
    private final ByteBuffer[] chunkCache;
    private final byte[] buf = new byte[8];

    public ZipFileSliceReader(ZipFileSlice zipFileSlice) {
        this.zipFileSlice = zipFileSlice;
        this.chunkCache = new ByteBuffer[zipFileSlice.physicalZipFile.numMappedByteBuffers];
    }

    private ByteBuffer getChunk(int chunkIdx) throws IOException {
        ByteBuffer chunk = this.chunkCache[chunkIdx];
        if (chunk == null) {
            ByteBuffer byteBufferDup;
            chunk = this.chunkCache[chunkIdx] = (byteBufferDup = this.zipFileSlice.physicalZipFile.getByteBuffer(chunkIdx).duplicate());
        }
        return chunk;
    }

    int read(long off, byte[] buf, int bufStart, int numBytesToRead) throws IOException {
        int numBytesRead;
        if (off < 0L || bufStart < 0 || bufStart + numBytesToRead > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        int currBufStart = bufStart;
        int totBytesRead = 0;
        long currOff = off;
        for (int remainingBytesToRead = numBytesToRead; remainingBytesToRead > 0; remainingBytesToRead -= numBytesRead) {
            long currOffAbsolute = this.zipFileSlice.startOffsetWithinPhysicalZipFile + currOff;
            int chunkIdx = (int)(currOffAbsolute / 0x7FFFFFF7L);
            ByteBuffer chunk = this.getChunk(chunkIdx);
            long chunkStartAbsolute = (long)chunkIdx * 0x7FFFFFF7L;
            int startReadPos = (int)(currOffAbsolute - chunkStartAbsolute);
            ((Buffer)chunk).mark();
            ((Buffer)chunk).position(startReadPos);
            numBytesRead = Math.min(chunk.remaining(), remainingBytesToRead);
            try {
                chunk.get(buf, currBufStart, numBytesRead);
            }
            catch (BufferUnderflowException e) {
                throw new EOFException("Unexpected EOF");
            }
            ((Buffer)chunk).reset();
            currOff += (long)numBytesRead;
            currBufStart += numBytesRead;
            totBytesRead += numBytesRead;
        }
        return totBytesRead == 0 && numBytesToRead > 0 ? -1 : totBytesRead;
    }

    static int getShort(byte[] buf, long off) throws IOException {
        int ioff = (int)off;
        if (ioff < 0 || ioff > buf.length - 2) {
            throw new IndexOutOfBoundsException();
        }
        return (buf[ioff + 1] & 0xFF) << 8 | buf[ioff + 0] & 0xFF;
    }

    int getShort(long off) throws IOException {
        if (off < 0L || off > this.zipFileSlice.len - 2L) {
            throw new IndexOutOfBoundsException();
        }
        if (this.read(off, this.buf, 0, 2) < 2) {
            throw new EOFException("Unexpected EOF");
        }
        return (this.buf[1] & 0xFF) << 8 | this.buf[0] & 0xFF;
    }

    static int getInt(byte[] buf, long off) throws IOException {
        int ioff = (int)off;
        if (ioff < 0 || ioff > buf.length - 4) {
            throw new IndexOutOfBoundsException();
        }
        return (buf[ioff + 3] & 0xFF) << 24 | (buf[ioff + 2] & 0xFF) << 16 | (buf[ioff + 1] & 0xFF) << 8 | buf[ioff + 0] & 0xFF;
    }

    int getInt(long off) throws IOException {
        if (off < 0L || off > this.zipFileSlice.len - 2L) {
            throw new IndexOutOfBoundsException();
        }
        if (this.read(off, this.buf, 0, 4) < 4) {
            throw new EOFException("Unexpected EOF");
        }
        return (this.buf[3] & 0xFF) << 24 | (this.buf[2] & 0xFF) << 16 | (this.buf[1] & 0xFF) << 8 | this.buf[0] & 0xFF;
    }

    static long getLong(byte[] buf, long off) throws IOException {
        int ioff = (int)off;
        if (ioff < 0 || ioff > buf.length - 8) {
            throw new IndexOutOfBoundsException();
        }
        return (long)((buf[ioff + 7] & 0xFF) << 24 | (buf[ioff + 6] & 0xFF) << 16 | ((buf[ioff + 5] & 0xFF) << 8) + (buf[ioff + 4] & 0xFF)) << 32 | (long)((buf[ioff + 3] & 0xFF) << 24) | (long)(((buf[ioff + 2] & 0xFF) << 16) + ((buf[ioff + 1] & 0xFF) << 8)) | (long)(buf[ioff + 0] & 0xFF);
    }

    long getLong(long off) throws IOException {
        if (off < 0L || off > this.zipFileSlice.len - 2L) {
            throw new IndexOutOfBoundsException();
        }
        if (this.read(off, this.buf, 0, 8) < 8) {
            throw new EOFException("Unexpected EOF");
        }
        return (long)((this.buf[7] & 0xFF) << 24 | (this.buf[6] & 0xFF) << 16 | (this.buf[5] & 0xFF) << 8 | this.buf[4] & 0xFF) << 32 | (long)((this.buf[3] & 0xFF) << 24) | (long)((this.buf[2] & 0xFF) << 16) | (long)((this.buf[1] & 0xFF) << 8) | (long)(this.buf[0] & 0xFF);
    }

    static String getString(byte[] buf, long off, int numBytes) throws IOException {
        int ioff = (int)off;
        if (ioff < 0 || ioff > buf.length - numBytes) {
            throw new IndexOutOfBoundsException();
        }
        return new String(buf, ioff, numBytes, StandardCharsets.UTF_8);
    }

    String getString(long off, int numBytes) throws IOException {
        if (off < 0L || off > this.zipFileSlice.len - (long)numBytes) {
            throw new IndexOutOfBoundsException();
        }
        byte[] strBytes = new byte[numBytes];
        if (this.read(off, strBytes, 0, numBytes) < numBytes) {
            throw new EOFException("Unexpected EOF");
        }
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    @Override
    public void close() {
        Arrays.fill(this.chunkCache, null);
    }
}

