/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.fastzipfilereader;

import io.github.classgraph.ModuleReaderProxy;
import io.github.classgraph.ModuleRef;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.concurrency.SingletonMap;
import nonapi.io.github.classgraph.fastzipfilereader.FastZipEntry;
import nonapi.io.github.classgraph.fastzipfilereader.LogicalZipFile;
import nonapi.io.github.classgraph.fastzipfilereader.PhysicalZipFile;
import nonapi.io.github.classgraph.fastzipfilereader.RecyclableInflater;
import nonapi.io.github.classgraph.fastzipfilereader.ZipFileSlice;
import nonapi.io.github.classgraph.recycler.Recycler;
import nonapi.io.github.classgraph.recycler.RecyclerExceptionless;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.LogNode;

public class NestedJarHandler {
    private SingletonMap<File, PhysicalZipFile> canonicalFileToPhysicalZipFileMap;
    private Queue<PhysicalZipFile> additionalAllocatedPhysicalZipFiles;
    private SingletonMap<FastZipEntry, ZipFileSlice> fastZipEntryToZipFileSliceMap;
    private SingletonMap<ZipFileSlice, LogicalZipFile> zipFileSliceToLogicalZipFileMap;
    private Queue<LogicalZipFile> allocatedLogicalZipFiles;
    public SingletonMap<String, Map.Entry<LogicalZipFile, String>> nestedPathToLogicalZipFileAndPackageRootMap;
    public SingletonMap<ModuleRef, Recycler<ModuleReaderProxy, IOException>> moduleRefToModuleReaderProxyRecyclerMap;
    public RecyclerExceptionless<RecyclableInflater> inflaterRecycler;
    private ConcurrentLinkedDeque<File> tempFiles = new ConcurrentLinkedDeque();
    public static final String TEMP_FILENAME_LEAF_SEPARATOR = "---";
    private static final int INFLATE_TO_DISK_THRESHOLD = 0x2000000;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public NestedJarHandler(final ScanSpec scanSpec, LogNode log) {
        this.inflaterRecycler = new RecyclerExceptionless<RecyclableInflater>(){

            @Override
            public RecyclableInflater newInstance() throws RuntimeException {
                if (NestedJarHandler.this.closed.get()) {
                    throw new RuntimeException(this.getClass().getSimpleName() + " already closed");
                }
                return new RecyclableInflater();
            }
        };
        this.canonicalFileToPhysicalZipFileMap = new SingletonMap<File, PhysicalZipFile>(){

            @Override
            public PhysicalZipFile newInstance(File canonicalFile, LogNode log) throws IOException {
                if (NestedJarHandler.this.closed.get()) {
                    throw new IOException(this.getClass().getSimpleName() + " already closed");
                }
                return new PhysicalZipFile(canonicalFile, NestedJarHandler.this);
            }
        };
        this.allocatedLogicalZipFiles = new ConcurrentLinkedQueue<LogicalZipFile>();
        this.additionalAllocatedPhysicalZipFiles = new ConcurrentLinkedQueue<PhysicalZipFile>();
        this.fastZipEntryToZipFileSliceMap = new SingletonMap<FastZipEntry, ZipFileSlice>(){

            @Override
            public ZipFileSlice newInstance(FastZipEntry childZipEntry, LogNode log) throws Exception {
                ZipFileSlice childZipEntrySlice;
                if (!childZipEntry.isDeflated) {
                    childZipEntrySlice = new ZipFileSlice(childZipEntry);
                } else {
                    InputStream inputStream;
                    if (childZipEntry.uncompressedSize < 0L || childZipEntry.uncompressedSize >= 0x2000000L || childZipEntry.compressedSize >= 0x2000000L) {
                        File tempFile = null;
                        try {
                            tempFile = NestedJarHandler.this.makeTempFile(childZipEntry.entryName, true);
                            if (log != null) {
                                log.log("Deflating zip entry to temporary file: " + childZipEntry + " ; uncompressed size: " + childZipEntry.uncompressedSize + " ; temp file: " + tempFile);
                            }
                            inputStream = childZipEntry.open();
                            try {
                                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            PhysicalZipFile physicalZipFile = (PhysicalZipFile)NestedJarHandler.this.canonicalFileToPhysicalZipFileMap.get(tempFile, log);
                            NestedJarHandler.this.additionalAllocatedPhysicalZipFiles.add(physicalZipFile);
                            childZipEntrySlice = new ZipFileSlice(physicalZipFile);
                        }
                        catch (IOException e) {
                            if (tempFile != null) {
                                tempFile.delete();
                            }
                            childZipEntrySlice = null;
                        }
                    } else {
                        childZipEntrySlice = null;
                    }
                    if (childZipEntrySlice == null) {
                        ByteBuffer byteBuffer;
                        if (childZipEntry.uncompressedSize > 0x7FFFFFF7L) {
                            throw new IOException("Uncompressed size of zip entry (" + childZipEntry.uncompressedSize + ") is too large to inflate to memory: " + childZipEntry.entryName);
                        }
                        if (log != null) {
                            log.log("Deflating zip entry to RAM: " + childZipEntry + " ; uncompressed size: " + childZipEntry.uncompressedSize);
                        }
                        inputStream = childZipEntry.open();
                        try {
                            byteBuffer = ByteBuffer.wrap(FileUtils.readAllBytesAsArray(inputStream, childZipEntry.uncompressedSize));
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        PhysicalZipFile physicalZipFileInRam = new PhysicalZipFile(byteBuffer, childZipEntry.parentLogicalZipFile.physicalZipFile.getFile(), childZipEntry.getPath(), NestedJarHandler.this);
                        NestedJarHandler.this.additionalAllocatedPhysicalZipFiles.add(physicalZipFileInRam);
                        childZipEntrySlice = new ZipFileSlice(physicalZipFileInRam, childZipEntry);
                    }
                }
                return childZipEntrySlice;
            }
        };
        this.zipFileSliceToLogicalZipFileMap = new SingletonMap<ZipFileSlice, LogicalZipFile>(){

            @Override
            public LogicalZipFile newInstance(ZipFileSlice zipFileSlice, LogNode log) throws Exception {
                if (NestedJarHandler.this.closed.get()) {
                    throw new IOException(this.getClass().getSimpleName() + " already closed");
                }
                LogicalZipFile logicalZipFile = new LogicalZipFile(zipFileSlice, scanSpec, log);
                NestedJarHandler.this.allocatedLogicalZipFiles.add(logicalZipFile);
                return logicalZipFile;
            }
        };
        this.nestedPathToLogicalZipFileAndPackageRootMap = new SingletonMap<String, Map.Entry<LogicalZipFile, String>>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Map.Entry<LogicalZipFile, String> newInstance(String nestedJarPathRaw, LogNode log) throws Exception {
                if (NestedJarHandler.this.closed.get()) {
                    throw new IOException(this.getClass().getSimpleName() + " already closed");
                }
                String nestedJarPath = FastPathResolver.resolve(nestedJarPathRaw);
                int lastPlingIdx = nestedJarPath.lastIndexOf(33);
                if (lastPlingIdx < 0) {
                    File canonicalFile;
                    boolean isRemote;
                    boolean bl = isRemote = nestedJarPath.startsWith("http://") || nestedJarPath.startsWith("https://");
                    if (isRemote) {
                        if (!scanSpec.enableRemoteJarScanning) throw new IOException("Remote jar scanning has not been enabled, cannot scan classpath element URL: " + nestedJarPath);
                        canonicalFile = NestedJarHandler.this.downloadTempFile(nestedJarPath, log);
                        if (canonicalFile == null) {
                            throw new IOException("Could not download jarfile " + nestedJarPath);
                        }
                    } else {
                        try {
                            canonicalFile = new File(nestedJarPath).getCanonicalFile();
                        }
                        catch (SecurityException e) {
                            throw new IOException("Path component " + nestedJarPath + " could not be canonicalized: " + e);
                        }
                    }
                    if (!FileUtils.canRead(canonicalFile)) {
                        throw new IOException("Path component " + nestedJarPath + " does not exist");
                    }
                    if (!canonicalFile.isFile()) {
                        throw new IOException("Path component " + nestedJarPath + "  is not a file (expected a jarfile)");
                    }
                    LogNode zipFileLog = log == null ? null : log.log("Opening jarfile " + canonicalFile);
                    PhysicalZipFile physicalZipFile = (PhysicalZipFile)NestedJarHandler.this.canonicalFileToPhysicalZipFileMap.get(canonicalFile, zipFileLog);
                    ZipFileSlice topLevelSlice = new ZipFileSlice(physicalZipFile);
                    LogicalZipFile logicalZipFile = (LogicalZipFile)NestedJarHandler.this.zipFileSliceToLogicalZipFileMap.get(topLevelSlice, zipFileLog);
                    return new AbstractMap.SimpleEntry<LogicalZipFile, String>(logicalZipFile, "");
                }
                String parentPath = nestedJarPath.substring(0, lastPlingIdx);
                String childPath = nestedJarPath.substring(lastPlingIdx + 1);
                childPath = FileUtils.sanitizeEntryPath(childPath, true);
                Map.Entry<LogicalZipFile, String> parentLogicalZipFileAndPackageRoot = NestedJarHandler.this.nestedPathToLogicalZipFileAndPackageRootMap.get(parentPath, log);
                if (parentLogicalZipFileAndPackageRoot == null) {
                    throw new IOException("Could not find parent jarfile " + parentPath);
                }
                LogicalZipFile parentLogicalZipFile = parentLogicalZipFileAndPackageRoot.getKey();
                if (parentLogicalZipFile == null) {
                    throw new IOException("Could not find parent jarfile " + parentPath);
                }
                boolean isDirectory = false;
                while (childPath.endsWith("/")) {
                    isDirectory = true;
                    childPath = childPath.substring(0, childPath.length() - 1);
                }
                FastZipEntry childZipEntry = null;
                if (!isDirectory) {
                    for (FastZipEntry fastZipEntry : parentLogicalZipFile.getEntries()) {
                        if (!fastZipEntry.entryName.equals(childPath)) continue;
                        childZipEntry = fastZipEntry;
                        break;
                    }
                }
                if (childZipEntry == null) {
                    String childPathPrefix = childPath + "/";
                    for (FastZipEntry entry : parentLogicalZipFile.getEntries()) {
                        if (!entry.entryName.startsWith(childPathPrefix)) continue;
                        isDirectory = true;
                        break;
                    }
                    if (!isDirectory) {
                        throw new IOException("Path " + childPath + " does not exist in jarfile " + parentLogicalZipFile);
                    }
                }
                if (isDirectory) {
                    if (childPath.isEmpty()) return new AbstractMap.SimpleEntry<LogicalZipFile, String>(parentLogicalZipFile, childPath);
                    if (log != null) {
                        log.log("Path " + childPath + " in jarfile " + parentLogicalZipFile + " is a directory, not a file -- using as package root");
                    }
                    parentLogicalZipFile.classpathRoots.add(childPath);
                    return new AbstractMap.SimpleEntry<LogicalZipFile, String>(parentLogicalZipFile, childPath);
                }
                if (!scanSpec.scanNestedJars) {
                    throw new IOException("Nested jar scanning is disabled -- skipping nested jar " + nestedJarPath);
                }
                try {
                    ZipFileSlice childZipEntrySlice = (ZipFileSlice)NestedJarHandler.this.fastZipEntryToZipFileSliceMap.get(childZipEntry, log);
                    if (childZipEntrySlice == null) {
                        throw new IOException("Could not open nested jarfile entry: " + childZipEntry.getPath());
                    }
                    LogNode logNode = log == null ? null : log.log("Getting zipfile slice " + childZipEntrySlice);
                    LogicalZipFile childLogicalZipFile = (LogicalZipFile)NestedJarHandler.this.zipFileSliceToLogicalZipFileMap.get(childZipEntrySlice, logNode);
                    return new AbstractMap.SimpleEntry<LogicalZipFile, String>(childLogicalZipFile, "");
                }
                catch (IOException e) {
                    throw new IOException("File does not appear to be a zipfile: " + childPath);
                }
            }
        };
        this.moduleRefToModuleReaderProxyRecyclerMap = new SingletonMap<ModuleRef, Recycler<ModuleReaderProxy, IOException>>(){

            @Override
            public Recycler<ModuleReaderProxy, IOException> newInstance(final ModuleRef moduleRef, LogNode log) {
                return new Recycler<ModuleReaderProxy, IOException>(){

                    @Override
                    public ModuleReaderProxy newInstance() throws IOException {
                        if (NestedJarHandler.this.closed.get()) {
                            throw new IOException(this.getClass().getSimpleName() + " already closed");
                        }
                        return moduleRef.open();
                    }
                };
            }
        };
    }

    private String leafname(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private String sanitizeFilename(String filename) {
        return filename.replace('/', '_').replace('\\', '_').replace(':', '_').replace('?', '_').replace('&', '_').replace('=', '_').replace(' ', '_');
    }

    private File makeTempFile(String filePath, boolean onlyUseLeafname) throws IOException {
        File tempFile = File.createTempFile("ClassGraph--", TEMP_FILENAME_LEAF_SEPARATOR + this.sanitizeFilename(onlyUseLeafname ? this.leafname(filePath) : filePath));
        tempFile.deleteOnExit();
        this.tempFiles.add(tempFile);
        return tempFile;
    }

    private File downloadTempFile(String jarURL, LogNode log) {
        File tempFile;
        LogNode subLog = log == null ? null : log.log(jarURL, "Downloading URL " + jarURL);
        try {
            tempFile = this.makeTempFile(jarURL, true);
            URL url = new URL(jarURL);
            try (InputStream inputStream = url.openStream();){
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (subLog != null) {
                subLog.addElapsedTime();
            }
        }
        catch (Exception e) {
            if (subLog != null) {
                subLog.log("Could not download " + jarURL, e);
            }
            return null;
        }
        if (subLog != null) {
            subLog.log("Downloaded to temporary file " + tempFile);
            subLog.log("***** Note that it is time-consuming to scan jars at http(s) addresses, they must be downloaded for every scan, and the same jars must also be separately downloaded by the ClassLoader *****");
        }
        return tempFile;
    }

    public void close(LogNode log) {
        if (!this.closed.getAndSet(true)) {
            Object logicalZipFile2;
            if (this.inflaterRecycler != null) {
                this.inflaterRecycler.forceClose();
                this.inflaterRecycler = null;
            }
            if (this.moduleRefToModuleReaderProxyRecyclerMap != null) {
                try {
                    for (Recycler<ModuleReaderProxy, IOException> recycler : this.moduleRefToModuleReaderProxyRecyclerMap.values()) {
                        recycler.forceClose();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.moduleRefToModuleReaderProxyRecyclerMap.clear();
                this.moduleRefToModuleReaderProxyRecyclerMap = null;
            }
            if (this.zipFileSliceToLogicalZipFileMap != null) {
                this.zipFileSliceToLogicalZipFileMap.clear();
                this.zipFileSliceToLogicalZipFileMap = null;
            }
            if (this.nestedPathToLogicalZipFileAndPackageRootMap != null) {
                this.nestedPathToLogicalZipFileAndPackageRootMap.clear();
                this.nestedPathToLogicalZipFileAndPackageRootMap = null;
            }
            while ((logicalZipFile2 = this.allocatedLogicalZipFiles.poll()) != null) {
                ((LogicalZipFile)logicalZipFile2).close();
            }
            if (this.canonicalFileToPhysicalZipFileMap != null) {
                try {
                    for (PhysicalZipFile physicalZipFile : this.canonicalFileToPhysicalZipFileMap.values()) {
                        physicalZipFile.close();
                    }
                }
                catch (InterruptedException logicalZipFile2) {
                    // empty catch block
                }
                this.canonicalFileToPhysicalZipFileMap.clear();
                this.canonicalFileToPhysicalZipFileMap = null;
            }
            if (this.additionalAllocatedPhysicalZipFiles != null) {
                PhysicalZipFile physicalZipFile;
                while ((physicalZipFile = this.additionalAllocatedPhysicalZipFiles.poll()) != null) {
                    physicalZipFile.close();
                }
                this.additionalAllocatedPhysicalZipFiles.clear();
                this.additionalAllocatedPhysicalZipFiles = null;
            }
            if (this.fastZipEntryToZipFileSliceMap != null) {
                this.fastZipEntryToZipFileSliceMap.clear();
                this.fastZipEntryToZipFileSliceMap = null;
            }
            if (this.tempFiles != null) {
                LogNode rmLog;
                LogNode logNode = rmLog = this.tempFiles.isEmpty() || log == null ? null : log.log("Removing temporary files");
                while (!this.tempFiles.isEmpty()) {
                    File tempFile = this.tempFiles.removeLast();
                    String path = tempFile.getPath();
                    boolean success = false;
                    Throwable e = null;
                    try {
                        success = tempFile.delete();
                    }
                    catch (Throwable t) {
                        e = t;
                    }
                    if (rmLog == null) continue;
                    rmLog.log((success ? "Removed" : "Unable to remove") + " " + path + (e == null ? "" : " : " + e));
                }
                this.tempFiles.clear();
                this.tempFiles = null;
            }
        }
    }
}

