/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassGraphClassLoader;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ClasspathElementDir;
import io.github.classgraph.ClasspathElementModule;
import io.github.classgraph.ClasspathElementZip;
import io.github.classgraph.ModuleInfo;
import io.github.classgraph.ModuleInfoList;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.PackageInfo;
import io.github.classgraph.PackageInfoList;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import java.io.Closeable;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classpath.ClassLoaderAndModuleFinder;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.json.JSONDeserializer;
import nonapi.io.github.classgraph.json.JSONSerializer;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;

public final class ScanResult
implements Closeable,
AutoCloseable {
    private final List<String> rawClasspathEltOrderStrs;
    private List<ClasspathElement> classpathOrder;
    private ResourceList allWhitelistedResources;
    private Map<String, ResourceList> pathToWhitelistedResourceList;
    private Map<String, ClassInfo> classNameToClassInfo;
    private Map<String, PackageInfo> packageNameToPackageInfo;
    private Map<String, ModuleInfo> moduleNameToModuleInfo;
    private Map<File, Long> fileToLastModified;
    private ClassGraphClassLoader classGraphClassLoader;
    ClassLoader[] envClassLoaderOrder;
    private NestedJarHandler nestedJarHandler;
    final ScanSpec scanSpec;
    private volatile AtomicBoolean closed = new AtomicBoolean(false);
    final LogNode log;
    private static final String CURRENT_SERIALIZATION_FORMAT = "6";
    private final WeakReference<ScanResult> weakReference;
    private static final Set<WeakReference<ScanResult>> nonClosedWeakReferences = Collections.newSetFromMap(new ConcurrentHashMap());

    ScanResult(ScanSpec scanSpec, List<ClasspathElement> classpathOrder, List<String> rawClasspathEltOrderStrs, ClassLoader[] envClassLoaderOrder, Map<String, ClassInfo> classNameToClassInfo, Map<String, PackageInfo> packageNameToPackageInfo, Map<String, ModuleInfo> moduleNameToModuleInfo, Map<File, Long> fileToLastModified, NestedJarHandler nestedJarHandler, LogNode log) {
        this.scanSpec = scanSpec;
        this.rawClasspathEltOrderStrs = rawClasspathEltOrderStrs;
        this.classpathOrder = classpathOrder;
        for (ClasspathElement classpathElt : classpathOrder) {
            if (classpathElt.whitelistedResources == null) continue;
            if (this.allWhitelistedResources == null) {
                this.allWhitelistedResources = new ResourceList();
                this.pathToWhitelistedResourceList = new HashMap<String, ResourceList>();
            }
            this.allWhitelistedResources.addAll(classpathElt.whitelistedResources);
            for (Resource resource : classpathElt.whitelistedResources) {
                String path = resource.getPath();
                ResourceList resourceList = this.pathToWhitelistedResourceList.get(path);
                if (resourceList == null) {
                    resourceList = new ResourceList();
                    this.pathToWhitelistedResourceList.put(path, resourceList);
                }
                resourceList.add(resource);
            }
        }
        this.envClassLoaderOrder = envClassLoaderOrder;
        this.fileToLastModified = fileToLastModified;
        this.classNameToClassInfo = classNameToClassInfo;
        this.packageNameToPackageInfo = packageNameToPackageInfo;
        this.moduleNameToModuleInfo = moduleNameToModuleInfo;
        this.nestedJarHandler = nestedJarHandler;
        this.log = log;
        if (classNameToClassInfo != null) {
            Collection<ClassInfo> allClassInfo = classNameToClassInfo.values();
            for (ClassInfo classInfo : allClassInfo) {
                classInfo.setScanResult(this);
            }
            if (scanSpec.enableInterClassDependencies) {
                for (ClassInfo ci : new ArrayList<ClassInfo>(classNameToClassInfo.values())) {
                    HashSet<ClassInfo> refdClasses = new HashSet<ClassInfo>();
                    for (String refdClassName : ci.getReferencedClassNames()) {
                        if (ci.getName().equals(refdClassName)) continue;
                        ClassInfo refdClassInfo = ClassInfo.getOrCreateClassInfo(refdClassName, 0, classNameToClassInfo);
                        refdClassInfo.setScanResult(this);
                        if (refdClassInfo.isExternalClass() && !scanSpec.enableExternalClasses) continue;
                        refdClasses.add(refdClassInfo);
                    }
                    ci.setReferencedClasses(new ClassInfoList(refdClasses, true));
                }
            }
        }
        this.classGraphClassLoader = new ClassGraphClassLoader(this);
        this.weakReference = new WeakReference<ScanResult>(this);
        nonClosedWeakReferences.add(this.weakReference);
    }

    public List<File> getClasspathFiles() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        ArrayList<File> classpathElementOrderFiles = new ArrayList<File>();
        for (ClasspathElement classpathElement : this.classpathOrder) {
            File file = classpathElement instanceof ClasspathElementModule ? ((ClasspathElementModule)classpathElement).getModuleRef().getLocationFile() : (classpathElement instanceof ClasspathElementDir ? ((ClasspathElementDir)classpathElement).getDirFile() : (classpathElement instanceof ClasspathElementZip ? ((ClasspathElementZip)classpathElement).getZipFile() : null));
            if (file == null) continue;
            classpathElementOrderFiles.add(file);
        }
        return classpathElementOrderFiles;
    }

    public String getClasspath() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        return JarUtils.pathElementsToPathStr(this.getClasspathFiles());
    }

    public List<URL> getClasspathURLs() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        ArrayList<URL> classpathElementOrderURLs = new ArrayList<URL>();
        for (ClasspathElement classpathElement : this.classpathOrder) {
            try {
                if (classpathElement instanceof ClasspathElementModule) {
                    URI location = ((ClasspathElementModule)classpathElement).getModuleRef().getLocation();
                    if (location == null) continue;
                    classpathElementOrderURLs.add(location.toURL());
                    continue;
                }
                if (classpathElement instanceof ClasspathElementDir) {
                    classpathElementOrderURLs.add(((ClasspathElementDir)classpathElement).getDirFile().toURI().toURL());
                    continue;
                }
                if (!(classpathElement instanceof ClasspathElementZip)) continue;
                classpathElementOrderURLs.add(((ClasspathElementZip)classpathElement).getZipFileURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return classpathElementOrderURLs;
    }

    public List<ModuleRef> getModules() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        ArrayList<ModuleRef> moduleRefs = new ArrayList<ModuleRef>();
        for (ClasspathElement classpathElement : this.classpathOrder) {
            if (!(classpathElement instanceof ClasspathElementModule)) continue;
            moduleRefs.add(((ClasspathElementModule)classpathElement).getModuleRef());
        }
        return moduleRefs;
    }

    public ResourceList getAllResources() {
        if (this.allWhitelistedResources == null || this.allWhitelistedResources.isEmpty()) {
            return new ResourceList(1);
        }
        return this.allWhitelistedResources;
    }

    public ResourceList getResourcesWithPath(String resourcePath) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (this.allWhitelistedResources == null || this.allWhitelistedResources.isEmpty()) {
            return new ResourceList(1);
        }
        String path = FileUtils.sanitizeEntryPath(resourcePath, true);
        ResourceList resourceList = this.pathToWhitelistedResourceList.get(path);
        return resourceList == null ? new ResourceList(1) : resourceList;
    }

    public ResourceList getResourcesWithPathIgnoringWhitelist(String resourcePath) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        String path = FileUtils.sanitizeEntryPath(resourcePath, true);
        ResourceList matchingResources = new ResourceList();
        for (ClasspathElement classpathElt : this.classpathOrder) {
            Resource matchingResource = classpathElt.getResource(path);
            if (matchingResource == null) continue;
            matchingResources.add(matchingResource);
        }
        return matchingResources;
    }

    public ResourceList getResourcesWithLeafName(String leafName) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (this.allWhitelistedResources == null || this.allWhitelistedResources.isEmpty()) {
            return new ResourceList(1);
        }
        ResourceList filteredResources = new ResourceList();
        for (Resource classpathResource : this.allWhitelistedResources) {
            int lastSlashIdx;
            String relativePath = classpathResource.getPath();
            if (!relativePath.substring((lastSlashIdx = relativePath.lastIndexOf(47)) + 1).equals(leafName)) continue;
            filteredResources.add(classpathResource);
        }
        return filteredResources;
    }

    public ResourceList getResourcesWithExtension(String extension) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (this.allWhitelistedResources == null || this.allWhitelistedResources.isEmpty()) {
            return new ResourceList(1);
        }
        String bareExtension = extension;
        while (bareExtension.startsWith(".")) {
            bareExtension = bareExtension.substring(1);
        }
        ResourceList filteredResources = new ResourceList();
        for (Resource classpathResource : this.allWhitelistedResources) {
            String relativePath = classpathResource.getPath();
            int lastSlashIdx = relativePath.lastIndexOf(47);
            int lastDotIdx = relativePath.lastIndexOf(46);
            if (lastDotIdx <= lastSlashIdx || !relativePath.substring(lastDotIdx + 1).equalsIgnoreCase(bareExtension)) continue;
            filteredResources.add(classpathResource);
        }
        return filteredResources;
    }

    public ResourceList getResourcesMatchingPattern(Pattern pattern) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (this.allWhitelistedResources == null || this.allWhitelistedResources.isEmpty()) {
            return new ResourceList(1);
        }
        ResourceList filteredResources = new ResourceList();
        for (Resource classpathResource : this.allWhitelistedResources) {
            String relativePath = classpathResource.getPath();
            if (!pattern.matcher(relativePath).matches()) continue;
            filteredResources.add(classpathResource);
        }
        return filteredResources;
    }

    public ModuleInfo getModuleInfo(String moduleName) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return this.moduleNameToModuleInfo.get(moduleName);
    }

    public ModuleInfoList getModuleInfo() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return new ModuleInfoList(this.moduleNameToModuleInfo.values());
    }

    public PackageInfo getPackageInfo(String packageName) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return this.packageNameToPackageInfo.get(packageName);
    }

    public PackageInfoList getPackageInfo() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return new PackageInfoList(this.packageNameToPackageInfo.values());
    }

    public Map<ClassInfo, ClassInfoList> getClassDependencyMap() {
        HashMap<ClassInfo, ClassInfoList> map = new HashMap<ClassInfo, ClassInfoList>();
        for (ClassInfo ci : this.getAllClasses()) {
            map.put(ci, ci.getClassDependencies());
        }
        return map;
    }

    public Map<ClassInfo, ClassInfoList> getReverseClassDependencyMap() {
        HashMap<ClassInfo, HashSet<ClassInfo>> revMapSet = new HashMap<ClassInfo, HashSet<ClassInfo>>();
        for (ClassInfo ci : this.getAllClasses()) {
            for (ClassInfo dep : ci.getClassDependencies()) {
                HashSet<ClassInfo> set = (HashSet<ClassInfo>)revMapSet.get(dep);
                if (set == null) {
                    set = new HashSet<ClassInfo>();
                    revMapSet.put(dep, set);
                }
                set.add(ci);
            }
        }
        HashMap<ClassInfo, ClassInfoList> revMapList = new HashMap<ClassInfo, ClassInfoList>();
        for (Map.Entry ent : revMapSet.entrySet()) {
            revMapList.put((ClassInfo)ent.getKey(), new ClassInfoList((Set)ent.getValue(), true));
        }
        return revMapList;
    }

    public ClassInfo getClassInfo(String className) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return this.classNameToClassInfo.get(className);
    }

    public ClassInfoList getAllClasses() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return ClassInfo.getAllClasses(this.classNameToClassInfo.values(), this.scanSpec, this);
    }

    public ClassInfoList getAllStandardClasses() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return ClassInfo.getAllStandardClasses(this.classNameToClassInfo.values(), this.scanSpec, this);
    }

    public ClassInfoList getSubclasses(String superclassName) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        if (superclassName.equals("java.lang.Object")) {
            return this.getAllStandardClasses();
        }
        ClassInfo superclass = this.classNameToClassInfo.get(superclassName);
        return superclass == null ? ClassInfoList.EMPTY_LIST : superclass.getSubclasses();
    }

    public ClassInfoList getSuperclasses(String subclassName) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        ClassInfo subclass = this.classNameToClassInfo.get(subclassName);
        return subclass == null ? ClassInfoList.EMPTY_LIST : subclass.getSuperclasses();
    }

    public ClassInfoList getClassesWithMethodAnnotation(String methodAnnotationName) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!(this.scanSpec.enableClassInfo && this.scanSpec.enableMethodInfo && this.scanSpec.enableAnnotationInfo)) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo(), #enableMethodInfo(), and #enableAnnotationInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(methodAnnotationName);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getClassesWithMethodAnnotation();
    }

    public ClassInfoList getClassesWithFieldAnnotation(String fieldAnnotationName) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!(this.scanSpec.enableClassInfo && this.scanSpec.enableFieldInfo && this.scanSpec.enableAnnotationInfo)) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo(), #enableFieldInfo(), and #enableAnnotationInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(fieldAnnotationName);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getClassesWithFieldAnnotation();
    }

    public ClassInfoList getAllInterfaces() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return ClassInfo.getAllImplementedInterfaceClasses(this.classNameToClassInfo.values(), this.scanSpec, this);
    }

    public ClassInfoList getInterfaces(String className) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getInterfaces();
    }

    public ClassInfoList getClassesImplementing(String interfaceName) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getClassesImplementing();
    }

    public ClassInfoList getAllAnnotations() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo || !this.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() and #enableAnnotationInfo() before #scan()");
        }
        return ClassInfo.getAllAnnotationClasses(this.classNameToClassInfo.values(), this.scanSpec, this);
    }

    public ClassInfoList getAllInterfacesAndAnnotations() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo || !this.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() and #enableAnnotationInfo() before #scan()");
        }
        return ClassInfo.getAllInterfacesOrAnnotationClasses(this.classNameToClassInfo.values(), this.scanSpec, this);
    }

    public ClassInfoList getClassesWithAnnotation(String annotationName) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo || !this.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() and #enableAnnotationInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(annotationName);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getClassesWithAnnotation();
    }

    public ClassInfoList getAnnotationsOnClass(String className) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo || !this.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() and #enableAnnotationInfo() before #scan()");
        }
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        return classInfo == null ? ClassInfoList.EMPTY_LIST : classInfo.getAnnotations();
    }

    public boolean classpathContentsModifiedSinceScan() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (this.fileToLastModified == null) {
            return true;
        }
        for (Map.Entry<File, Long> ent : this.fileToLastModified.entrySet()) {
            if (ent.getKey().lastModified() == ent.getValue().longValue()) continue;
            return true;
        }
        return false;
    }

    public long classpathContentsLastModifiedTime() {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        long maxLastModifiedTime = 0L;
        if (this.fileToLastModified != null) {
            long currTime = System.currentTimeMillis();
            for (long timestamp : this.fileToLastModified.values()) {
                if (timestamp <= maxLastModifiedTime || timestamp >= currTime) continue;
                maxLastModifiedTime = timestamp;
            }
        }
        return maxLastModifiedTime;
    }

    public Class<?> loadClass(String className, boolean returnNullIfClassNotFound) throws IllegalArgumentException {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (className == null || className.isEmpty()) {
            throw new IllegalArgumentException("className cannot be null or empty");
        }
        try {
            return Class.forName(className, this.scanSpec.initializeLoadedClasses, this.classGraphClassLoader);
        }
        catch (Throwable e) {
            if (returnNullIfClassNotFound) {
                return null;
            }
            throw new IllegalArgumentException("Could not load class " + className + " : " + e);
        }
    }

    public <T> Class<T> loadClass(String className, Class<T> superclassOrInterfaceType, boolean returnNullIfClassNotFound) throws IllegalArgumentException {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (className == null || className.isEmpty()) {
            throw new IllegalArgumentException("className cannot be null or empty");
        }
        if (superclassOrInterfaceType == null) {
            throw new IllegalArgumentException("superclassOrInterfaceType parameter cannot be null");
        }
        try {
            Class<?> loadedClass = Class.forName(className, this.scanSpec.initializeLoadedClasses, this.classGraphClassLoader);
            if (loadedClass != null && !superclassOrInterfaceType.isAssignableFrom(loadedClass)) {
                if (returnNullIfClassNotFound) {
                    return null;
                }
                throw new IllegalArgumentException("Loaded class " + loadedClass.getName() + " cannot be cast to " + superclassOrInterfaceType.getName());
            }
            Class<?> castClass = loadedClass;
            return castClass;
        }
        catch (Throwable e) {
            if (returnNullIfClassNotFound) {
                return null;
            }
            throw new IllegalArgumentException("Could not load class " + className + " : " + e);
        }
    }

    public static ScanResult fromJSON(String json) {
        Matcher matcher = Pattern.compile("\\{[\\n\\r ]*\"serializationFormat\"[ ]?:[ ]?\"([^\"]+)\"").matcher(json);
        if (!matcher.find()) {
            throw new IllegalArgumentException("JSON is not in correct format");
        }
        if (!CURRENT_SERIALIZATION_FORMAT.equals(matcher.group(1))) {
            throw new IllegalArgumentException("JSON was serialized in a different format from the format used by the current version of ClassGraph -- please serialize and deserialize your ScanResult using the same version of ClassGraph");
        }
        SerializationFormat deserialized = JSONDeserializer.deserializeObject(SerializationFormat.class, json);
        if (!deserialized.serializationFormat.equals(CURRENT_SERIALIZATION_FORMAT)) {
            throw new IllegalArgumentException("JSON was serialized by newer version of ClassGraph");
        }
        List<URL> urls = new ClassGraph().overrideClasspath(deserialized.classpath).getClasspathURLs();
        ClassLoader[] envClassLoaderOrder = new ClassLoaderAndModuleFinder(deserialized.scanSpec, null).getContextClassLoaders();
        ClassLoader parentClassLoader = envClassLoaderOrder == null || envClassLoaderOrder.length == 0 ? null : envClassLoaderOrder[0];
        URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[0]), parentClassLoader);
        ClassLoader[] classLoaderOrder = new ClassLoader[]{urlClassLoader};
        HashMap<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
        for (ClassInfo classInfo : deserialized.classInfo) {
            classInfo.classLoaders = classLoaderOrder;
            classNameToClassInfo.put(classInfo.getName(), classInfo);
        }
        HashMap<String, PackageInfo> packageNameToPackageInfo = new HashMap<String, PackageInfo>();
        for (PackageInfo pi : deserialized.packageInfo) {
            packageNameToPackageInfo.put(pi.getName(), pi);
        }
        HashMap<String, ModuleInfo> hashMap = new HashMap<String, ModuleInfo>();
        for (ModuleInfo mi : deserialized.moduleInfo) {
            hashMap.put(mi.getName(), mi);
        }
        return new ScanResult(deserialized.scanSpec, Collections.emptyList(), deserialized.classpath, classLoaderOrder, classNameToClassInfo, packageNameToPackageInfo, hashMap, null, null, null);
    }

    public String toJSON(int indentWidth) {
        if (this.closed.get()) {
            throw new IllegalArgumentException("Cannot use a ScanResult after it has been closed");
        }
        if (!this.scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        ArrayList<ClassInfo> allClassInfo = new ArrayList<ClassInfo>(this.classNameToClassInfo.values());
        Collections.sort(allClassInfo);
        ArrayList<PackageInfo> allPackageInfo = new ArrayList<PackageInfo>(this.packageNameToPackageInfo.values());
        Collections.sort(allPackageInfo);
        ArrayList<ModuleInfo> allModuleInfo = new ArrayList<ModuleInfo>(this.moduleNameToModuleInfo.values());
        Collections.sort(allModuleInfo);
        return JSONSerializer.serializeObject(new SerializationFormat(CURRENT_SERIALIZATION_FORMAT, this.scanSpec, allClassInfo, allPackageInfo, allModuleInfo, this.rawClasspathEltOrderStrs), indentWidth, false);
    }

    public String toJSON() {
        return this.toJSON(0);
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.classpathOrder != null) {
                this.classpathOrder.clear();
                this.classpathOrder = null;
            }
            if (this.allWhitelistedResources != null) {
                for (Resource classpathResource : this.allWhitelistedResources) {
                    classpathResource.close();
                }
                this.allWhitelistedResources.clear();
                this.allWhitelistedResources = null;
            }
            if (this.pathToWhitelistedResourceList != null) {
                this.pathToWhitelistedResourceList.clear();
                this.pathToWhitelistedResourceList = null;
            }
            this.classGraphClassLoader = null;
            if (this.classNameToClassInfo != null) {
                this.classNameToClassInfo.clear();
                this.classNameToClassInfo = null;
            }
            if (this.packageNameToPackageInfo != null) {
                this.packageNameToPackageInfo.clear();
                this.packageNameToPackageInfo = null;
            }
            if (this.moduleNameToModuleInfo != null) {
                this.moduleNameToModuleInfo.clear();
                this.moduleNameToModuleInfo = null;
            }
            if (this.fileToLastModified != null) {
                this.fileToLastModified.clear();
                this.fileToLastModified = null;
            }
            this.classGraphClassLoader = null;
            this.envClassLoaderOrder = null;
            if (this.nestedJarHandler != null) {
                this.nestedJarHandler.close(this.log);
                this.nestedJarHandler = null;
            }
            nonClosedWeakReferences.remove(this.weakReference);
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (WeakReference weakReference : new ArrayList(nonClosedWeakReferences)) {
                    ScanResult scanResult = (ScanResult)weakReference.get();
                    if (scanResult != null) {
                        scanResult.close();
                    }
                    nonClosedWeakReferences.remove(weakReference);
                }
            }
        });
    }

    private static class SerializationFormat {
        public String serializationFormat;
        public ScanSpec scanSpec;
        public List<String> classpath;
        public List<ClassInfo> classInfo;
        public List<PackageInfo> packageInfo;
        public List<ModuleInfo> moduleInfo;

        public SerializationFormat() {
        }

        public SerializationFormat(String serializationFormat, ScanSpec scanSpec, List<ClassInfo> classInfo, List<PackageInfo> packageInfo, List<ModuleInfo> moduleInfo, List<String> classpath) {
            this.serializationFormat = serializationFormat;
            this.scanSpec = scanSpec;
            this.classpath = classpath;
            this.classInfo = classInfo;
            this.packageInfo = packageInfo;
            this.moduleInfo = moduleInfo;
        }
    }
}

