/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.concurrency.WorkQueue;
import nonapi.io.github.classgraph.fastzipfilereader.FastZipEntry;
import nonapi.io.github.classgraph.fastzipfilereader.LogicalZipFile;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.URLPathEncoder;

class ClasspathElementZip
extends ClasspathElement {
    private final String rawPath;
    private LogicalZipFile logicalZipFile;
    private String packageRootPrefix = "";
    private String zipFilePath;
    private final Map<String, Resource> relativePathToResource = new HashMap<String, Resource>();
    private final NestedJarHandler nestedJarHandler;
    private static final String[] AUTOMATIC_PACKAGE_ROOT_PREFIXES = new String[]{"BOOT-INF/classes/", "WEB-INF/classes/", "classes/"};

    ClasspathElementZip(String rawPath, ClassLoader[] classLoaders, NestedJarHandler nestedJarHandler, ScanSpec scanSpec) {
        super(classLoaders, scanSpec);
        this.rawPath = rawPath;
        this.zipFilePath = rawPath;
        this.nestedJarHandler = nestedJarHandler;
        if (scanSpec.performScan) {
            this.whitelistedResources = new ArrayList();
            this.whitelistedClassfileResources = new ArrayList();
            this.fileToLastModified = new HashMap();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    void open(WorkQueue<String> workQueue, LogNode log) {
        if (!this.scanSpec.scanJars) {
            if (log != null) {
                log.log("Skipping classpath element, since jar scanning is disabled: " + this.rawPath);
            }
            this.skipClasspathElement = true;
            return;
        }
        plingIdx = this.rawPath.indexOf(33);
        outermostZipFilePathResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, plingIdx < 0 ? this.rawPath : this.rawPath.substring(0, plingIdx));
        if (!this.scanSpec.jarWhiteBlackList.isWhitelistedAndNotBlacklisted(outermostZipFilePathResolved)) {
            if (log != null) {
                log.log("Skipping jarfile that is blacklisted or not whitelisted: " + this.rawPath);
            }
            this.skipClasspathElement = true;
            return;
        }
        if (this.scanSpec.performScan) {
            try {
                logicalZipFileAndPackageRoot = this.nestedJarHandler.nestedPathToLogicalZipFileAndPackageRootMap.get(this.rawPath, log);
                this.logicalZipFile = logicalZipFileAndPackageRoot.getKey();
                this.zipFilePath = this.logicalZipFile.getPath();
                packageRoot = logicalZipFileAndPackageRoot.getValue();
                if (packageRoot.isEmpty()) ** GOTO lbl37
                this.packageRootPrefix = packageRoot + "/";
            }
            catch (IOException | IllegalArgumentException e) {
                if (log != null) {
                    log.log("Could not open jarfile " + this.rawPath + " : " + e);
                }
                this.skipClasspathElement = true;
                return;
            }
            catch (Exception e) {
                if (log != null) {
                    log.log("Exception while opening jarfile " + this.rawPath, e);
                }
                this.skipClasspathElement = true;
                return;
            }
        } else {
            this.zipFilePath = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, this.rawPath);
        }
lbl37:
        // 3 sources

        if (!this.scanSpec.enableSystemJarsAndModules && this.logicalZipFile != null && this.logicalZipFile.isJREJar) {
            if (log != null) {
                log.log("Ignoring JRE jar: " + this.rawPath);
            }
            this.skipClasspathElement = true;
            return;
        }
        if (this.logicalZipFile != null) {
            if (!this.logicalZipFile.isWhitelistedAndNotBlacklisted(this.scanSpec.jarWhiteBlackList)) {
                if (log != null) {
                    log.log("Skipping jarfile that is blacklisted or not whitelisted: " + this.rawPath);
                }
                this.skipClasspathElement = true;
                return;
            }
            if (this.logicalZipFile.additionalClassPathEntriesToScan != null) {
                pathOfContainingDir = FastPathResolver.resolve(this.logicalZipFile.physicalZipFile.getFile().getParent());
                for (String childClassPathEltPath : this.logicalZipFile.additionalClassPathEntriesToScan) {
                    childClassPathEltPathResolved = FastPathResolver.resolve(pathOfContainingDir, childClassPathEltPath);
                    if (childClassPathEltPathResolved.equals(this.rawPath) || !this.childClasspathEltPaths.add(childClassPathEltPathResolved)) continue;
                    if (workQueue != null) {
                        workQueue.addWorkUnit(childClassPathEltPathResolved);
                        continue;
                    }
                    if (log == null) continue;
                    log.log("Ignoring Class-Path entry in rt.jar: " + childClassPathEltPathResolved);
                }
            }
        }
    }

    private Resource newResource(final FastZipEntry zipEntry, final String pathRelativeToPackageRoot) {
        return new Resource(){
            {
                this.length = zipEntry.uncompressedSize;
            }

            @Override
            public String getPath() {
                return pathRelativeToPackageRoot;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                return zipEntry.entryName;
            }

            @Override
            public URL getURL() {
                try {
                    return URLPathEncoder.urlPathToURL(ClasspathElementZip.this.zipFilePath + "!/" + zipEntry.entryName);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Could not form URL for resource: " + e);
                }
            }

            @Override
            public URL getClasspathElementURL() {
                return ClasspathElementZip.this.getZipFileURL();
            }

            @Override
            public File getClasspathElementFile() {
                return ClasspathElementZip.this.getZipFile();
            }

            @Override
            public ModuleRef getModuleRef() {
                return null;
            }

            @Override
            public synchronized InputStream open() throws IOException {
                if (ClasspathElementZip.this.skipClasspathElement) {
                    throw new IOException("Jarfile could not be opened");
                }
                this.markAsOpen();
                try {
                    this.inputStream = new Resource.InputStreamResourceCloser(this, zipEntry.open());
                    this.length = zipEntry.uncompressedSize;
                    return this.inputStream;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            synchronized InputStreamOrByteBufferAdapter openOrRead() throws IOException {
                return new InputStreamOrByteBufferAdapter(this.open());
            }

            @Override
            public synchronized ByteBuffer read() throws IOException {
                if (zipEntry.canGetAsSlice()) {
                    this.markAsOpen();
                    this.length = zipEntry.compressedSize;
                    return zipEntry.getAsSlice();
                }
                this.open();
                return this.inputStreamToByteBuffer();
            }

            @Override
            public synchronized byte[] load() throws IOException {
                try {
                    this.open();
                    byte[] byteArray = this.inputStreamToByteArray();
                    this.length = byteArray.length;
                    byte[] byArray = byteArray;
                    return byArray;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public synchronized void close() {
                if (this.inputStream != null) {
                    InputStream inputStreamWrapper = this.inputStream;
                    this.inputStream = null;
                    try {
                        inputStreamWrapper.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.byteBuffer != null) {
                    this.byteBuffer = null;
                }
                this.markAsClosed();
            }
        };
    }

    @Override
    Resource getResource(String relativePath) {
        return this.relativePathToResource.get(relativePath);
    }

    @Override
    void scanPaths(LogNode log) {
        if (this.logicalZipFile == null) {
            this.skipClasspathElement = true;
        }
        if (this.skipClasspathElement) {
            return;
        }
        if (this.scanned.getAndSet(true)) {
            throw new IllegalArgumentException("Already scanned classpath element " + this.getZipFilePath());
        }
        LogNode subLog = log == null ? null : log.log(this.getZipFilePath(), "Scanning jarfile classpath element " + this.getZipFilePath());
        HashSet<String> loggedNestedClasspathRootPrefixes = null;
        String prevParentRelativePath = null;
        ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
        for (FastZipEntry zipEntry : this.logicalZipFile.getEntries()) {
            int lastSlashIdx;
            String relativePath = zipEntry.entryNameUnversioned;
            if (this.nestedClasspathRootPrefixes != null) {
                boolean reachedNestedRoot = false;
                for (String nestedClasspathRoot : this.nestedClasspathRootPrefixes) {
                    if (!relativePath.startsWith(nestedClasspathRoot)) continue;
                    if (subLog != null) {
                        if (loggedNestedClasspathRootPrefixes == null) {
                            loggedNestedClasspathRootPrefixes = new HashSet<String>();
                        }
                        if (loggedNestedClasspathRootPrefixes.add(nestedClasspathRoot)) {
                            subLog.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + nestedClasspathRoot);
                        }
                    }
                    reachedNestedRoot = true;
                    break;
                }
                if (reachedNestedRoot) continue;
            }
            if (!this.packageRootPrefix.isEmpty() && !relativePath.startsWith(this.packageRootPrefix)) continue;
            if (!this.packageRootPrefix.isEmpty()) {
                relativePath = relativePath.substring(this.packageRootPrefix.length());
            } else {
                for (int i = 0; i < AUTOMATIC_PACKAGE_ROOT_PREFIXES.length; ++i) {
                    if (!relativePath.startsWith(AUTOMATIC_PACKAGE_ROOT_PREFIXES[i])) continue;
                    relativePath = relativePath.substring(AUTOMATIC_PACKAGE_ROOT_PREFIXES[i].length());
                }
            }
            if (relativePath.startsWith("test-classes/")) {
                if (subLog == null) continue;
                subLog.log("Skipping test-classes jar entry: " + relativePath);
                continue;
            }
            if (!this.scanSpec.classpathElementResourcePathWhiteBlackList.whitelistAndBlacklistAreEmpty()) {
                if (this.scanSpec.classpathElementResourcePathWhiteBlackList.isBlacklisted(relativePath)) {
                    if (subLog != null) {
                        subLog.log("Reached blacklisted classpath element resource path, stopping scanning: " + relativePath);
                    }
                    this.skipClasspathElement = true;
                    return;
                }
                if (this.scanSpec.classpathElementResourcePathWhiteBlackList.isSpecificallyWhitelisted(relativePath)) {
                    if (subLog != null) {
                        subLog.log("Reached specifically whitelisted classpath element resource path: " + relativePath);
                    }
                    this.containsSpecificallyWhitelistedClasspathElementResourcePath = true;
                }
            }
            String parentRelativePath = (lastSlashIdx = relativePath.lastIndexOf("/")) < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
            boolean parentRelativePathChanged = !parentRelativePath.equals(prevParentRelativePath);
            ScanSpec.ScanSpecPathMatch parentMatchStatus = parentRelativePathChanged ? this.scanSpec.dirWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
            prevParentRelativePath = parentRelativePath;
            prevParentMatchStatus = parentMatchStatus;
            if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX) {
                if (subLog == null) continue;
                subLog.log("Skipping blacklisted path: " + relativePath);
                continue;
            }
            Resource resource = this.newResource(zipEntry, relativePath);
            if (!this.relativePathToResource.containsKey(relativePath)) {
                this.relativePathToResource.put(relativePath, resource);
            }
            if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX && parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH && (parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.classfileIsSpecificallyWhitelisted(relativePath))) continue;
            this.addWhitelistedResource(resource, parentMatchStatus, subLog);
        }
        this.fileToLastModified.put(this.getZipFile(), this.getZipFile().lastModified());
        if (subLog != null) {
            subLog.addElapsedTime();
        }
    }

    @Override
    String getPackageRoot() {
        return this.packageRootPrefix;
    }

    public File getZipFile() {
        if (this.logicalZipFile != null) {
            return this.logicalZipFile.physicalZipFile.getFile();
        }
        int plingIdx = this.rawPath.indexOf(33);
        String outermostZipFilePathResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, plingIdx < 0 ? this.rawPath : this.rawPath.substring(0, plingIdx));
        File outermostZipFile = new File(outermostZipFilePathResolved);
        return outermostZipFile;
    }

    public String getZipFilePath() {
        return this.packageRootPrefix.isEmpty() ? this.zipFilePath : this.zipFilePath + "!/" + this.packageRootPrefix.substring(0, this.packageRootPrefix.length() - 1);
    }

    public URL getZipFileURL() {
        try {
            return URLPathEncoder.urlPathToURL(this.getZipFilePath());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not form URL for classpath element: " + e);
        }
    }

    public String toString() {
        return this.getZipFilePath();
    }
}

