/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.Resource;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.concurrency.WorkQueue;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;

abstract class ClasspathElement {
    List<String> nestedClasspathRootPrefixes;
    boolean skipClasspathElement;
    boolean containsSpecificallyWhitelistedClasspathElementResourcePath;
    Set<String> childClasspathEltPaths = Collections.newSetFromMap(new ConcurrentHashMap());
    protected List<Resource> whitelistedResources;
    protected List<Resource> whitelistedClassfileResources;
    protected Map<String, Resource> classNameToNonBlacklistedResource;
    protected Map<File, Long> fileToLastModified;
    protected final AtomicBoolean scanned = new AtomicBoolean(false);
    protected ClassLoader[] classLoaders;
    final ScanSpec scanSpec;

    ClasspathElement(ClassLoader[] classLoaders, ScanSpec scanSpec) {
        this.classLoaders = classLoaders;
        this.scanSpec = scanSpec;
    }

    String getPackageRoot() {
        return "";
    }

    ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    int getNumClassfileMatches() {
        return this.whitelistedClassfileResources == null ? 0 : this.whitelistedClassfileResources.size();
    }

    static List<Resource> maskClassfiles(ScanSpec scanSpec, int classpathIdx, List<Resource> classfileResources, HashSet<String> classpathRelativePathsFound, LogNode log) {
        if (!scanSpec.performScan) {
            throw new IllegalArgumentException("performScan is false");
        }
        BitSet masked = new BitSet(classfileResources.size());
        boolean foundMasked = false;
        for (int i = 0; i < classfileResources.size(); ++i) {
            Resource res = classfileResources.get(i);
            String pathRelativeToPackageRoot = res.getPath();
            if (pathRelativeToPackageRoot.equals("module-info.class") || pathRelativeToPackageRoot.endsWith("/module-info.class") || pathRelativeToPackageRoot.equals("package-info.class") || pathRelativeToPackageRoot.endsWith("/package-info.class") || classpathRelativePathsFound.add(pathRelativeToPackageRoot)) continue;
            masked.set(i);
            foundMasked = true;
            if (log == null) continue;
            log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) class " + JarUtils.classfilePathToClassName(pathRelativeToPackageRoot) + " : resource =  " + res);
        }
        if (!foundMasked) {
            return classfileResources;
        }
        ArrayList<Resource> maskedClassfileResources = new ArrayList<Resource>();
        for (int i = 0; i < classfileResources.size(); ++i) {
            if (masked.get(i)) continue;
            maskedClassfileResources.add(classfileResources.get(i));
        }
        return maskedClassfileResources;
    }

    void maskClassfiles(int classpathIdx, HashSet<String> whitelistedClasspathRelativePathsFound, HashSet<String> nonBlacklistedClasspathRelativePathsFound, LogNode maskLog) {
        this.whitelistedClassfileResources = ClasspathElement.maskClassfiles(this.scanSpec, classpathIdx, this.whitelistedClassfileResources, whitelistedClasspathRelativePathsFound, maskLog);
    }

    protected void addWhitelistedResource(Resource resource, ScanSpec.ScanSpecPathMatch parentMatchStatus, LogNode log) {
        String path = resource.getPath();
        boolean isClassFile = FileUtils.isClassfile(path);
        if (isClassFile) {
            if (this.scanSpec.enableClassInfo && !this.scanSpec.classfilePathWhiteBlackList.isBlacklisted(path)) {
                this.whitelistedClassfileResources.add(resource);
                if (log != null) {
                    log.log(path, "Found whitelisted classfile: " + path + (path.equals(resource.getPathRelativeToClasspathElement()) ? "" : " ; full path: " + resource.getPathRelativeToClasspathElement()));
                }
            }
        } else if (log != null) {
            log.log(path, "Found whitelisted resource: " + path + (path.equals(resource.getPathRelativeToClasspathElement()) ? "" : " ; full path: " + resource.getPathRelativeToClasspathElement()));
        }
        this.whitelistedResources.add(resource);
    }

    abstract void open(WorkQueue<String> var1, LogNode var2);

    abstract void scanPaths(LogNode var1);

    abstract Resource getResource(String var1);
}

