/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.GraphvizDotfileGenerator;
import io.github.classgraph.InfoList;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.ScanSpec;

public class ClassInfoList
extends InfoList.MappableInfoList<ClassInfo> {
    private final Set<ClassInfo> directlyRelatedClasses;
    private final boolean sortByName;
    static final ClassInfoList EMPTY_LIST = new ClassInfoList(){

        @Override
        public boolean add(ClassInfo e) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public void add(int index, ClassInfo element) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean remove(Object o) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public ClassInfo remove(int index) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean addAll(Collection<? extends ClassInfo> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean addAll(int index, Collection<? extends ClassInfo> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public void clear() {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public ClassInfo set(int index, ClassInfo element) {
            throw new IllegalArgumentException("List is immutable");
        }
    };

    ClassInfoList(Set<ClassInfo> reachableClasses, Set<ClassInfo> directlyRelatedClasses, boolean sortByName) {
        super(reachableClasses);
        this.sortByName = sortByName;
        if (sortByName) {
            Collections.sort(this);
        }
        this.directlyRelatedClasses = directlyRelatedClasses == null ? reachableClasses : directlyRelatedClasses;
    }

    ClassInfoList(ClassInfo.ReachableAndDirectlyRelatedClasses reachableAndDirectlyRelatedClasses, boolean sortByName) {
        this(reachableAndDirectlyRelatedClasses.reachableClasses, reachableAndDirectlyRelatedClasses.directlyRelatedClasses, sortByName);
    }

    ClassInfoList(Set<ClassInfo> reachableClasses, boolean sortByName) {
        this(reachableClasses, null, sortByName);
    }

    private ClassInfoList() {
        super(1);
        this.sortByName = false;
        this.directlyRelatedClasses = Collections.emptySet();
    }

    public <T> List<Class<T>> loadClasses(Class<T> superclassOrInterfaceType, boolean ignoreExceptions) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList classRefs = new ArrayList();
        for (ClassInfo classInfo : this) {
            Class<T> classRef = classInfo.loadClass(superclassOrInterfaceType, ignoreExceptions);
            if (classRef == null) continue;
            classRefs.add(classRef);
        }
        return classRefs.isEmpty() ? Collections.emptyList() : classRefs;
    }

    public <T> List<Class<T>> loadClasses(Class<T> superclassOrInterfaceType) {
        return this.loadClasses(superclassOrInterfaceType, false);
    }

    public List<Class<?>> loadClasses(boolean ignoreExceptions) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList classRefs = new ArrayList();
        for (ClassInfo classInfo : this) {
            Class<?> classRef = classInfo.loadClass(ignoreExceptions);
            if (classRef == null) continue;
            classRefs.add(classRef);
        }
        return classRefs.isEmpty() ? Collections.emptyList() : classRefs;
    }

    public List<Class<?>> loadClasses() {
        return this.loadClasses(false);
    }

    public ClassInfoList directOnly() {
        return new ClassInfoList(this.directlyRelatedClasses, this.directlyRelatedClasses, this.sortByName);
    }

    public ClassInfoList union(ClassInfoList ... others) {
        LinkedHashSet<ClassInfo> reachableClassesUnion = new LinkedHashSet<ClassInfo>(this);
        LinkedHashSet<ClassInfo> directlyRelatedClassesUnion = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses);
        for (ClassInfoList other : others) {
            reachableClassesUnion.addAll(other);
            directlyRelatedClassesUnion.addAll(other.directlyRelatedClasses);
        }
        return new ClassInfoList(reachableClassesUnion, directlyRelatedClassesUnion, this.sortByName);
    }

    public ClassInfoList intersect(ClassInfoList ... others) {
        ArrayDeque<ClassInfoList> intersectionOrder = new ArrayDeque<ClassInfoList>();
        intersectionOrder.add(this);
        boolean foundFirst = false;
        for (ClassInfoList other : others) {
            if (other.sortByName) {
                intersectionOrder.add(other);
                continue;
            }
            if (!foundFirst) {
                foundFirst = true;
                intersectionOrder.push(other);
                continue;
            }
            intersectionOrder.add(other);
        }
        ClassInfoList first = (ClassInfoList)intersectionOrder.remove();
        LinkedHashSet<ClassInfo> reachableClassesIntersection = new LinkedHashSet<ClassInfo>(first);
        while (!intersectionOrder.isEmpty()) {
            reachableClassesIntersection.retainAll((Collection)intersectionOrder.remove());
        }
        LinkedHashSet<ClassInfo> directlyRelatedClassesIntersection = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses);
        for (ClassInfoList other : others) {
            directlyRelatedClassesIntersection.retainAll(other.directlyRelatedClasses);
        }
        return new ClassInfoList(reachableClassesIntersection, directlyRelatedClassesIntersection, first.sortByName);
    }

    public ClassInfoList exclude(ClassInfoList other) {
        LinkedHashSet<ClassInfo> reachableClassesDifference = new LinkedHashSet<ClassInfo>(this);
        LinkedHashSet<ClassInfo> directlyRelatedClassesDifference = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses);
        reachableClassesDifference.removeAll(other);
        directlyRelatedClassesDifference.removeAll(other.directlyRelatedClasses);
        return new ClassInfoList(reachableClassesDifference, directlyRelatedClassesDifference, this.sortByName);
    }

    public ClassInfoList filter(ClassInfoFilter filter) {
        LinkedHashSet<ClassInfo> reachableClassesFiltered = new LinkedHashSet<ClassInfo>(this.size());
        LinkedHashSet<ClassInfo> directlyRelatedClassesFiltered = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses.size());
        for (ClassInfo ci : this) {
            if (!filter.accept(ci)) continue;
            reachableClassesFiltered.add(ci);
            if (!this.directlyRelatedClasses.contains(ci)) continue;
            directlyRelatedClassesFiltered.add(ci);
        }
        return new ClassInfoList(reachableClassesFiltered, directlyRelatedClassesFiltered, this.sortByName);
    }

    public ClassInfoList getStandardClasses() {
        LinkedHashSet<ClassInfo> reachableClassesFiltered = new LinkedHashSet<ClassInfo>(this.size());
        LinkedHashSet<ClassInfo> directlyRelatedClassesFiltered = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses.size());
        for (ClassInfo ci : this) {
            if (!ci.isStandardClass()) continue;
            reachableClassesFiltered.add(ci);
            if (!this.directlyRelatedClasses.contains(ci)) continue;
            directlyRelatedClassesFiltered.add(ci);
        }
        return new ClassInfoList(reachableClassesFiltered, directlyRelatedClassesFiltered, this.sortByName);
    }

    public ClassInfoList getInterfaces() {
        LinkedHashSet<ClassInfo> reachableClassesFiltered = new LinkedHashSet<ClassInfo>(this.size());
        LinkedHashSet<ClassInfo> directlyRelatedClassesFiltered = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses.size());
        for (ClassInfo ci : this) {
            if (!ci.isInterface()) continue;
            reachableClassesFiltered.add(ci);
            if (!this.directlyRelatedClasses.contains(ci)) continue;
            directlyRelatedClassesFiltered.add(ci);
        }
        return new ClassInfoList(reachableClassesFiltered, directlyRelatedClassesFiltered, this.sortByName);
    }

    public ClassInfoList getInterfacesAndAnnotations() {
        LinkedHashSet<ClassInfo> reachableClassesFiltered = new LinkedHashSet<ClassInfo>(this.size());
        LinkedHashSet<ClassInfo> directlyRelatedClassesFiltered = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses.size());
        for (ClassInfo ci : this) {
            if (!ci.isInterfaceOrAnnotation()) continue;
            reachableClassesFiltered.add(ci);
            if (!this.directlyRelatedClasses.contains(ci)) continue;
            directlyRelatedClassesFiltered.add(ci);
        }
        return new ClassInfoList(reachableClassesFiltered, directlyRelatedClassesFiltered, this.sortByName);
    }

    public ClassInfoList getImplementedInterfaces() {
        LinkedHashSet<ClassInfo> reachableClassesFiltered = new LinkedHashSet<ClassInfo>(this.size());
        LinkedHashSet<ClassInfo> directlyRelatedClassesFiltered = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses.size());
        for (ClassInfo ci : this) {
            if (!ci.isImplementedInterface()) continue;
            reachableClassesFiltered.add(ci);
            if (!this.directlyRelatedClasses.contains(ci)) continue;
            directlyRelatedClassesFiltered.add(ci);
        }
        return new ClassInfoList(reachableClassesFiltered, directlyRelatedClassesFiltered, this.sortByName);
    }

    public ClassInfoList getAnnotations() {
        LinkedHashSet<ClassInfo> reachableClassesFiltered = new LinkedHashSet<ClassInfo>(this.size());
        LinkedHashSet<ClassInfo> directlyRelatedClassesFiltered = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses.size());
        for (ClassInfo ci : this) {
            if (!ci.isAnnotation()) continue;
            reachableClassesFiltered.add(ci);
            if (!this.directlyRelatedClasses.contains(ci)) continue;
            directlyRelatedClassesFiltered.add(ci);
        }
        return new ClassInfoList(reachableClassesFiltered, directlyRelatedClassesFiltered, this.sortByName);
    }

    public ClassInfoList getEnums() {
        LinkedHashSet<ClassInfo> reachableClassesFiltered = new LinkedHashSet<ClassInfo>(this.size());
        LinkedHashSet<ClassInfo> directlyRelatedClassesFiltered = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses.size());
        for (ClassInfo ci : this) {
            if (!ci.isEnum()) continue;
            reachableClassesFiltered.add(ci);
            if (!this.directlyRelatedClasses.contains(ci)) continue;
            directlyRelatedClassesFiltered.add(ci);
        }
        return new ClassInfoList(reachableClassesFiltered, directlyRelatedClassesFiltered, this.sortByName);
    }

    public ClassInfoList getAssignableTo(ClassInfo assignableToClass) {
        if (assignableToClass == null) {
            throw new IllegalArgumentException("assignableToClass parameter cannot be null");
        }
        HashSet<ClassInfo> allAssignableFromClasses = new HashSet<ClassInfo>(assignableToClass.getSubclasses());
        allAssignableFromClasses.addAll(assignableToClass.getClassesImplementing());
        allAssignableFromClasses.add(assignableToClass);
        LinkedHashSet<ClassInfo> assignableFromClassesFiltered = new LinkedHashSet<ClassInfo>(this.size());
        LinkedHashSet<ClassInfo> directlyRelatedAssignableFromClassesFiltered = new LinkedHashSet<ClassInfo>(this.directlyRelatedClasses.size());
        for (ClassInfo ci : this) {
            if (!allAssignableFromClasses.contains(ci)) continue;
            assignableFromClassesFiltered.add(ci);
            if (!this.directlyRelatedClasses.contains(ci)) continue;
            directlyRelatedAssignableFromClassesFiltered.add(ci);
        }
        return new ClassInfoList(assignableFromClassesFiltered, directlyRelatedAssignableFromClassesFiltered, this.sortByName);
    }

    public String generateGraphVizDotFileFromInterClassDependencies(float sizeX, float sizeY, boolean includeExternalClasses) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("List is empty");
        }
        ScanSpec scanSpec = ((ClassInfo)this.get((int)0)).scanResult.scanSpec;
        if (!scanSpec.enableInterClassDependencies) {
            throw new IllegalArgumentException("Please call ClassGraph#enableInterClassDependencies() before #scan()");
        }
        return GraphvizDotfileGenerator.generateGraphVizDotFileFromInterClassDependencies(this, sizeX, sizeY, includeExternalClasses);
    }

    public String generateGraphVizDotFileFromClassDependencies() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("List is empty");
        }
        ScanSpec scanSpec = ((ClassInfo)this.get((int)0)).scanResult.scanSpec;
        if (!scanSpec.enableInterClassDependencies) {
            throw new IllegalArgumentException("Please call ClassGraph#enableInterClassDependencies() before #scan()");
        }
        return GraphvizDotfileGenerator.generateGraphVizDotFileFromInterClassDependencies(this, 10.5f, 8.0f, scanSpec.enableExternalClasses);
    }

    public String generateGraphVizDotFile(float sizeX, float sizeY, boolean showFields, boolean showFieldTypeDependencyEdges, boolean showMethods, boolean showMethodTypeDependencyEdges, boolean showAnnotations) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("List is empty");
        }
        ScanSpec scanSpec = ((ClassInfo)this.get((int)0)).scanResult.scanSpec;
        if (!scanSpec.enableClassInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableClassInfo() before #scan()");
        }
        return GraphvizDotfileGenerator.generateGraphVizDotFile(this, sizeX, sizeY, showFields, showFieldTypeDependencyEdges, showMethods, showMethodTypeDependencyEdges, showAnnotations, scanSpec);
    }

    public String generateGraphVizDotFile(float sizeX, float sizeY) {
        return this.generateGraphVizDotFile(sizeX, sizeY, true, true, true, true, true);
    }

    public String generateGraphVizDotFile() {
        return this.generateGraphVizDotFile(10.5f, 8.0f, true, true, true, true, true);
    }

    public void generateGraphVizDotFile(File file) throws IOException {
        try (PrintWriter writer = new PrintWriter(file);){
            writer.print(this.generateGraphVizDotFile());
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.get(i));
        }
        buf.append(']');
        return buf.toString();
    }

    @FunctionalInterface
    public static interface ClassInfoFilter {
        public boolean accept(ClassInfo var1);
    }
}

