/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.service.path;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.ServicePathIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.service.path.ServicePath;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServicePathBuilder
implements Builder<ServicePath> {
    private Short _serviceIndex;
    private ServicePathIdType _servicePathId;
    Map<Class<? extends Augmentation<ServicePath>>, Augmentation<ServicePath>> augmentation = Collections.emptyMap();

    public ServicePathBuilder() {
    }

    public ServicePathBuilder(ServicePath base) {
        Map aug;
        this._serviceIndex = base.getServiceIndex();
        this._servicePathId = base.getServicePathId();
        if (base instanceof ServicePathImpl) {
            ServicePathImpl impl = (ServicePathImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServicePath>>, Augmentation<ServicePath>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServicePath>>, Augmentation<ServicePath>>(aug);
        }
    }

    public Short getServiceIndex() {
        return this._serviceIndex;
    }

    public ServicePathIdType getServicePathId() {
        return this._servicePathId;
    }

    public <E$$ extends Augmentation<ServicePath>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkServiceIndexRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (int)value);
    }

    public ServicePathBuilder setServiceIndex(Short value) {
        if (value != null) {
            ServicePathBuilder.checkServiceIndexRange(value);
        }
        this._serviceIndex = value;
        return this;
    }

    public ServicePathBuilder setServicePathId(ServicePathIdType value) {
        this._servicePathId = value;
        return this;
    }

    public ServicePathBuilder addAugmentation(Class<? extends Augmentation<ServicePath>> augmentationType, Augmentation<ServicePath> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServicePath>>, Augmentation<ServicePath>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServicePathBuilder removeAugmentation(Class<? extends Augmentation<ServicePath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServicePath build() {
        return new ServicePathImpl(this);
    }

    private static final class ServicePathImpl
    implements ServicePath {
        private final Short _serviceIndex;
        private final ServicePathIdType _servicePathId;
        private Map<Class<? extends Augmentation<ServicePath>>, Augmentation<ServicePath>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ServicePathImpl(ServicePathBuilder base) {
            this._serviceIndex = base.getServiceIndex();
            this._servicePathId = base.getServicePathId();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ServicePath> getImplementedInterface() {
            return ServicePath.class;
        }

        @Override
        public Short getServiceIndex() {
            return this._serviceIndex;
        }

        @Override
        public ServicePathIdType getServicePathId() {
            return this._servicePathId;
        }

        public <E$$ extends Augmentation<ServicePath>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._serviceIndex);
            result = 31 * result + Objects.hashCode(this._servicePathId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServicePath.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServicePath other = (ServicePath)obj;
            if (!Objects.equals(this._serviceIndex, other.getServiceIndex())) {
                return false;
            }
            if (!Objects.equals(this._servicePathId, other.getServicePathId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServicePathImpl otherImpl = (ServicePathImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServicePath>>, Augmentation<ServicePath>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ServicePath");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_serviceIndex", (Object)this._serviceIndex);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_servicePathId", (Object)this._servicePathId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

