/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.instance.id;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.InstanceIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.SimpleAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.instance.id.InstanceId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InstanceIdBuilder
implements Builder<InstanceId> {
    private SimpleAddress _address;
    private InstanceIdType _iid;
    private Short _maskLength;
    Map<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>> augmentation = Collections.emptyMap();

    public InstanceIdBuilder() {
    }

    public InstanceIdBuilder(InstanceId base) {
        Map aug;
        this._address = base.getAddress();
        this._iid = base.getIid();
        this._maskLength = base.getMaskLength();
        if (base instanceof InstanceIdImpl) {
            InstanceIdImpl impl = (InstanceIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>>(aug);
        }
    }

    public SimpleAddress getAddress() {
        return this._address;
    }

    public InstanceIdType getIid() {
        return this._iid;
    }

    public Short getMaskLength() {
        return this._maskLength;
    }

    public <E$$ extends Augmentation<InstanceId>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public InstanceIdBuilder setAddress(SimpleAddress value) {
        this._address = value;
        return this;
    }

    public InstanceIdBuilder setIid(InstanceIdType value) {
        this._iid = value;
        return this;
    }

    private static void checkMaskLengthRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (int)value);
    }

    public InstanceIdBuilder setMaskLength(Short value) {
        if (value != null) {
            InstanceIdBuilder.checkMaskLengthRange(value);
        }
        this._maskLength = value;
        return this;
    }

    public InstanceIdBuilder addAugmentation(Class<? extends Augmentation<InstanceId>> augmentationType, Augmentation<InstanceId> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InstanceIdBuilder removeAugmentation(Class<? extends Augmentation<InstanceId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InstanceId build() {
        return new InstanceIdImpl(this);
    }

    private static final class InstanceIdImpl
    implements InstanceId {
        private final SimpleAddress _address;
        private final InstanceIdType _iid;
        private final Short _maskLength;
        private Map<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        InstanceIdImpl(InstanceIdBuilder base) {
            this._address = base.getAddress();
            this._iid = base.getIid();
            this._maskLength = base.getMaskLength();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<InstanceId> getImplementedInterface() {
            return InstanceId.class;
        }

        @Override
        public SimpleAddress getAddress() {
            return this._address;
        }

        @Override
        public InstanceIdType getIid() {
            return this._iid;
        }

        @Override
        public Short getMaskLength() {
            return this._maskLength;
        }

        public <E$$ extends Augmentation<InstanceId>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode(this._iid);
            result = 31 * result + Objects.hashCode(this._maskLength);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InstanceId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InstanceId other = (InstanceId)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this._iid, other.getIid())) {
                return false;
            }
            if (!Objects.equals(this._maskLength, other.getMaskLength())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InstanceIdImpl otherImpl = (InstanceIdImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InstanceId>>, Augmentation<InstanceId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"InstanceId");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_address", (Object)this._address);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_iid", (Object)this._iid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maskLength", (Object)this._maskLength);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

