/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.geo.coordinates;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.SimpleAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.geo.coordinates.GeoCoordinates;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GeoCoordinatesBuilder
implements Builder<GeoCoordinates> {
    private SimpleAddress _address;
    private Integer _altitude;
    private GeoCoordinates.Latitude _latitude;
    private Short _latitudeDegrees;
    private Short _latitudeMinutes;
    private Short _latitudeSeconds;
    private GeoCoordinates.Longitude _longitude;
    private Integer _longitudeDegrees;
    private Short _longitudeMinutes;
    private Short _longitudeSeconds;
    Map<Class<? extends Augmentation<GeoCoordinates>>, Augmentation<GeoCoordinates>> augmentation = Collections.emptyMap();

    public GeoCoordinatesBuilder() {
    }

    public GeoCoordinatesBuilder(GeoCoordinates base) {
        Map aug;
        this._address = base.getAddress();
        this._altitude = base.getAltitude();
        this._latitude = base.getLatitude();
        this._latitudeDegrees = base.getLatitudeDegrees();
        this._latitudeMinutes = base.getLatitudeMinutes();
        this._latitudeSeconds = base.getLatitudeSeconds();
        this._longitude = base.getLongitude();
        this._longitudeDegrees = base.getLongitudeDegrees();
        this._longitudeMinutes = base.getLongitudeMinutes();
        this._longitudeSeconds = base.getLongitudeSeconds();
        if (base instanceof GeoCoordinatesImpl) {
            GeoCoordinatesImpl impl = (GeoCoordinatesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GeoCoordinates>>, Augmentation<GeoCoordinates>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GeoCoordinates>>, Augmentation<GeoCoordinates>>(aug);
        }
    }

    public SimpleAddress getAddress() {
        return this._address;
    }

    public Integer getAltitude() {
        return this._altitude;
    }

    public GeoCoordinates.Latitude getLatitude() {
        return this._latitude;
    }

    public Short getLatitudeDegrees() {
        return this._latitudeDegrees;
    }

    public Short getLatitudeMinutes() {
        return this._latitudeMinutes;
    }

    public Short getLatitudeSeconds() {
        return this._latitudeSeconds;
    }

    public GeoCoordinates.Longitude getLongitude() {
        return this._longitude;
    }

    public Integer getLongitudeDegrees() {
        return this._longitudeDegrees;
    }

    public Short getLongitudeMinutes() {
        return this._longitudeMinutes;
    }

    public Short getLongitudeSeconds() {
        return this._longitudeSeconds;
    }

    public <E$$ extends Augmentation<GeoCoordinates>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public GeoCoordinatesBuilder setAddress(SimpleAddress value) {
        this._address = value;
        return this;
    }

    public GeoCoordinatesBuilder setAltitude(Integer value) {
        this._altitude = value;
        return this;
    }

    public GeoCoordinatesBuilder setLatitude(GeoCoordinates.Latitude value) {
        this._latitude = value;
        return this;
    }

    private static void checkLatitudeDegreesRange(short value) {
        if (value >= 0 && value <= 90) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..90]]", (int)value);
    }

    public GeoCoordinatesBuilder setLatitudeDegrees(Short value) {
        if (value != null) {
            GeoCoordinatesBuilder.checkLatitudeDegreesRange(value);
        }
        this._latitudeDegrees = value;
        return this;
    }

    private static void checkLatitudeMinutesRange(short value) {
        if (value >= 0 && value <= 59) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..59]]", (int)value);
    }

    public GeoCoordinatesBuilder setLatitudeMinutes(Short value) {
        if (value != null) {
            GeoCoordinatesBuilder.checkLatitudeMinutesRange(value);
        }
        this._latitudeMinutes = value;
        return this;
    }

    private static void checkLatitudeSecondsRange(short value) {
        if (value >= 0 && value <= 59) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..59]]", (int)value);
    }

    public GeoCoordinatesBuilder setLatitudeSeconds(Short value) {
        if (value != null) {
            GeoCoordinatesBuilder.checkLatitudeSecondsRange(value);
        }
        this._latitudeSeconds = value;
        return this;
    }

    public GeoCoordinatesBuilder setLongitude(GeoCoordinates.Longitude value) {
        this._longitude = value;
        return this;
    }

    private static void checkLongitudeDegreesRange(int value) {
        if (value >= 0 && value <= 180) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..180]]", (int)value);
    }

    public GeoCoordinatesBuilder setLongitudeDegrees(Integer value) {
        if (value != null) {
            GeoCoordinatesBuilder.checkLongitudeDegreesRange(value);
        }
        this._longitudeDegrees = value;
        return this;
    }

    private static void checkLongitudeMinutesRange(short value) {
        if (value >= 0 && value <= 59) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..59]]", (int)value);
    }

    public GeoCoordinatesBuilder setLongitudeMinutes(Short value) {
        if (value != null) {
            GeoCoordinatesBuilder.checkLongitudeMinutesRange(value);
        }
        this._longitudeMinutes = value;
        return this;
    }

    private static void checkLongitudeSecondsRange(short value) {
        if (value >= 0 && value <= 59) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..59]]", (int)value);
    }

    public GeoCoordinatesBuilder setLongitudeSeconds(Short value) {
        if (value != null) {
            GeoCoordinatesBuilder.checkLongitudeSecondsRange(value);
        }
        this._longitudeSeconds = value;
        return this;
    }

    public GeoCoordinatesBuilder addAugmentation(Class<? extends Augmentation<GeoCoordinates>> augmentationType, Augmentation<GeoCoordinates> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GeoCoordinates>>, Augmentation<GeoCoordinates>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public GeoCoordinatesBuilder removeAugmentation(Class<? extends Augmentation<GeoCoordinates>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GeoCoordinates build() {
        return new GeoCoordinatesImpl(this);
    }

    private static final class GeoCoordinatesImpl
    implements GeoCoordinates {
        private final SimpleAddress _address;
        private final Integer _altitude;
        private final GeoCoordinates.Latitude _latitude;
        private final Short _latitudeDegrees;
        private final Short _latitudeMinutes;
        private final Short _latitudeSeconds;
        private final GeoCoordinates.Longitude _longitude;
        private final Integer _longitudeDegrees;
        private final Short _longitudeMinutes;
        private final Short _longitudeSeconds;
        private Map<Class<? extends Augmentation<GeoCoordinates>>, Augmentation<GeoCoordinates>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        GeoCoordinatesImpl(GeoCoordinatesBuilder base) {
            this._address = base.getAddress();
            this._altitude = base.getAltitude();
            this._latitude = base.getLatitude();
            this._latitudeDegrees = base.getLatitudeDegrees();
            this._latitudeMinutes = base.getLatitudeMinutes();
            this._latitudeSeconds = base.getLatitudeSeconds();
            this._longitude = base.getLongitude();
            this._longitudeDegrees = base.getLongitudeDegrees();
            this._longitudeMinutes = base.getLongitudeMinutes();
            this._longitudeSeconds = base.getLongitudeSeconds();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<GeoCoordinates> getImplementedInterface() {
            return GeoCoordinates.class;
        }

        @Override
        public SimpleAddress getAddress() {
            return this._address;
        }

        @Override
        public Integer getAltitude() {
            return this._altitude;
        }

        @Override
        public GeoCoordinates.Latitude getLatitude() {
            return this._latitude;
        }

        @Override
        public Short getLatitudeDegrees() {
            return this._latitudeDegrees;
        }

        @Override
        public Short getLatitudeMinutes() {
            return this._latitudeMinutes;
        }

        @Override
        public Short getLatitudeSeconds() {
            return this._latitudeSeconds;
        }

        @Override
        public GeoCoordinates.Longitude getLongitude() {
            return this._longitude;
        }

        @Override
        public Integer getLongitudeDegrees() {
            return this._longitudeDegrees;
        }

        @Override
        public Short getLongitudeMinutes() {
            return this._longitudeMinutes;
        }

        @Override
        public Short getLongitudeSeconds() {
            return this._longitudeSeconds;
        }

        public <E$$ extends Augmentation<GeoCoordinates>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode(this._altitude);
            result = 31 * result + Objects.hashCode(this._latitude);
            result = 31 * result + Objects.hashCode(this._latitudeDegrees);
            result = 31 * result + Objects.hashCode(this._latitudeMinutes);
            result = 31 * result + Objects.hashCode(this._latitudeSeconds);
            result = 31 * result + Objects.hashCode(this._longitude);
            result = 31 * result + Objects.hashCode(this._longitudeDegrees);
            result = 31 * result + Objects.hashCode(this._longitudeMinutes);
            result = 31 * result + Objects.hashCode(this._longitudeSeconds);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GeoCoordinates.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GeoCoordinates other = (GeoCoordinates)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this._altitude, other.getAltitude())) {
                return false;
            }
            if (!Objects.equals(this._latitude, other.getLatitude())) {
                return false;
            }
            if (!Objects.equals(this._latitudeDegrees, other.getLatitudeDegrees())) {
                return false;
            }
            if (!Objects.equals(this._latitudeMinutes, other.getLatitudeMinutes())) {
                return false;
            }
            if (!Objects.equals(this._latitudeSeconds, other.getLatitudeSeconds())) {
                return false;
            }
            if (!Objects.equals(this._longitude, other.getLongitude())) {
                return false;
            }
            if (!Objects.equals(this._longitudeDegrees, other.getLongitudeDegrees())) {
                return false;
            }
            if (!Objects.equals(this._longitudeMinutes, other.getLongitudeMinutes())) {
                return false;
            }
            if (!Objects.equals(this._longitudeSeconds, other.getLongitudeSeconds())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GeoCoordinatesImpl otherImpl = (GeoCoordinatesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GeoCoordinates>>, Augmentation<GeoCoordinates>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"GeoCoordinates");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_address", (Object)this._address);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_altitude", (Object)this._altitude);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_latitude", (Object)this._latitude);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_latitudeDegrees", (Object)this._latitudeDegrees);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_latitudeMinutes", (Object)this._latitudeMinutes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_latitudeSeconds", (Object)this._latitudeSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_longitude", (Object)this._longitude);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_longitudeDegrees", (Object)this._longitudeDegrees);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_longitudeMinutes", (Object)this._longitudeMinutes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_longitudeSeconds", (Object)this._longitudeSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

