/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.Mac;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MacBuilder
implements Builder<Mac> {
    private MacAddress _mac;
    Map<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> augmentation = Collections.emptyMap();

    public MacBuilder() {
    }

    public MacBuilder(Mac base) {
        Map aug;
        this._mac = base.getMac();
        if (base instanceof MacImpl) {
            MacImpl impl = (MacImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>(aug);
        }
    }

    public MacAddress getMac() {
        return this._mac;
    }

    public <E$$ extends Augmentation<Mac>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public MacBuilder setMac(MacAddress value) {
        this._mac = value;
        return this;
    }

    public MacBuilder addAugmentation(Class<? extends Augmentation<Mac>> augmentationType, Augmentation<Mac> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MacBuilder removeAugmentation(Class<? extends Augmentation<Mac>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Mac build() {
        return new MacImpl(this);
    }

    private static final class MacImpl
    implements Mac {
        private final MacAddress _mac;
        private Map<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        MacImpl(MacBuilder base) {
            this._mac = base.getMac();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Mac> getImplementedInterface() {
            return Mac.class;
        }

        @Override
        public MacAddress getMac() {
            return this._mac;
        }

        public <E$$ extends Augmentation<Mac>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mac);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Mac.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Mac other = (Mac)obj;
            if (!Objects.equals(this._mac, other.getMac())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MacImpl otherImpl = (MacImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Mac");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mac", (Object)this._mac);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

