/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.DistinguishedNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class SimpleAddress
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 7633714498275777936L;
    private final IpAddress _ipAddress;
    private final IpPrefix _ipPrefix;
    private final MacAddress _macAddress;
    private final DistinguishedNameType _distinguishedNameType;
    private final AsNumber _asNumber;

    public SimpleAddress(IpAddress _ipAddress) {
        this._ipAddress = _ipAddress;
        this._ipPrefix = null;
        this._macAddress = null;
        this._distinguishedNameType = null;
        this._asNumber = null;
    }

    public SimpleAddress(IpPrefix _ipPrefix) {
        this._ipPrefix = _ipPrefix;
        this._ipAddress = null;
        this._macAddress = null;
        this._distinguishedNameType = null;
        this._asNumber = null;
    }

    public SimpleAddress(MacAddress _macAddress) {
        this._macAddress = _macAddress;
        this._ipAddress = null;
        this._ipPrefix = null;
        this._distinguishedNameType = null;
        this._asNumber = null;
    }

    public SimpleAddress(DistinguishedNameType _distinguishedNameType) {
        this._distinguishedNameType = _distinguishedNameType;
        this._ipAddress = null;
        this._ipPrefix = null;
        this._macAddress = null;
        this._asNumber = null;
    }

    public SimpleAddress(AsNumber _asNumber) {
        this._asNumber = _asNumber;
        this._ipAddress = null;
        this._ipPrefix = null;
        this._macAddress = null;
        this._distinguishedNameType = null;
    }

    public SimpleAddress(SimpleAddress source) {
        this._ipAddress = source._ipAddress;
        this._ipPrefix = source._ipPrefix;
        this._macAddress = source._macAddress;
        this._distinguishedNameType = source._distinguishedNameType;
        this._asNumber = source._asNumber;
    }

    public String stringValue() {
        if (this._ipAddress != null) {
            return this._ipAddress.stringValue();
        }
        if (this._ipPrefix != null) {
            return this._ipPrefix.stringValue();
        }
        if (this._macAddress != null) {
            return this._macAddress.getValue().toString();
        }
        if (this._distinguishedNameType != null) {
            return this._distinguishedNameType.getValue().toString();
        }
        if (this._asNumber != null) {
            return this._asNumber.getValue().toString();
        }
        throw new IllegalStateException("No value assinged");
    }

    public IpAddress getIpAddress() {
        return this._ipAddress;
    }

    public IpPrefix getIpPrefix() {
        return this._ipPrefix;
    }

    public MacAddress getMacAddress() {
        return this._macAddress;
    }

    public DistinguishedNameType getDistinguishedNameType() {
        return this._distinguishedNameType;
    }

    public AsNumber getAsNumber() {
        return this._asNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._ipAddress);
        result = 31 * result + Objects.hashCode(this._ipPrefix);
        result = 31 * result + Objects.hashCode(this._macAddress);
        result = 31 * result + Objects.hashCode(this._distinguishedNameType);
        result = 31 * result + Objects.hashCode(this._asNumber);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleAddress other = (SimpleAddress)obj;
        if (!Objects.equals(this._ipAddress, other._ipAddress)) {
            return false;
        }
        if (!Objects.equals(this._ipPrefix, other._ipPrefix)) {
            return false;
        }
        if (!Objects.equals(this._macAddress, other._macAddress)) {
            return false;
        }
        if (!Objects.equals(this._distinguishedNameType, other._distinguishedNameType)) {
            return false;
        }
        return Objects.equals(this._asNumber, other._asNumber);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(SimpleAddress.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ipAddress", (Object)this._ipAddress);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ipPrefix", (Object)this._ipPrefix);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_macAddress", (Object)this._macAddress);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_distinguishedNameType", (Object)this._distinguishedNameType);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_asNumber", (Object)this._asNumber);
        return helper.toString();
    }
}

