/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tools.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.karaf.tools.utils.JoinUtil;
import org.apache.karaf.tools.utils.model.KarafPropertyEdit;

public class KarafPropertiesFile {
    private final Properties properties;
    private final File propertyFile;

    public KarafPropertiesFile(File karafHome, String location) {
        this(KarafPropertiesFile.homedPropFile(karafHome, location));
    }

    public KarafPropertiesFile(File propertyFile) {
        this.propertyFile = propertyFile;
        this.properties = new Properties();
    }

    private static File homedPropFile(File karafHome, String location) {
        File propFile = location.startsWith("/") ? new File(karafHome + location) : new File(karafHome + "/" + location);
        return propFile;
    }

    public void load() throws IOException {
        if (!this.propertyFile.exists()) {
            return;
        }
        this.properties.load(new FileInputStream(this.propertyFile));
    }

    public void put(String key, String value) {
        this.properties.put(key, value);
    }

    public void remove(String key) {
        this.properties.remove(key);
    }

    public void extend(String key, String value, boolean prepend) {
        if (this.properties.get(key) == null) {
            this.properties.put(key, value);
            return;
        }
        if (prepend) {
            this.properties.put(key, JoinUtil.join(value, (String)this.properties.get(key)));
        } else {
            this.properties.put(key, JoinUtil.join((String)this.properties.get(key), value));
        }
    }

    public void apply(KarafPropertyEdit editSpec) {
        if ("extend".equals(editSpec.getOperation().getOperation())) {
            this.extend(editSpec.getKey(), editSpec.getValue(), editSpec.getOperation().isPrepend());
        } else if ("put".equals(editSpec.getOperation().getOperation())) {
            this.put(editSpec.getKey(), editSpec.getValue());
        } else if ("remove".equals(editSpec.getOperation().getOperation())) {
            this.remove(editSpec.getKey());
        } else {
            throw new IllegalArgumentException("Operation must be 'extend' or 'put', not " + editSpec.getOperation());
        }
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public void store() throws IOException {
        this.store(this.propertyFile);
    }

    public void store(File destinationFile) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(destinationFile);){
            this.properties.store(outputStream, String.format("Modified by %s", this.getClass().getName()));
        }
    }

    public void replace(File source) {
        try {
            FileUtils.copyFile((File)source, (File)this.propertyFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to replace %s", this.propertyFile.getAbsolutePath()), e);
        }
    }
}

