/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.utils.parser;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.util.RestUtil;
import org.opendaylight.restconf.common.util.RestconfSchemaUtil;
import org.opendaylight.restconf.common.validation.RestconfValidationUtils;
import org.opendaylight.restconf.nb.rfc8040.codecs.RestCodec;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.builder.ParserBuilderConstants;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;

public final class YangInstanceIdentifierDeserializer {
    private YangInstanceIdentifierDeserializer() {
        throw new UnsupportedOperationException("Util class.");
    }

    public static Iterable<YangInstanceIdentifier.PathArgument> create(SchemaContext schemaContext, String data) {
        LinkedList<YangInstanceIdentifier.PathArgument> path = new LinkedList<YangInstanceIdentifier.PathArgument>();
        MainVarsWrapper variables = new MainVarsWrapper(data, DataSchemaContextTree.from((SchemaContext)schemaContext).getRoot(), 0, schemaContext);
        while (!YangInstanceIdentifierDeserializer.allCharsConsumed(variables)) {
            YangInstanceIdentifierDeserializer.validArg(variables);
            QName qname = YangInstanceIdentifierDeserializer.prepareQName(variables);
            if (YangInstanceIdentifierDeserializer.allCharsConsumed(variables) || YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData()) == '/') {
                YangInstanceIdentifierDeserializer.prepareIdentifier(qname, path, variables);
                if (variables.getCurrent() == null) {
                    path.add((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)qname));
                    continue;
                }
                path.add(variables.getCurrent().getIdentifier());
                continue;
            }
            if (YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData()) == '=') {
                if (YangInstanceIdentifierDeserializer.nextContextNode(qname, path, variables).getDataSchemaNode() instanceof ListSchemaNode) {
                    YangInstanceIdentifierDeserializer.prepareNodeWithPredicates(qname, path, variables, (ListSchemaNode)variables.getCurrent().getDataSchemaNode());
                    continue;
                }
                YangInstanceIdentifierDeserializer.prepareNodeWithValue(qname, path, variables);
                continue;
            }
            throw new IllegalArgumentException("Bad char " + YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData()) + " on position " + variables.getOffset() + ".");
        }
        return ImmutableList.copyOf(path);
    }

    private static void prepareNodeWithPredicates(QName qname, List<YangInstanceIdentifier.PathArgument> path, MainVarsWrapper variables, ListSchemaNode listSchemaNode) {
        YangInstanceIdentifierDeserializer.checkValid(listSchemaNode != null, "Data schema node is null", variables.getData(), variables.getOffset());
        Iterator keys = listSchemaNode.getKeyDefinition().iterator();
        ImmutableMap.Builder values = ImmutableMap.builder();
        YangInstanceIdentifierDeserializer.skipCurrentChar(variables);
        while (keys.hasNext() && !YangInstanceIdentifierDeserializer.allCharsConsumed(variables) && YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData()) != '/') {
            if (YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData()) == ',') {
                values.put(keys.next(), (Object)"");
                YangInstanceIdentifierDeserializer.skipCurrentChar(variables);
                continue;
            }
            RestconfValidationUtils.checkDocumentedError((boolean)ParserBuilderConstants.Deserializer.IDENTIFIER_PREDICATE.matches(YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData())), (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.MALFORMED_MESSAGE, (String)"");
            QName key = (QName)keys.next();
            Optional leafSchemaNode = listSchemaNode.findDataChildByName(key);
            if (!leafSchemaNode.isPresent()) {
                throw new RestconfDocumentedException("Schema not found for " + key, RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.BAD_ELEMENT);
            }
            String value = YangInstanceIdentifierDeserializer.findAndParsePercentEncoded(YangInstanceIdentifierDeserializer.nextIdentifierFromNextSequence(ParserBuilderConstants.Deserializer.IDENTIFIER_PREDICATE, variables));
            Object valueByType = YangInstanceIdentifierDeserializer.prepareValueByType((DataSchemaNode)leafSchemaNode.get(), value, variables);
            values.put((Object)key, valueByType);
            if (!keys.hasNext() || YangInstanceIdentifierDeserializer.allCharsConsumed(variables) || YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData()) != ',') continue;
            YangInstanceIdentifierDeserializer.skipCurrentChar(variables);
        }
        if (keys.hasNext()) {
            if (YangInstanceIdentifierDeserializer.allCharsConsumed(variables) || YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData()) == '/') {
                values.put(keys.next(), (Object)"");
            }
            RestconfValidationUtils.checkDocumentedError((!keys.hasNext() ? 1 : 0) != 0, (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.MISSING_ATTRIBUTE, (String)("Key value missing for: " + qname));
        }
        path.add((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(qname, (Map)values.build()));
    }

    private static Object prepareValueByType(DataSchemaNode schemaNode, String value, MainVarsWrapper vars) {
        Codec<Object, Object> codec;
        Object decoded = null;
        TypeDefinition typedef = null;
        typedef = schemaNode instanceof LeafListSchemaNode ? ((LeafListSchemaNode)schemaNode).getType() : ((LeafSchemaNode)schemaNode).getType();
        TypeDefinition baseType = RestUtil.resolveBaseTypeFrom((TypeDefinition)typedef);
        if (baseType instanceof LeafrefTypeDefinition) {
            typedef = SchemaContextUtil.getBaseTypeForLeafRef((LeafrefTypeDefinition)((LeafrefTypeDefinition)baseType), (SchemaContext)vars.getSchemaContext(), (SchemaNode)schemaNode);
        }
        if ((decoded = (codec = RestCodec.from(typedef, null, vars.getSchemaContext())).deserialize((Object)value)) == null && baseType instanceof IdentityrefTypeDefinition) {
            decoded = YangInstanceIdentifierDeserializer.toQName(value, schemaNode, vars.getSchemaContext());
        }
        return decoded;
    }

    private static Object toQName(String value, DataSchemaNode schemaNode, SchemaContext schemaContext) {
        String moduleName = YangInstanceIdentifierDeserializer.toModuleName(value);
        String nodeName = YangInstanceIdentifierDeserializer.toNodeName(value);
        Module module = (Module)schemaContext.findModules(moduleName).iterator().next();
        for (IdentitySchemaNode identitySchemaNode : module.getIdentities()) {
            QName qName = identitySchemaNode.getQName();
            if (!qName.getLocalName().equals(nodeName)) continue;
            return qName;
        }
        return QName.create((URI)schemaNode.getQName().getNamespace(), (Optional)schemaNode.getQName().getRevision(), (String)nodeName);
    }

    private static String toNodeName(String str) {
        int idx = str.indexOf(58);
        if (idx == -1) {
            return str;
        }
        if (str.indexOf(58, idx + 1) != -1) {
            return str;
        }
        return str.substring(idx + 1);
    }

    private static String toModuleName(String str) {
        int idx = str.indexOf(58);
        if (idx == -1) {
            return null;
        }
        if (str.indexOf(58, idx + 1) != -1) {
            return null;
        }
        return str.substring(0, idx);
    }

    private static QName prepareQName(MainVarsWrapper variables) {
        YangInstanceIdentifierDeserializer.checkValid(ParserBuilderConstants.Deserializer.IDENTIFIER_FIRST_CHAR.matches(YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData())), "Identifier must start with character from set 'a-zA-Z_'", variables.getData(), variables.getOffset());
        String preparedPrefix = YangInstanceIdentifierDeserializer.nextIdentifierFromNextSequence(ParserBuilderConstants.Deserializer.IDENTIFIER, variables);
        if (YangInstanceIdentifierDeserializer.allCharsConsumed(variables)) {
            return YangInstanceIdentifierDeserializer.getQNameOfDataSchemaNode(preparedPrefix, variables);
        }
        switch (YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData())) {
            case '/': 
            case '=': {
                String prefix = preparedPrefix;
                return YangInstanceIdentifierDeserializer.getQNameOfDataSchemaNode(prefix, variables);
            }
            case ':': {
                String prefix = preparedPrefix;
                YangInstanceIdentifierDeserializer.skipCurrentChar(variables);
                YangInstanceIdentifierDeserializer.checkValid(ParserBuilderConstants.Deserializer.IDENTIFIER_FIRST_CHAR.matches(YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData())), "Identifier must start with character from set 'a-zA-Z_'", variables.getData(), variables.getOffset());
                String localName = YangInstanceIdentifierDeserializer.nextIdentifierFromNextSequence(ParserBuilderConstants.Deserializer.IDENTIFIER, variables);
                if (!YangInstanceIdentifierDeserializer.allCharsConsumed(variables) && YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData()) == '=') {
                    return YangInstanceIdentifierDeserializer.getQNameOfDataSchemaNode(localName, variables);
                }
                Module module = YangInstanceIdentifierDeserializer.moduleForPrefix(prefix, variables.getSchemaContext());
                Preconditions.checkArgument((module != null ? 1 : 0) != 0, (String)"Failed to lookup prefix %s", (Object)prefix);
                return QName.create((QNameModule)module.getQNameModule(), (String)localName);
            }
        }
        throw new IllegalArgumentException("Failed build path.");
    }

    private static String nextIdentifierFromNextSequence(CharMatcher matcher, MainVarsWrapper variables) {
        int start = variables.getOffset();
        YangInstanceIdentifierDeserializer.nextSequenceEnd(matcher, variables);
        return variables.getData().substring(start, variables.getOffset());
    }

    private static void nextSequenceEnd(CharMatcher matcher, MainVarsWrapper variables) {
        while (!YangInstanceIdentifierDeserializer.allCharsConsumed(variables) && matcher.matches(variables.getData().charAt(variables.getOffset()))) {
            variables.setOffset(variables.getOffset() + 1);
        }
    }

    private static void prepareNodeWithValue(QName qname, List<YangInstanceIdentifier.PathArgument> path, MainVarsWrapper variables) {
        YangInstanceIdentifierDeserializer.skipCurrentChar(variables);
        String value = YangInstanceIdentifierDeserializer.nextIdentifierFromNextSequence(ParserBuilderConstants.Deserializer.IDENTIFIER_PREDICATE, variables);
        RestconfValidationUtils.checkDocumentedError((!value.isEmpty() ? 1 : 0) != 0, (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.MISSING_ATTRIBUTE, (String)("Value missing for: " + qname));
        DataSchemaNode dataSchemaNode = variables.getCurrent().getDataSchemaNode();
        Object valueByType = YangInstanceIdentifierDeserializer.prepareValueByType(dataSchemaNode, YangInstanceIdentifierDeserializer.findAndParsePercentEncoded(value), variables);
        path.add((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(qname, valueByType));
    }

    private static void prepareIdentifier(QName qname, List<YangInstanceIdentifier.PathArgument> path, MainVarsWrapper variables) {
        DataSchemaContextNode<?> currentNode = YangInstanceIdentifierDeserializer.nextContextNode(qname, path, variables);
        if (currentNode == null) {
            return;
        }
        YangInstanceIdentifierDeserializer.checkValid(!currentNode.isKeyedEntry(), "Entry " + qname + " requires key or value predicate to be present", variables.getData(), variables.getOffset());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    private static DataSchemaContextNode<?> nextContextNode(QName qname, List<YangInstanceIdentifier.PathArgument> path, MainVarsWrapper variables) {
        Optional module;
        variables.setCurrent(variables.getCurrent().getChild(qname));
        DataSchemaContextNode current = variables.getCurrent();
        if (current == null && (module = variables.getSchemaContext().findModule(qname.getModule())).isPresent()) {
            for (RpcDefinition rpcDefinition : ((Module)module.get()).getRpcs()) {
                if (!rpcDefinition.getQName().getLocalName().equals(qname.getLocalName())) continue;
                return null;
            }
        }
        YangInstanceIdentifierDeserializer.checkValid(current != null, qname + " is not correct schema node identifier.", variables.getData(), variables.getOffset());
        while (current.isMixin()) {
            path.add(current.getIdentifier());
            current = current.getChild(qname);
            variables.setCurrent(current);
        }
        return current;
    }

    private static String findAndParsePercentEncoded(String preparedPrefix) {
        if (!preparedPrefix.contains(String.valueOf('%'))) {
            return preparedPrefix;
        }
        StringBuilder parsedPrefix = new StringBuilder(preparedPrefix);
        CharMatcher matcher = CharMatcher.is((char)'%');
        while (matcher.matchesAnyOf((CharSequence)parsedPrefix)) {
            int percentCharPosition = matcher.indexIn((CharSequence)parsedPrefix);
            parsedPrefix.replace(percentCharPosition, percentCharPosition + 3, String.valueOf((char)Integer.parseInt(parsedPrefix.substring(percentCharPosition + 1, percentCharPosition + 3), 16)));
        }
        return parsedPrefix.toString();
    }

    private static QName getQNameOfDataSchemaNode(String nodeName, MainVarsWrapper variables) {
        DataSchemaNode dataSchemaNode = variables.getCurrent().getDataSchemaNode();
        if (dataSchemaNode instanceof ContainerSchemaNode) {
            ContainerSchemaNode contSchemaNode = (ContainerSchemaNode)dataSchemaNode;
            DataSchemaNode node = (DataSchemaNode)RestconfSchemaUtil.findSchemaNodeInCollection((Collection)contSchemaNode.getChildNodes(), (String)nodeName);
            return node.getQName();
        }
        if (dataSchemaNode instanceof ListSchemaNode) {
            ListSchemaNode listSchemaNode = (ListSchemaNode)dataSchemaNode;
            DataSchemaNode node = (DataSchemaNode)RestconfSchemaUtil.findSchemaNodeInCollection((Collection)listSchemaNode.getChildNodes(), (String)nodeName);
            return node.getQName();
        }
        throw new UnsupportedOperationException();
    }

    private static Module moduleForPrefix(String prefix, SchemaContext schemaContext) {
        return schemaContext.findModules(prefix).stream().findFirst().orElse(null);
    }

    private static void validArg(MainVarsWrapper variables) {
        if (variables.getOffset() != 0) {
            YangInstanceIdentifierDeserializer.checkValid('/' == YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData()), "Identifier must start with '/'.", variables.getData(), variables.getOffset());
            while (!YangInstanceIdentifierDeserializer.allCharsConsumed(variables) && '/' == YangInstanceIdentifierDeserializer.currentChar(variables.getOffset(), variables.getData())) {
                YangInstanceIdentifierDeserializer.skipCurrentChar(variables);
            }
            YangInstanceIdentifierDeserializer.checkValid(!YangInstanceIdentifierDeserializer.allCharsConsumed(variables), "Identifier cannot end with '/'.", variables.getData(), variables.getOffset());
        }
    }

    private static void skipCurrentChar(MainVarsWrapper variables) {
        variables.setOffset(variables.getOffset() + 1);
    }

    private static char currentChar(int offset, String data) {
        return data.charAt(offset);
    }

    private static void checkValid(boolean condition, String errorMsg, String data, int offset) {
        Preconditions.checkArgument((boolean)condition, (String)"Could not parse Instance Identifier '%s'. Offset: %s : Reason: %s", (Object)data, (Object)offset, (Object)errorMsg);
    }

    private static boolean allCharsConsumed(MainVarsWrapper variables) {
        return variables.getOffset() == variables.getData().length();
    }

    private static final class MainVarsWrapper {
        private static final int STARTING_OFFSET = 0;
        private final SchemaContext schemaContext;
        private final String data;
        private DataSchemaContextNode<?> current;
        private int offset;

        MainVarsWrapper(String data, DataSchemaContextNode<?> current, int offset, SchemaContext schemaContext) {
            this.data = data;
            this.current = current;
            this.offset = offset;
            this.schemaContext = schemaContext;
        }

        public String getData() {
            return this.data;
        }

        public DataSchemaContextNode<?> getCurrent() {
            return this.current;
        }

        public void setCurrent(DataSchemaContextNode<?> current) {
            this.current = current;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public SchemaContext getSchemaContext() {
            return this.schemaContext;
        }
    }
}

