/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.utils.parser;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.time.format.DateTimeParseException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMYangTextSourceProvider;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.schema.SchemaExportContext;
import org.opendaylight.restconf.nb.rfc8040.utils.RestconfConstants;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.IdentifierCodec;
import org.opendaylight.restconf.nb.rfc8040.utils.validations.RestconfValidation;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserIdentifier {
    private static final Logger LOG = LoggerFactory.getLogger(ParserIdentifier.class);

    private ParserIdentifier() {
        throw new UnsupportedOperationException("Util class.");
    }

    public static InstanceIdentifierContext<?> toInstanceIdentifier(String identifier, SchemaContext schemaContext, Optional<DOMMountPointService> mountPointService) {
        if (identifier != null && identifier.contains("yang-ext:mount")) {
            if (!mountPointService.isPresent()) {
                throw new RestconfDocumentedException("Mount point service is not available");
            }
            Iterator pathsIt = Splitter.on((String)"/yang-ext:mount").split((CharSequence)identifier).iterator();
            String mountPointId = (String)pathsIt.next();
            YangInstanceIdentifier mountYangInstanceIdentifier = IdentifierCodec.deserialize(mountPointId, schemaContext);
            Optional mountPoint = mountPointService.get().getMountPoint(mountYangInstanceIdentifier);
            if (!mountPoint.isPresent()) {
                throw new RestconfDocumentedException("Mount point does not exist.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_MISSING);
            }
            DOMMountPoint domMountPoint = (DOMMountPoint)mountPoint.get();
            SchemaContext mountSchemaContext = domMountPoint.getSchemaContext();
            String pathId = ((String)pathsIt.next()).replaceFirst("/", "");
            YangInstanceIdentifier pathYangInstanceIdentifier = IdentifierCodec.deserialize(pathId, mountSchemaContext);
            DataSchemaContextNode child = DataSchemaContextTree.from((SchemaContext)mountSchemaContext).getChild(pathYangInstanceIdentifier);
            if (child != null) {
                return new InstanceIdentifierContext(pathYangInstanceIdentifier, (SchemaNode)child.getDataSchemaNode(), domMountPoint, mountSchemaContext);
            }
            QName rpcQName = pathYangInstanceIdentifier.getLastPathArgument().getNodeType();
            RpcDefinition def = null;
            for (RpcDefinition rpcDefinition : ((Module)mountSchemaContext.findModule(rpcQName.getModule()).get()).getRpcs()) {
                if (!rpcDefinition.getQName().getLocalName().equals(rpcQName.getLocalName())) continue;
                def = rpcDefinition;
                break;
            }
            return new InstanceIdentifierContext(pathYangInstanceIdentifier, def, domMountPoint, mountSchemaContext);
        }
        YangInstanceIdentifier deserialize = IdentifierCodec.deserialize(identifier, schemaContext);
        DataSchemaContextNode child = DataSchemaContextTree.from((SchemaContext)schemaContext).getChild(deserialize);
        if (child != null) {
            return new InstanceIdentifierContext(deserialize, (SchemaNode)child.getDataSchemaNode(), null, schemaContext);
        }
        QName rpcQName = deserialize.getLastPathArgument().getNodeType();
        RpcDefinition def = null;
        for (RpcDefinition rpcDefinition : ((Module)schemaContext.findModule(rpcQName.getModule()).get()).getRpcs()) {
            if (!rpcDefinition.getQName().getLocalName().equals(rpcQName.getLocalName())) continue;
            def = rpcDefinition;
            break;
        }
        return new InstanceIdentifierContext(deserialize, def, null, schemaContext);
    }

    public static String stringFromYangInstanceIdentifier(YangInstanceIdentifier instanceIdentifier, SchemaContext schemaContext) {
        return IdentifierCodec.serialize(instanceIdentifier, schemaContext);
    }

    public static Map.Entry<String, Revision> makeQNameFromIdentifier(String identifier) {
        Revision moduleRevision;
        if (identifier.contains(String.valueOf('/').concat(String.valueOf('/')))) {
            LOG.debug("URI has bad format. It should be 'moduleName/yyyy-MM-dd' {}", (Object)identifier);
            throw new RestconfDocumentedException("URI has bad format. End of URI should be in format 'moduleName/yyyy-MM-dd'", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        int mountIndex = identifier.indexOf("yang-ext:mount");
        String moduleNameAndRevision = mountIndex >= 0 ? identifier.substring(mountIndex + "yang-ext:mount".length()).replaceFirst(String.valueOf('/'), "") : identifier;
        List pathArgs = RestconfConstants.SLASH_SPLITTER.splitToList((CharSequence)moduleNameAndRevision);
        if (pathArgs.size() != 2) {
            LOG.debug("URI has bad format '{}'. It should be 'moduleName/yyyy-MM-dd'", (Object)identifier);
            throw new RestconfDocumentedException("URI has bad format. End of URI should be in format 'moduleName/yyyy-MM-dd'", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        try {
            moduleRevision = Revision.of((String)((String)pathArgs.get(1)));
        }
        catch (DateTimeParseException e) {
            LOG.debug("URI has bad format: '{}'. It should be 'moduleName/yyyy-MM-dd'", (Object)identifier);
            throw new RestconfDocumentedException("URI has bad format. It should be 'moduleName/yyyy-MM-dd'", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE, (Throwable)e);
        }
        return new AbstractMap.SimpleImmutableEntry<String, Revision>((String)pathArgs.get(0), moduleRevision);
    }

    public static SchemaExportContext toSchemaExportContextFromIdentifier(SchemaContext schemaContext, String identifier, DOMMountPointService domMountPointService, DOMYangTextSourceProvider sourceProvider) {
        Iterable pathComponents = RestconfConstants.SLASH_SPLITTER.split((CharSequence)identifier);
        Iterator<String> componentIter = pathComponents.iterator();
        if (!Iterables.contains((Iterable)pathComponents, (Object)"yang-ext:mount")) {
            String moduleName = RestconfValidation.validateAndGetModulName(componentIter);
            Revision revision = RestconfValidation.validateAndGetRevision(componentIter);
            Module module = schemaContext.findModule(moduleName, revision).orElse(null);
            return new SchemaExportContext(schemaContext, module, sourceProvider);
        }
        StringBuilder pathBuilder = new StringBuilder();
        while (componentIter.hasNext()) {
            String current = componentIter.next();
            if ("yang-ext:mount".equals(current)) {
                pathBuilder.append("/");
                pathBuilder.append("yang-ext:mount");
                break;
            }
            if (pathBuilder.length() != 0) {
                pathBuilder.append("/");
            }
            pathBuilder.append(current);
        }
        InstanceIdentifierContext<?> point = ParserIdentifier.toInstanceIdentifier(pathBuilder.toString(), schemaContext, Optional.of(domMountPointService));
        String moduleName = RestconfValidation.validateAndGetModulName(componentIter);
        Revision revision = RestconfValidation.validateAndGetRevision(componentIter);
        Module module = point.getMountPoint().getSchemaContext().findModule(moduleName, revision).orElse(null);
        return new SchemaExportContext(point.getMountPoint().getSchemaContext(), module, sourceProvider);
    }
}

