/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.utils.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.builder.ParserBuilderConstants;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class ParserFieldsParameter {
    private static final char COLON = ':';
    private static final char SEMICOLON = ';';
    private static final char SLASH = '/';
    private static final char STARTING_PARENTHESIS = '(';
    private static final char CLOSING_PARENTHESIS = ')';

    private ParserFieldsParameter() {
    }

    @Nonnull
    public static List<Set<QName>> parseFieldsParameter(@Nonnull InstanceIdentifierContext<?> identifier, @Nonnull String input) {
        ArrayList<Set<QName>> parsed = new ArrayList<Set<QName>>();
        SchemaContext context = identifier.getSchemaContext();
        QNameModule startQNameModule = identifier.getSchemaNode().getQName().getModule();
        DataSchemaContextNode startNode = DataSchemaContextNode.fromDataSchemaNode((DataSchemaNode)((DataSchemaNode)identifier.getSchemaNode()));
        if (startNode == null) {
            throw new RestconfDocumentedException("Start node missing in " + input, RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        ParserFieldsParameter.parseInput(input, startQNameModule, startNode, parsed, context);
        return parsed;
    }

    private static void parseInput(@Nonnull String input, @Nonnull QNameModule startQNameModule, @Nonnull DataSchemaContextNode<?> startNode, @Nonnull List<Set<QName>> parsed, @Nonnull SchemaContext context) {
        int currentPosition = 0;
        int startPosition = 0;
        DataSchemaContextNode<?> currentNode = startNode;
        QNameModule currentQNameModule = startQNameModule;
        HashSet<Object> currentLevel = new HashSet<QName>();
        parsed.add(currentLevel);
        while (currentPosition < input.length()) {
            char currentChar = input.charAt(currentPosition);
            if (ParserBuilderConstants.Deserializer.IDENTIFIER.matches(currentChar) || currentChar == '/') {
                if (currentChar == '/') {
                    currentNode = ParserFieldsParameter.addChildToResult(currentNode, input.substring(startPosition, currentPosition), currentQNameModule, currentLevel);
                    currentLevel = new HashSet();
                    parsed.add(currentLevel);
                    startPosition = ++currentPosition;
                    continue;
                }
                ++currentPosition;
                continue;
            }
            switch (currentChar) {
                case ':': {
                    currentQNameModule = ((Module)context.findModules(input.substring(startPosition, currentPosition)).iterator().next()).getQNameModule();
                    break;
                }
                case '(': {
                    DataSchemaContextNode<?> child = ParserFieldsParameter.addChildToResult(currentNode, input.substring(startPosition, currentPosition), currentQNameModule, currentLevel);
                    int closingParenthesis = currentPosition + ParserFieldsParameter.findClosingParenthesis(input.substring(currentPosition + 1));
                    ParserFieldsParameter.parseInput(input.substring(currentPosition + 1, closingParenthesis), currentQNameModule, child, parsed, context);
                    currentPosition = closingParenthesis + 1;
                    if (currentPosition == input.length()) break;
                    if (currentPosition + 1 < input.length()) {
                        if (input.charAt(currentPosition) == ';') {
                            ++currentPosition;
                            break;
                        }
                        throw new RestconfDocumentedException("Missing semicolon character after " + child.getIdentifier().getNodeType().getLocalName() + " child nodes", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
                    }
                    throw new RestconfDocumentedException("Unexpected character '" + input.charAt(currentPosition) + "' found in fields parameter value", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
                }
                case ';': {
                    ParserFieldsParameter.addChildToResult(currentNode, input.substring(startPosition, currentPosition), currentQNameModule, currentLevel);
                    ++currentPosition;
                    break;
                }
                default: {
                    throw new RestconfDocumentedException("Unexpected character '" + currentChar + "' found in fields parameter value", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
                }
            }
            startPosition = ++currentPosition;
        }
        if (startPosition < input.length()) {
            ParserFieldsParameter.addChildToResult(currentNode, input.substring(startPosition), currentQNameModule, currentLevel);
        }
    }

    @Nonnull
    private static DataSchemaContextNode<?> addChildToResult(@Nonnull DataSchemaContextNode<?> currentNode, @Nonnull String identifier, @Nonnull QNameModule currentQNameModule, @Nonnull Set<QName> level) {
        QName childQName = QName.create((QNameModule)currentQNameModule, (String)identifier);
        DataSchemaContextNode<?> parentNode = ParserFieldsParameter.resolveMixinNode(currentNode, level, currentNode.getIdentifier().getNodeType());
        if (parentNode == null) {
            throw new RestconfDocumentedException("Not-mixin node missing in " + currentNode.getIdentifier().getNodeType().getLocalName(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        DataSchemaContextNode<?> childNode = ParserFieldsParameter.resolveMixinNode(parentNode.getChild(childQName), level, childQName);
        if (childNode == null) {
            throw new RestconfDocumentedException("Child " + identifier + " node missing in " + currentNode.getIdentifier().getNodeType().getLocalName(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        level.add(childNode.getIdentifier().getNodeType());
        return childNode;
    }

    @Nullable
    private static DataSchemaContextNode<?> resolveMixinNode(@Nullable DataSchemaContextNode<?> node, @Nonnull Set<QName> level, @Nonnull QName qualifiedName) {
        DataSchemaContextNode currentNode;
        for (currentNode = node; currentNode != null && currentNode.isMixin(); currentNode = currentNode.getChild(qualifiedName)) {
            level.add(qualifiedName);
        }
        return currentNode;
    }

    private static int findClosingParenthesis(@Nonnull String input) {
        int position;
        int count = 1;
        for (position = 0; position < input.length(); ++position) {
            char currentChar = input.charAt(position);
            if (currentChar == '(') {
                ++count;
            }
            if (currentChar == ')') {
                --count;
            }
            if (count == 0) break;
        }
        if (position >= input.length()) {
            throw new RestconfDocumentedException("Missing closing parenthesis in fields parameter", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        return ++position;
    }
}

