/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.streams.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.BaseListenerInterface;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.ListenerAdapter;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.NotificationListenerAdapter;
import org.opendaylight.yang.gen.v1.urn.sal.restconf.event.subscription.rev140708.NotificationOutputTypeGrouping;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Notificator {
    private static Map<String, ListenerAdapter> dataChangeListener = new ConcurrentHashMap<String, ListenerAdapter>();
    private static Map<String, List<NotificationListenerAdapter>> notificationListenersByStreamName = new ConcurrentHashMap<String, List<NotificationListenerAdapter>>();
    private static final Logger LOG = LoggerFactory.getLogger(Notificator.class);
    private static final Lock LOCK = new ReentrantLock();

    private Notificator() {
    }

    public static Set<String> getStreamNames() {
        return dataChangeListener.keySet();
    }

    public static ListenerAdapter getListenerFor(String streamName) {
        return dataChangeListener.get(streamName);
    }

    public static boolean existListenerFor(String streamName) {
        return dataChangeListener.containsKey(streamName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListenerAdapter createListener(YangInstanceIdentifier path, String streamName, NotificationOutputTypeGrouping.NotificationOutputType outputType) {
        ListenerAdapter listener = new ListenerAdapter(path, streamName, outputType);
        try {
            LOCK.lock();
            dataChangeListener.put(streamName, listener);
        }
        finally {
            LOCK.unlock();
        }
        return listener;
    }

    public static String createStreamNameFromUri(String uri) {
        if (uri == null) {
            return null;
        }
        String result = uri;
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static void removeAllListeners() {
        for (ListenerAdapter listener : dataChangeListener.values()) {
            try {
                listener.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close listener", (Throwable)e);
            }
        }
        try {
            LOCK.lock();
            dataChangeListener = new ConcurrentHashMap<String, ListenerAdapter>();
        }
        finally {
            LOCK.unlock();
        }
    }

    private static <T extends BaseListenerInterface> void deleteListener(T listener) {
        if (listener != null) {
            try {
                listener.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close listener", (Throwable)e);
            }
            try {
                LOCK.lock();
                dataChangeListener.remove(listener.getStreamName());
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    public static boolean existNotificationListenerFor(String streamName) {
        return notificationListenersByStreamName.containsKey(streamName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NotificationListenerAdapter> createNotificationListener(List<SchemaPath> paths, String streamName, String outputType) {
        ArrayList<NotificationListenerAdapter> listListeners = new ArrayList<NotificationListenerAdapter>();
        for (SchemaPath path : paths) {
            NotificationListenerAdapter listener = new NotificationListenerAdapter(path, streamName, outputType);
            listListeners.add(listener);
        }
        try {
            LOCK.lock();
            notificationListenersByStreamName.put(streamName, listListeners);
        }
        finally {
            LOCK.unlock();
        }
        return listListeners;
    }

    public static <T extends BaseListenerInterface> void removeListenerIfNoSubscriberExists(T listener) {
        if (!listener.hasSubscribers()) {
            if (listener instanceof NotificationListenerAdapter) {
                Notificator.deleteNotificationListener(listener);
            } else {
                Notificator.deleteListener(listener);
            }
        }
    }

    private static <T extends BaseListenerInterface> void deleteNotificationListener(T listener) {
        if (listener != null) {
            try {
                listener.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close listener", (Throwable)e);
            }
            try {
                LOCK.lock();
                notificationListenersByStreamName.remove(listener.getStreamName());
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    public static List<NotificationListenerAdapter> getNotificationListenerFor(String streamName) {
        return notificationListenersByStreamName.get(streamName);
    }
}

