/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.streams.listeners;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.AbstractCommonSubscriber;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.Event;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.EventType;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.ListenerAdapter;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonWriterFactory;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NotificationListenerAdapter
extends AbstractCommonSubscriber
implements DOMNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationListenerAdapter.class);
    private final String streamName;
    private final SchemaPath path;
    private final String outputType;

    NotificationListenerAdapter(SchemaPath path, String streamName, String outputType) {
        this.register(this);
        this.setLocalNameOfPath(path.getLastComponent().getLocalName());
        this.outputType = (String)Preconditions.checkNotNull((Object)outputType);
        this.path = (SchemaPath)Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((streamName != null && !streamName.isEmpty() ? 1 : 0) != 0);
        this.streamName = streamName;
    }

    @Override
    public String getOutputType() {
        return this.outputType;
    }

    public void onNotification(DOMNotification notification) {
        Instant now = Instant.now();
        if (!this.checkStartStop(now, this)) {
            return;
        }
        SchemaContext schemaContext = this.schemaHandler.get();
        String xml = this.prepareXml(schemaContext, notification);
        if (this.checkFilter(xml)) {
            this.prepareAndPostData(this.outputType.equals("JSON") ? this.prepareJson(schemaContext, notification) : xml);
        }
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    public SchemaPath getSchemaPath() {
        return this.path;
    }

    private void prepareAndPostData(String data) {
        Event event = new Event(EventType.NOTIFY);
        event.setData(data);
        this.post(event);
    }

    @VisibleForTesting
    String prepareJson(SchemaContext schemaContext, DOMNotification notification) {
        JsonParser jsonParser = new JsonParser();
        JsonObject json = new JsonObject();
        json.add("ietf-restconf:notification", jsonParser.parse(NotificationListenerAdapter.writeBodyToString(schemaContext, notification)));
        json.addProperty("event-time", ListenerAdapter.toRFC3339(Instant.now()));
        return json.toString();
    }

    private static String writeBodyToString(SchemaContext schemaContext, DOMNotification notification) {
        StringWriter writer = new StringWriter();
        NormalizedNodeStreamWriter jsonStream = JSONNormalizedNodeStreamWriter.createExclusiveWriter((JSONCodecFactory)JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(schemaContext), (SchemaPath)notification.getType(), null, (JsonWriter)JsonWriterFactory.createJsonWriter((Writer)writer));
        NormalizedNodeWriter nodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)jsonStream);
        try {
            nodeWriter.write((NormalizedNode)notification.getBody());
            nodeWriter.close();
        }
        catch (IOException e) {
            throw new RestconfDocumentedException("Problem while writing body of notification to JSON. ", (Throwable)e);
        }
        return ((Object)writer).toString();
    }

    private String prepareXml(SchemaContext schemaContext, DOMNotification notification) {
        Document doc = NotificationListenerAdapter.createDocument();
        Element notificationElement = this.basePartDoc(doc);
        Element notificationEventElement = doc.createElementNS("urn:opendaylight:params:xml:ns:yang:controller:md:sal:remote", "create-notification-stream");
        this.addValuesToNotificationEventElement(doc, notificationEventElement, schemaContext, notification);
        notificationElement.appendChild(notificationEventElement);
        return this.transformDoc(doc);
    }

    private void addValuesToNotificationEventElement(Document doc, Element element, SchemaContext schemaContext, DOMNotification notification) {
        try {
            DOMResult domResult = this.writeNormalizedNode((NormalizedNode<?, ?>)notification.getBody(), schemaContext, this.path);
            Node result = doc.importNode(domResult.getNode().getFirstChild(), true);
            Element dataElement = doc.createElement("notification");
            dataElement.appendChild(result);
            element.appendChild(dataElement);
        }
        catch (IOException e) {
            LOG.error("Error in writer ", (Throwable)e);
        }
        catch (XMLStreamException e) {
            LOG.error("Error processing stream", (Throwable)e);
        }
    }
}

