/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.streams.listeners;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.json.XML;
import org.opendaylight.mdsal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.AbstractCommonSubscriber;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.Event;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.EventType;
import org.opendaylight.yang.gen.v1.urn.sal.restconf.event.subscription.rev140708.NotificationOutputTypeGrouping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ListenerAdapter
extends AbstractCommonSubscriber
implements ClusteredDOMDataTreeChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerAdapter.class);
    private final YangInstanceIdentifier path;
    private final String streamName;
    private final NotificationOutputTypeGrouping.NotificationOutputType outputType;

    ListenerAdapter(YangInstanceIdentifier path, String streamName, NotificationOutputTypeGrouping.NotificationOutputType outputType) {
        this.register(this);
        this.setLocalNameOfPath(path.getLastPathArgument().getNodeType().getLocalName());
        this.outputType = (NotificationOutputTypeGrouping.NotificationOutputType)Preconditions.checkNotNull((Object)outputType);
        this.path = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((streamName != null && !streamName.isEmpty() ? 1 : 0) != 0);
        this.streamName = streamName;
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> dataTreeCandidates) {
        Instant now = Instant.now();
        if (!this.checkStartStop(now, this)) {
            return;
        }
        String xml = this.prepareXml(dataTreeCandidates);
        if (this.checkFilter(xml)) {
            this.prepareAndPostData(xml);
        }
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public String getOutputType() {
        return this.outputType.getName();
    }

    public YangInstanceIdentifier getPath() {
        return this.path;
    }

    private void prepareAndPostData(String xml) {
        Event event = new Event(EventType.NOTIFY);
        if (this.outputType.equals((Object)NotificationOutputTypeGrouping.NotificationOutputType.JSON)) {
            event.setData(XML.toJSONObject((String)xml).toString());
        } else {
            event.setData(xml);
        }
        this.post(event);
    }

    private String prepareXml(Collection<DataTreeCandidate> dataTreeCandidates) {
        SchemaContext schemaContext = this.schemaHandler.get();
        DataSchemaContextTree dataContextTree = DataSchemaContextTree.from((SchemaContext)schemaContext);
        Document doc = ListenerAdapter.createDocument();
        Element notificationElement = this.basePartDoc(doc);
        Element dataChangedNotificationEventElement = doc.createElementNS("urn:opendaylight:params:xml:ns:yang:controller:md:sal:remote", "data-changed-notification");
        this.addValuesToDataChangedNotificationEventElement(doc, dataChangedNotificationEventElement, dataTreeCandidates, schemaContext, dataContextTree);
        notificationElement.appendChild(dataChangedNotificationEventElement);
        return this.transformDoc(doc);
    }

    private void addValuesToDataChangedNotificationEventElement(Document doc, Element dataChangedNotificationEventElement, Collection<DataTreeCandidate> dataTreeCandidates, SchemaContext schemaContext, DataSchemaContextTree dataSchemaContextTree) {
        for (DataTreeCandidate dataTreeCandidate : dataTreeCandidates) {
            DataTreeCandidateNode candidateNode = dataTreeCandidate.getRootNode();
            if (candidateNode == null) continue;
            YangInstanceIdentifier yiid = dataTreeCandidate.getRootPath();
            this.addNodeToDataChangeNotificationEventElement(doc, dataChangedNotificationEventElement, candidateNode, yiid.getParent(), schemaContext, dataSchemaContextTree);
        }
    }

    private void addNodeToDataChangeNotificationEventElement(Document doc, Element dataChangedNotificationEventElement, DataTreeCandidateNode candidateNode, YangInstanceIdentifier parentYiid, SchemaContext schemaContext, DataSchemaContextTree dataSchemaContextTree) {
        boolean isSkippedNonLeaf;
        Optional optionalNormalizedNode = Optional.empty();
        switch (candidateNode.getModificationType()) {
            case APPEARED: 
            case SUBTREE_MODIFIED: 
            case WRITE: {
                optionalNormalizedNode = candidateNode.getDataAfter();
                break;
            }
            case DELETE: 
            case DISAPPEARED: {
                optionalNormalizedNode = candidateNode.getDataBefore();
                break;
            }
        }
        if (!optionalNormalizedNode.isPresent()) {
            LOG.error("No node present in notification for {}", (Object)candidateNode);
            return;
        }
        NormalizedNode normalizedNode = (NormalizedNode)optionalNormalizedNode.get();
        YangInstanceIdentifier yiid = YangInstanceIdentifier.builder((YangInstanceIdentifier)parentYiid).append(new YangInstanceIdentifier.PathArgument[]{normalizedNode.getIdentifier()}).build();
        boolean isNodeMixin = dataSchemaContextTree.getChild(yiid).isMixin();
        boolean bl = isSkippedNonLeaf = this.getLeafNodesOnly() && !(normalizedNode instanceof LeafNode);
        if (!isNodeMixin && !isSkippedNonLeaf) {
            Node node = null;
            switch (candidateNode.getModificationType()) {
                case APPEARED: 
                case SUBTREE_MODIFIED: 
                case WRITE: {
                    Operation op = candidateNode.getDataBefore().isPresent() ? Operation.UPDATED : Operation.CREATED;
                    node = this.createCreatedChangedDataChangeEventElement(doc, yiid, normalizedNode, op, schemaContext, dataSchemaContextTree);
                    break;
                }
                case DELETE: 
                case DISAPPEARED: {
                    node = this.createDataChangeEventElement(doc, yiid, Operation.DELETED, schemaContext);
                    break;
                }
            }
            if (node != null) {
                dataChangedNotificationEventElement.appendChild(node);
            }
        }
        for (DataTreeCandidateNode childNode : candidateNode.getChildNodes()) {
            this.addNodeToDataChangeNotificationEventElement(doc, dataChangedNotificationEventElement, childNode, yiid, schemaContext, dataSchemaContextTree);
        }
    }

    private Node createDataChangeEventElement(Document doc, YangInstanceIdentifier eventPath, Operation operation, SchemaContext schemaContext) {
        Element dataChangeEventElement = doc.createElement("data-change-event");
        Element pathElement = doc.createElement("path");
        this.addPathAsValueToElement(eventPath, pathElement, schemaContext);
        dataChangeEventElement.appendChild(pathElement);
        Element operationElement = doc.createElement("operation");
        operationElement.setTextContent(operation.value);
        dataChangeEventElement.appendChild(operationElement);
        return dataChangeEventElement;
    }

    private Node createCreatedChangedDataChangeEventElement(Document doc, YangInstanceIdentifier eventPath, NormalizedNode<?, ?> normalized, Operation operation, SchemaContext schemaContext, DataSchemaContextTree dataSchemaContextTree) {
        Element dataChangeEventElement = doc.createElement("data-change-event");
        Element pathElement = doc.createElement("path");
        this.addPathAsValueToElement(eventPath, pathElement, schemaContext);
        dataChangeEventElement.appendChild(pathElement);
        Element operationElement = doc.createElement("operation");
        operationElement.setTextContent(operation.value);
        dataChangeEventElement.appendChild(operationElement);
        try {
            SchemaPath nodePath = normalized instanceof MapEntryNode || normalized instanceof UnkeyedListEntryNode ? dataSchemaContextTree.getChild(eventPath).getDataSchemaNode().getPath() : dataSchemaContextTree.getChild(eventPath).getDataSchemaNode().getPath().getParent();
            DOMResult domResult = this.writeNormalizedNode(normalized, schemaContext, nodePath);
            Node result = doc.importNode(domResult.getNode().getFirstChild(), true);
            Element dataElement = doc.createElement("data");
            dataElement.appendChild(result);
            dataChangeEventElement.appendChild(dataElement);
        }
        catch (IOException e) {
            LOG.error("Error in writer ", (Throwable)e);
        }
        catch (XMLStreamException e) {
            LOG.error("Error processing stream", (Throwable)e);
        }
        return dataChangeEventElement;
    }

    private void addPathAsValueToElement(YangInstanceIdentifier eventPath, Element element, SchemaContext schemaContext) {
        StringBuilder textContent = new StringBuilder();
        for (YangInstanceIdentifier.PathArgument pathArgument : eventPath.getPathArguments()) {
            if (pathArgument instanceof YangInstanceIdentifier.AugmentationIdentifier) continue;
            textContent.append("/");
            ListenerAdapter.writeIdentifierWithNamespacePrefix(element, textContent, pathArgument.getNodeType(), schemaContext);
            if (pathArgument instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                Map predicates = ((YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument).getKeyValues();
                for (Map.Entry entry : predicates.entrySet()) {
                    QName keyValue = (QName)entry.getKey();
                    String predicateValue = String.valueOf(entry.getValue());
                    textContent.append("[");
                    ListenerAdapter.writeIdentifierWithNamespacePrefix(element, textContent, keyValue, schemaContext);
                    textContent.append("='");
                    textContent.append(predicateValue);
                    textContent.append("'");
                    textContent.append("]");
                }
                continue;
            }
            if (!(pathArgument instanceof YangInstanceIdentifier.NodeWithValue)) continue;
            textContent.append("[.='");
            textContent.append(((YangInstanceIdentifier.NodeWithValue)pathArgument).getValue());
            textContent.append("'");
            textContent.append("]");
        }
        element.setTextContent(textContent.toString());
    }

    private static void writeIdentifierWithNamespacePrefix(Element element, StringBuilder textContent, QName qualifiedName, SchemaContext schemaContext) {
        Module module = (Module)schemaContext.findModule(qualifiedName.getModule()).get();
        textContent.append(module.getName());
        textContent.append(":");
        textContent.append(qualifiedName.getLocalName());
    }

    private static enum Operation {
        CREATED("created"),
        UPDATED("updated"),
        DELETED("deleted");

        private final String value;

        private Operation(String value) {
            this.value = value;
        }
    }
}

