/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.streams.listeners;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.StringReader;
import java.time.Instant;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.AbstractNotificationsData;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.BaseListenerInterface;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

abstract class AbstractQueryParams
extends AbstractNotificationsData {
    private static final DocumentBuilderFactory DBF;
    private Instant start = null;
    private Instant stop = null;
    private String filter = null;
    private boolean leafNodesOnly = false;

    AbstractQueryParams() {
    }

    @VisibleForTesting
    public final Instant getStart() {
        return this.start;
    }

    public void setQueryParams(Instant start, Optional<Instant> stop, Optional<String> filter, boolean leafNodesOnly) {
        this.start = (Instant)Preconditions.checkNotNull((Object)start);
        this.stop = stop.orElse(null);
        this.filter = filter.orElse(null);
        this.leafNodesOnly = leafNodesOnly;
    }

    public boolean getLeafNodesOnly() {
        return this.leafNodesOnly;
    }

    <T extends BaseListenerInterface> boolean checkStartStop(Instant now, T listener) {
        if (this.stop != null) {
            if (this.start.compareTo(now) < 0 && this.stop.compareTo(now) > 0) {
                return true;
            }
            if (this.stop.compareTo(now) < 0) {
                try {
                    listener.close();
                }
                catch (Exception e) {
                    throw new RestconfDocumentedException("Problem with unregister listener." + e);
                }
            }
        } else if (this.start != null) {
            if (this.start.compareTo(now) < 0) {
                this.start = null;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    boolean checkFilter(String xml) {
        if (this.filter == null) {
            return true;
        }
        try {
            return this.parseFilterParam(xml);
        }
        catch (Exception e) {
            throw new RestconfDocumentedException("Problem while parsing filter.", (Throwable)e);
        }
    }

    private boolean parseFilterParam(String xml) throws Exception {
        Document docOfXml = DBF.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        XPath xPath = XPathFactory.newInstance().newXPath();
        return (Boolean)xPath.compile(this.filter).evaluate(docOfXml, XPathConstants.BOOLEAN);
    }

    static {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setCoalescing(true);
        f.setExpandEntityReferences(false);
        f.setIgnoringElementContentWhitespace(true);
        f.setIgnoringComments(true);
        f.setXIncludeAware(false);
        try {
            f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            f.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            f.setFeature("http://xml.org/sax/features/external-general-entities", false);
            f.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        DBF = f;
    }
}

