/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.services.wrapper;

import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.api.DOMYangTextSourceProvider;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.common.schema.SchemaExportContext;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMDataBrokerHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.NotificationServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.RpcServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.TransactionChainHandler;
import org.opendaylight.restconf.nb.rfc8040.rests.services.api.RestconfDataService;
import org.opendaylight.restconf.nb.rfc8040.rests.services.api.RestconfInvokeOperationsService;
import org.opendaylight.restconf.nb.rfc8040.rests.services.api.RestconfStreamsSubscriptionService;
import org.opendaylight.restconf.nb.rfc8040.rests.services.api.TransactionServicesWrapper;
import org.opendaylight.restconf.nb.rfc8040.rests.services.impl.RestconfDataServiceImpl;
import org.opendaylight.restconf.nb.rfc8040.rests.services.impl.RestconfInvokeOperationsServiceImpl;
import org.opendaylight.restconf.nb.rfc8040.rests.services.impl.RestconfStreamsSubscriptionServiceImpl;
import org.opendaylight.restconf.nb.rfc8040.services.simple.api.BaseServicesWrapper;
import org.opendaylight.restconf.nb.rfc8040.services.simple.api.RestconfOperationsService;
import org.opendaylight.restconf.nb.rfc8040.services.simple.api.RestconfSchemaService;
import org.opendaylight.restconf.nb.rfc8040.services.simple.api.RestconfService;
import org.opendaylight.restconf.nb.rfc8040.services.simple.impl.RestconfImpl;
import org.opendaylight.restconf.nb.rfc8040.services.simple.impl.RestconfOperationsServiceImpl;
import org.opendaylight.restconf.nb.rfc8040.services.simple.impl.RestconfSchemaServiceImpl;

@Path(value="/")
public final class ServicesWrapper
implements BaseServicesWrapper,
TransactionServicesWrapper {
    private final RestconfDataService delegRestconfDataService;
    private final RestconfInvokeOperationsService delegRestconfInvokeOpsService;
    private final RestconfStreamsSubscriptionService delegRestconfSubscrService;
    private final RestconfOperationsService delegRestOpsService;
    private final RestconfSchemaService delegRestSchService;
    private final RestconfService delegRestService;

    private ServicesWrapper(RestconfDataService delegRestconfDataService, RestconfInvokeOperationsService delegRestconfInvokeOpsService, RestconfStreamsSubscriptionService delegRestconfSubscrService, RestconfOperationsService delegRestOpsService, RestconfSchemaService delegRestSchService, RestconfService delegRestService) {
        this.delegRestconfDataService = delegRestconfDataService;
        this.delegRestconfInvokeOpsService = delegRestconfInvokeOpsService;
        this.delegRestconfSubscrService = delegRestconfSubscrService;
        this.delegRestOpsService = delegRestOpsService;
        this.delegRestSchService = delegRestSchService;
        this.delegRestService = delegRestService;
    }

    public static ServicesWrapper newInstance(SchemaContextHandler schemaCtxHandler, DOMMountPointServiceHandler domMountPointServiceHandler, TransactionChainHandler transactionChainHandler, DOMDataBrokerHandler domDataBrokerHandler, RpcServiceHandler rpcServiceHandler, NotificationServiceHandler notificationServiceHandler, DOMSchemaService domSchemaService) {
        RestconfOperationsServiceImpl restconfOpsService = new RestconfOperationsServiceImpl(schemaCtxHandler, domMountPointServiceHandler);
        DOMYangTextSourceProvider yangTextSourceProvider = (DOMYangTextSourceProvider)domSchemaService.getExtensions().getInstance(DOMYangTextSourceProvider.class);
        RestconfSchemaServiceImpl restconfSchemaService = new RestconfSchemaServiceImpl(schemaCtxHandler, domMountPointServiceHandler, yangTextSourceProvider);
        RestconfStreamsSubscriptionServiceImpl restconfSubscrService = new RestconfStreamsSubscriptionServiceImpl(domDataBrokerHandler, notificationServiceHandler, schemaCtxHandler, transactionChainHandler);
        RestconfDataServiceImpl restconfDataService = new RestconfDataServiceImpl(schemaCtxHandler, transactionChainHandler, domMountPointServiceHandler, restconfSubscrService);
        RestconfInvokeOperationsServiceImpl restconfInvokeOpsService = new RestconfInvokeOperationsServiceImpl(rpcServiceHandler, schemaCtxHandler);
        RestconfImpl restconfService = new RestconfImpl(schemaCtxHandler);
        return new ServicesWrapper(restconfDataService, restconfInvokeOpsService, restconfSubscrService, restconfOpsService, restconfSchemaService, restconfService);
    }

    @Override
    public NormalizedNodeContext getOperations(UriInfo uriInfo) {
        return this.delegRestOpsService.getOperations(uriInfo);
    }

    @Override
    public NormalizedNodeContext getOperations(String identifier, UriInfo uriInfo) {
        return this.delegRestOpsService.getOperations(identifier, uriInfo);
    }

    @Override
    public SchemaExportContext getSchema(String mountAndModuleId) {
        return this.delegRestSchService.getSchema(mountAndModuleId);
    }

    @Override
    public Response readData(UriInfo uriInfo) {
        return this.delegRestconfDataService.readData(uriInfo);
    }

    @Override
    public Response readData(String identifier, UriInfo uriInfo) {
        return this.delegRestconfDataService.readData(identifier, uriInfo);
    }

    @Override
    public Response putData(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        return this.delegRestconfDataService.putData(identifier, payload, uriInfo);
    }

    @Override
    public Response postData(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        return this.delegRestconfDataService.postData(identifier, payload, uriInfo);
    }

    @Override
    public Response postData(NormalizedNodeContext payload, UriInfo uriInfo) {
        return this.delegRestconfDataService.postData(payload, uriInfo);
    }

    @Override
    public Response deleteData(String identifier) {
        return this.delegRestconfDataService.deleteData(identifier);
    }

    @Override
    public PatchStatusContext patchData(String identifier, PatchContext context, UriInfo uriInfo) {
        return this.delegRestconfDataService.patchData(identifier, context, uriInfo);
    }

    @Override
    public PatchStatusContext patchData(PatchContext context, UriInfo uriInfo) {
        return this.delegRestconfDataService.patchData(context, uriInfo);
    }

    @Override
    public NormalizedNodeContext invokeRpc(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        return this.delegRestconfInvokeOpsService.invokeRpc(identifier, payload, uriInfo);
    }

    @Override
    public NormalizedNodeContext subscribeToStream(String identifier, UriInfo uriInfo) {
        return this.delegRestconfSubscrService.subscribeToStream(identifier, uriInfo);
    }

    @Override
    public NormalizedNodeContext getLibraryVersion() {
        return this.delegRestService.getLibraryVersion();
    }
}

